/*
 * Decompiled with CFR 0.152.
 */
package sunw.hotjava.ui;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Vector;
import sunw.hotjava.ui.ListCanvas;
import sunw.hotjava.ui.ListContainerInfo;
import sunw.hotjava.ui.ListElement;
import sunw.hotjava.ui.ListItem;

public class ListContainer
extends ListItem {
    boolean closed = false;
    int INDENT = 10;
    Rectangle folderRect;
    Image img_open;
    Image img_closed;
    public ListContainerInfo total_contents;
    public ListCanvas listCanvas;
    public Vector contents = new Vector(10);

    public ListContainer(ListCanvas listCanvas, ListContainer listContainer, String string, Image image, Image image2) {
        super(listContainer, string);
        this.listCanvas = listCanvas;
        this.img_open = image;
        this.img_closed = image2;
        if (this.img_open != null) {
            this.icon_width = this.img_open.getWidth(this.canvas);
            this.icon_height = this.img_open.getHeight(this.canvas);
        }
    }

    public ListContainer(ListContainer listContainer, String string) {
        super(listContainer, string);
    }

    public void setListContainerImages(Image image, Image image2) {
        this.img_open = image;
        this.img_closed = image2;
        if (this.img_open != null) {
            this.icon_width = this.img_open.getWidth(this.canvas);
            this.icon_height = this.img_open.getHeight(this.canvas);
        }
    }

    public boolean doubleClick(int n, int n2) {
        Rectangle rectangle = new Rectangle(this.location.x, this.location.y + 3, this.icon_width, this.icon_height - 3);
        if (rectangle.inside(n, n2)) {
            this.closed = !this.closed;
        }
        return true;
    }

    public int getTotalContents() {
        if (this.total_contents == null) {
            return 0;
        }
        return this.total_contents.index;
    }

    public int getTotalWidth() {
        int n = 0;
        if (this.total_contents == null) {
            return 0;
        }
        int n2 = 0;
        while (n2 < this.contents.size()) {
            int n3;
            ListItem listItem = (ListItem)this.contents.elementAt(n2);
            Rectangle rectangle = listItem.getBoundingBox();
            if (rectangle != null && (n3 = rectangle.x + rectangle.width + 10) > n) {
                n = n3;
            }
            if (listItem instanceof ListContainer) {
                int n4;
                ListContainer listContainer = (ListContainer)listItem;
                if (!listContainer.closed && (n4 = listContainer.getTotalWidth()) > n) {
                    n = n4;
                }
            }
            ++n2;
        }
        return n;
    }

    public int getTotalHeight() {
        if (this.total_contents == null) {
            return 0;
        }
        return this.total_contents.size;
    }

    public void addItem(ListItem listItem) {
        this.addItem(listItem, -5);
    }

    public void addItem(ListItem listItem, int n) {
        if (n == -5) {
            this.contents.addElement(listItem);
            return;
        }
        this.contents.insertElementAt(listItem, n);
    }

    public ListElement addElement(String string) {
        return this.addElement(string, null);
    }

    public ListElement addElement(String string, Image image) {
        ListElement listElement = new ListElement(this, string, image);
        listElement.setCanvas(this.listCanvas);
        this.addItem(listElement);
        this.recalculatePositions();
        return listElement;
    }

    public ListContainer addContainer(String string) {
        return this.addContainer(string, this.img_open, this.img_closed);
    }

    public ListContainer addContainer(String string, Image image, Image image2) {
        ListContainer listContainer = new ListContainer(this.listCanvas, this, string, image, image2);
        listContainer.setCanvas(this.listCanvas);
        this.addItem(listContainer);
        this.recalculatePositions();
        return listContainer;
    }

    private void newLocation(ListItem listItem, int n) {
        int n2 = listItem.icon_height;
        if (listItem.getParentListContainer() != this.listCanvas.getMainContainer()) {
            listItem.location = new Point(this.location.x + this.INDENT, (n + 1) * n2 + this.location.y);
            return;
        }
        listItem.location = new Point(this.location.x + this.INDENT, n * n2 + this.location.y);
    }

    public void setContainerState(boolean bl) {
        this.closed = bl;
    }

    public final boolean closed() {
        return this.closed;
    }

    public void drawItem(Graphics graphics) {
        if (this.listCanvas.getMainContainer() != this) {
            this.drawItemOnCanvas(graphics);
        }
        if (this.grabbed()) {
            return;
        }
        if (this.closed) {
            return;
        }
        int n = 0;
        while (n < this.contents.size()) {
            ListItem listItem = (ListItem)this.contents.elementAt(n);
            listItem.drawItem(graphics);
            ++n;
        }
    }

    public void setAllBoundingBoxes(Graphics graphics) {
        int n = 0;
        while (n < this.contents.size()) {
            ListItem listItem = (ListItem)this.contents.elementAt(n);
            listItem.setBoundingBox(graphics);
            if (listItem instanceof ListContainer) {
                ((ListContainer)listItem).setAllBoundingBoxes(graphics);
            }
            ++n;
        }
    }

    public void drawChildren(Graphics graphics) {
        this.setContainerState(true);
        int n = 0;
        while (n < this.contents.size()) {
            ListItem listItem = (ListItem)this.contents.elementAt(n);
            listItem.drawItemOnCanvas(graphics);
            ++n;
        }
    }

    public void drawItemOnCanvas(Graphics graphics) {
        Point point = this.location;
        int n = point.x;
        int n2 = point.y;
        boolean bl = true;
        this.setBoundingBox(graphics);
        this.showBackground(graphics);
        if (this.img_closed == null || this.img_open == null) {
            bl = false;
        }
        graphics.setColor(Color.black);
        if (bl) {
            if (this.closed) {
                graphics.drawImage(this.img_closed, n, n2, this.canvas);
            } else {
                graphics.drawImage(this.img_open, n, n2, this.canvas);
            }
        }
        graphics.drawString(this.text, n + this.icon_width, n2 + this.icon_height);
    }

    public ListItem locateItem(int n, int n2) {
        int n3 = 0;
        while (n3 < this.contents.size()) {
            ListItem listItem;
            ListContainer listContainer;
            ListItem listItem2 = (ListItem)this.contents.elementAt(n3);
            if (listItem2.inside(n, n2)) {
                return listItem2;
            }
            if (listItem2 instanceof ListContainer && !(listContainer = (ListContainer)listItem2).closed() && (listItem = listContainer.locateItem(n, n2)) != null) {
                return listItem;
            }
            ++n3;
        }
        return null;
    }

    public ListItem locateItemOnDrag(int n, int n2) {
        int n3 = 0;
        while (n3 < this.contents.size()) {
            ListItem listItem;
            ListContainer listContainer;
            ListItem listItem2 = (ListItem)this.contents.elementAt(n3);
            if (listItem2.insideOnDrag(n, n2)) {
                return listItem2;
            }
            if (listItem2 instanceof ListContainer && !(listContainer = (ListContainer)listItem2).closed() && (listItem = listContainer.locateItemOnDrag(n, n2)) != null) {
                return listItem;
            }
            ++n3;
        }
        return null;
    }

    public boolean resolveItemLocation(ListItem listItem, Point point) {
        if (this.intersects(point) && listItem != this) {
            listItem.removeMyself();
            this.contents.insertElementAt(listItem, 0);
            this.total_contents = this.recalculatePositions();
            listItem.setParentListContainer(this);
            return true;
        }
        if (this.closed()) {
            return false;
        }
        int n = 0;
        while (n < this.contents.size()) {
            ListContainer listContainer;
            ListItem listItem2 = (ListItem)this.contents.elementAt(n);
            if (listItem2 instanceof ListContainer) {
                ListContainer listContainer2;
                listContainer = (ListContainer)listItem2;
                if (!(listItem instanceof ListContainer && this.checkParentage(listContainer2 = (ListContainer)listItem, listContainer) || !listContainer.resolveItemLocation(listItem, point))) {
                    this.total_contents = this.recalculatePositions();
                    return true;
                }
            } else if (listItem2.intersects(point) && listItem != listItem2) {
                if (listItem instanceof ListContainer && this.checkParentage(listContainer = (ListContainer)listItem, this)) {
                    this.total_contents = this.recalculatePositions();
                    return true;
                }
                listContainer = listItem.getParentListContainer();
                if (listContainer != this) {
                    this.contents.insertElementAt(listItem, n);
                    listItem.removeMyself();
                    listItem.setParentListContainer(this);
                } else {
                    int n2 = this.contents.indexOf(listItem);
                    if (n2 > n) {
                        this.contents.insertElementAt(listItem, n);
                        this.contents.removeElementAt(n2 + 1);
                    } else {
                        this.contents.insertElementAt(listItem, n + 1);
                        this.contents.removeElement(listItem);
                    }
                    listItem.setParentListContainer(this);
                }
                this.total_contents = this.recalculatePositions();
                return true;
            }
            ++n;
        }
        this.total_contents = this.recalculatePositions();
        return false;
    }

    public ListContainerInfo recalculatePositions() {
        ListContainerInfo listContainerInfo = null;
        try {
            listContainerInfo = new ListContainerInfo();
            int n = 0;
            while (n < this.contents.size()) {
                ListItem listItem = (ListItem)this.contents.elementAt(n);
                this.newLocation(listItem, listContainerInfo.index);
                if (listItem instanceof ListContainer) {
                    ListContainer listContainer = (ListContainer)listItem;
                    if (listContainer.closed()) {
                        ++listContainerInfo.index;
                        listContainerInfo.size += listItem.getHeight();
                    } else {
                        listContainer.INDENT = this.INDENT + 10;
                        ListContainerInfo listContainerInfo2 = listContainer.recalculatePositions();
                        listContainerInfo.index += listContainerInfo2.index + 1;
                        listContainerInfo.size += listContainerInfo2.size + listItem.getHeight();
                    }
                } else {
                    ++listContainerInfo.index;
                    listContainerInfo.size += listItem.getHeight();
                }
                ++n;
            }
            this.total_contents = listContainerInfo;
        }
        catch (Exception exception) {
            System.out.println("recalc: " + exception);
        }
        return listContainerInfo;
    }

    public ListContainerInfo recalculatePositions(boolean bl) {
        ListContainerInfo listContainerInfo = null;
        try {
            listContainerInfo = new ListContainerInfo();
            int n = 0;
            while (n < this.contents.size()) {
                ListItem listItem = (ListItem)this.contents.elementAt(n);
                this.newLocation(listItem, listContainerInfo.index);
                if (listItem instanceof ListContainer) {
                    ListContainer cfr_ignored_0 = (ListContainer)listItem;
                    ++listContainerInfo.index;
                    listContainerInfo.size += listItem.getHeight();
                } else {
                    ++listContainerInfo.index;
                    listContainerInfo.size += listItem.getHeight();
                }
                ++n;
            }
            this.total_contents = listContainerInfo;
        }
        catch (Exception exception) {
            System.out.println("recalc: " + exception);
        }
        return listContainerInfo;
    }

    public boolean checkParentage(ListContainer listContainer, ListContainer listContainer2) {
        ListContainer listContainer3 = listContainer2;
        while (listContainer3 != null) {
            if (listContainer == listContainer3) {
                return true;
            }
            listContainer3 = listContainer3.getParentListContainer();
        }
        return false;
    }

    public void setClosedValue(boolean bl) {
        this.closed = bl;
    }

    public boolean removeItem(ListItem listItem) {
        if (this.contents.removeElement(listItem)) {
            return true;
        }
        int n = 0;
        while (n < this.contents.size()) {
            ListContainer listContainer;
            ListItem cfr_ignored_0 = (ListItem)this.contents.elementAt(n);
            if (listItem instanceof ListContainer && (listContainer = (ListContainer)listItem).removeItem(listItem)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public void setListCanvas(ListCanvas listCanvas) {
        this.listCanvas = listCanvas;
    }

    public Vector getContents() {
        return this.contents;
    }

    public String toString() {
        return "ListContainer [text=" + this.text + ", boundingBox = " + this.boundingBox + ", closed=" + this.closed + ", location =" + this.location + "]";
    }
}

