/*
 * Decompiled with CFR 0.152.
 */
package sunw.hotjava.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Point;
import java.awt.ScrollPane;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import sunw.hotjava.ui.DragAndDropEvent;
import sunw.hotjava.ui.Folder;
import sunw.hotjava.ui.HotList;
import sunw.hotjava.ui.HotListEntry;
import sunw.hotjava.ui.HotListFrame;
import sunw.hotjava.ui.ListCanvas;
import sunw.hotjava.ui.ListItem;
import sunw.hotjava.ui.PageFolder;
import sunw.hotjava.ui.Separator;
import sunw.hotjava.ui.Webmark;

public class HotCanvas
extends ListCanvas {
    HotList hotlist;
    Folder hotFolder;
    HotListFrame frm;
    ComponentListener componentEventsListener;

    public HotCanvas(HotList hotList, Panel panel, String string, int n, int n2) {
        super(panel, string, n, n2);
        this.hotlist = hotList;
        this.setSize(n, n2);
        this.componentEventsListener = new 1();
    }

    public HotCanvas(HotList hotList, Panel panel, String string, int n, int n2, HotListFrame hotListFrame) {
        super(panel, string, n, n2);
        this.hotlist = hotList;
        this.frm = hotListFrame;
        this.setSize(n, n2);
        this.componentEventsListener = new 2();
    }

    public void createInitialFolder() {
        try {
            String string = this.getTitle();
            this.getOpenContainerImage();
            this.getClosedContainerImage();
            this.hotFolder = new Folder(this, null, string);
            this.setMainContainer(this.hotFolder);
            this.hotFolder.setCanvas(this);
            return;
        }
        catch (Exception exception) {
            System.out.println("CreateInit: " + exception);
            return;
        }
    }

    public void createInitialFolder(Folder folder) {
        try {
            String string = this.getTitle();
            Image image = this.getOpenContainerImage();
            Image image2 = this.getClosedContainerImage();
            this.hotFolder = new Folder(this, folder, string, image, image2);
            this.setMainContainer(this.hotFolder);
            this.hotFolder.setCanvas(this);
            return;
        }
        catch (Exception exception) {
            System.out.println("CreateInit: " + exception);
            return;
        }
    }

    public void initialize(PageFolder pageFolder) {
        this.hotFolder.initialize(pageFolder);
        this.hotFolder.recalculatePositions();
        this.hotFolder.setHotListEntry(pageFolder);
        Graphics graphics = this.getGraphics();
        if (graphics != null) {
            try {
                this.hotFolder.setAllBoundingBoxes(graphics);
            }
            finally {
                Object var4_3 = null;
                graphics.dispose();
            }
        }
        this.adjustSize();
    }

    public HotList getHotList() {
        return this.hotlist;
    }

    public void addEntry(HotListEntry hotListEntry) {
        try {
            Folder folder = null;
            this.dbg("addEntry");
            folder = (Folder)this.getSelectedItemFolder();
            HotListEntry hotListEntry2 = folder.getHotListEntry();
            if (hotListEntry.getParent() != hotListEntry2) {
                Folder folder2 = (Folder)folder.getParentListContainer().getParentListContainer();
                while (folder2 != null && !folder2.isTopList()) {
                    folder = (Folder)folder.getParentListContainer();
                    folder2 = (Folder)folder2.getParentListContainer();
                }
                if (folder.getHotListEntry() != hotListEntry.getParent()) {
                    return;
                }
            }
            if (hotListEntry instanceof Webmark) {
                folder.addBookmark(folder, (Webmark)hotListEntry);
            } else if (hotListEntry instanceof PageFolder) {
                folder.addFolder(folder, (PageFolder)hotListEntry);
            } else if (hotListEntry instanceof Separator) {
                folder.addSeparator(folder, (Separator)hotListEntry);
            }
            this.hotFolder.recalculatePositions();
            this.adjustSize();
            this.repaint();
            return;
        }
        catch (Exception exception) {
            System.out.println("addEntry: " + exception);
            return;
        }
    }

    public void changeFolderState(HotListEntry hotListEntry) {
        ListItem listItem = this.hotFolder.findEntrySibling(hotListEntry);
        if (listItem == null) {
            return;
        }
        if (!(listItem instanceof Folder)) {
            return;
        }
        Folder folder = (Folder)listItem;
        if (!(hotListEntry instanceof PageFolder)) {
            return;
        }
        PageFolder pageFolder = (PageFolder)hotListEntry;
        folder.setClosedValue(pageFolder.closed());
    }

    public void delItem(HotListEntry hotListEntry) {
        ListItem listItem = this.hotFolder.findEntrySibling(hotListEntry);
        if (listItem == null) {
            return;
        }
        listItem.removeMyself();
        this.setCurrentItem(null);
        this.setSelectedItem(null);
        this.hotFolder.recalculatePositions();
        this.adjustSize();
        this.repaint();
    }

    protected void redispatchEvent(MouseEvent mouseEvent) {
        Panel panel = this.frm.getContainingPanelForCanvas(this);
        if (panel != null) {
            Point point = panel.getLocation();
            mouseEvent.translatePoint(point.x, point.y - this.getAdjustmentFactor());
            panel.dispatchEvent(mouseEvent);
        }
    }

    public boolean mousePressedOnCanvas(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        boolean bl = super.mousePressedOnCanvas(mouseEvent);
        if (mouseEvent.getClickCount() == 2) {
            ListItem listItem = this.mainFolder.locateItem(point.x, point.y);
            if (listItem == null) {
                return bl;
            }
            if (!listItem.doubleClick(point.x, point.y)) {
                this.redispatchEvent(mouseEvent);
                return false;
            }
            this.mainFolder.recalculatePositions();
            this.adjustSize();
        }
        this.frm.selectCanvas(this);
        return bl;
    }

    public boolean mouseDraggedOnCanvas(MouseEvent mouseEvent) {
        if (!this.frm.readOnlyList) {
            super.mouseDraggedOnCanvas(mouseEvent);
            this.redispatchEvent(mouseEvent);
        }
        return true;
    }

    public boolean mouseReleasedOnCanvas(MouseEvent mouseEvent) {
        super.mouseReleasedOnCanvas(mouseEvent);
        this.redispatchEvent(mouseEvent);
        return true;
    }

    public boolean processDragAndDropEvent(DragAndDropEvent dragAndDropEvent) {
        Component component = (Component)dragAndDropEvent.getSource();
        switch (dragAndDropEvent.getID()) {
            case 91959: {
                Panel panel;
                Panel panel2;
                if (!(component instanceof Panel) || (panel2 = (Panel)component) != (panel = this.frm.getContainingPanelForCanvas(this))) break;
                return super.processDragAndDropEvent(dragAndDropEvent);
            }
            case 91962: {
                if (!(component instanceof Panel)) break;
                Panel panel = (Panel)component;
                Panel panel3 = this.frm.getContainingPanelForCanvas(this);
                if (panel == panel3) {
                    return super.processDragAndDropEvent(dragAndDropEvent);
                }
                Graphics graphics = this.getGraphics();
                try {
                    this.eraseHiliteBox(graphics);
                    break;
                }
                finally {
                    Object var7_8 = null;
                    graphics.dispose();
                }
            }
        }
        return true;
    }

    protected Point getAdjustedLocation(Point point) {
        ScrollPane scrollPane = this.findScrollPane();
        Point point2 = new Point();
        point2.x = point.x;
        point2.y = point.y;
        if (scrollPane != null) {
            Point point3 = scrollPane.getScrollPosition();
            point2.y -= point3.y;
            return point2;
        }
        return point;
    }

    public ScrollPane findScrollPane() {
        Container container = this.getParent();
        while (container != null) {
            if (container instanceof ScrollPane) {
                return (ScrollPane)container;
            }
            container = container.getParent();
        }
        return null;
    }

    public ComponentListener getListener() {
        return this.componentEventsListener;
    }

    private final class 1
    extends ComponentAdapter {
        public void componentResized(ComponentEvent componentEvent) {
            HotCanvas.this.adjustSize();
        }

        /* synthetic */ 1() {
        }
    }

    private final class 2
    extends ComponentAdapter {
        public void componentResized(ComponentEvent componentEvent) {
            HotCanvas.this.adjustSize();
        }

        /* synthetic */ 2() {
        }
    }
}

