/*
 * Decompiled with CFR 0.152.
 */
package sunw.hotjava.ui;

import java.awt.Component;
import java.awt.MenuItem;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.event.ActionListener;
import sunw.hotjava.bean.DocumentStacker;
import sunw.hotjava.doc.ElementInfo;
import sunw.hotjava.misc.HJBProperties;

public class HJPopupMenu
extends PopupMenu {
    private static HJBProperties props;
    private boolean isShowing;
    private Component parentComponent;
    private MenuItem back;
    private MenuItem forward;
    private MenuItem open;
    private MenuItem pageSource;
    private MenuItem openLink;
    private MenuItem rememberLink;
    private MenuItem openLinkInNewFrame;
    private MenuItem saveLink;
    private MenuItem openImage;
    private MenuItem saveImage;
    private MenuItem openImageInNewFrame;
    private MenuItem frameSource;
    private MenuItem openFrameInNewWindow;
    private DocumentStacker stacker;

    public HJPopupMenu(Component component, ActionListener actionListener, DocumentStacker documentStacker) {
        super(HJPopupMenu.title());
        props = HJBProperties.getHJBProperties("hjbrowser");
        this.parentComponent = component;
        this.stacker = documentStacker;
        this.createImageMenuItems(actionListener);
        this.createLinkMenuItems(actionListener);
        this.createFrameMenuItems(actionListener);
        this.createStandardMenuItems(actionListener);
    }

    private static String title() {
        props = HJBProperties.getHJBProperties("hjbrowser");
        String string = props.getProperty("hotjava.popupMenu.title");
        if (string == null) {
            return "HotJava Commands";
        }
        int n = string.indexOf(124);
        if (n >= 0) {
            return string.substring(0, n);
        }
        return string;
    }

    public synchronized void show(ElementInfo elementInfo) {
        this.removeAll();
        if (elementInfo.hrefURL != null) {
            this.addLinkItems(elementInfo.hrefURL);
        }
        if (elementInfo.imageURL != null) {
            this.addImageItems(elementInfo.imageURL);
        }
        if (elementInfo.frameURL != null) {
            this.addFrameItems(elementInfo.frameURL);
        }
        this.addStandardItems(elementInfo.frameURL == null);
        this.parentComponent.add(this);
        Point point = this.parentComponent.getLocationOnScreen();
        Point point2 = elementInfo.event.getComponent().getLocationOnScreen();
        point.x = point2.x - point.x + elementInfo.event.getX();
        point.y = point2.y - point.y + elementInfo.event.getY();
        super.show(this.parentComponent, point.x, point.y);
    }

    private void addStandardItems(boolean bl) {
        this.add(this.back);
        if (this.stacker.isPreviousAvailable()) {
            this.back.enable();
        } else {
            this.back.disable();
        }
        this.add(this.forward);
        if (this.stacker.isNextAvailable()) {
            this.forward.enable();
        } else {
            this.forward.disable();
        }
        this.add(this.open);
        if (bl) {
            this.add(this.pageSource);
        }
    }

    private void addImageItems(String string) {
        this.add(this.openImage);
        this.add(this.saveImage);
        this.add(this.openImageInNewFrame);
        this.addSeparator();
        this.openImage.setActionCommand("go " + string);
        this.openImageInNewFrame.setActionCommand("clonego " + string);
        this.saveImage.setActionCommand("savefile " + string);
        string = string.substring(string.lastIndexOf("/") + 1);
        this.saveImage.setLabel(props.getPropertyReplace("hotjava.imageMenu.save", string));
    }

    private void addLinkItems(String string) {
        this.add(this.openLink);
        this.add(this.rememberLink);
        this.add(this.openLinkInNewFrame);
        this.add(this.saveLink);
        this.addSeparator();
        this.openLink.setActionCommand("go " + string);
        this.openLinkInNewFrame.setActionCommand("clonego " + string);
        this.saveLink.setActionCommand("savefile " + string);
        this.rememberLink.setActionCommand("remember " + string);
        string = string.substring(string.lastIndexOf("/") + 1);
        this.saveLink.setLabel(props.getPropertyReplace("hotjava.linkMenu.save", string));
    }

    private void addFrameItems(String string) {
        this.add(this.frameSource);
        this.frameSource.setActionCommand("framesource");
        this.add(this.openFrameInNewWindow);
        this.openFrameInNewWindow.setActionCommand("clonego " + string);
        this.addSeparator();
    }

    private void createStandardMenuItems(ActionListener actionListener) {
        this.back = this.createMenuItem("hotjava.navigationMenu.back", "back");
        this.back.addActionListener(actionListener);
        this.forward = this.createMenuItem("hotjava.navigationMenu.forward", "forward");
        this.forward.addActionListener(actionListener);
        this.open = this.createMenuItem("hotjava.navigationMenu.showgotoplacedialog", "");
        this.open.addActionListener(actionListener);
        this.open.setActionCommand("showgotoplacedialog");
        this.pageSource = this.createMenuItem("hotjava.navigationMenu.pageSource", "");
        this.pageSource.addActionListener(actionListener);
        this.pageSource.setActionCommand("source");
    }

    private void createLinkMenuItems(ActionListener actionListener) {
        this.openLink = this.createMenuItem("hotjava.linkMenu.open", "");
        this.openLink.addActionListener(actionListener);
        this.rememberLink = this.createMenuItem("hotjava.linkMenu.remember", "");
        this.rememberLink.addActionListener(actionListener);
        this.openLinkInNewFrame = this.createMenuItem("hotjava.linkMenu.openClone", "");
        this.openLinkInNewFrame.addActionListener(actionListener);
        this.saveLink = this.createMenuItem("hotjava.linkMenu.save", "");
        this.saveLink.addActionListener(actionListener);
    }

    private void createImageMenuItems(ActionListener actionListener) {
        this.openImage = this.createMenuItem("hotjava.imageMenu.open", "");
        this.openImage.addActionListener(actionListener);
        this.saveImage = this.createMenuItem("hotjava.imageMenu.save", "");
        this.saveImage.addActionListener(actionListener);
        this.openImageInNewFrame = this.createMenuItem("hotjava.imageMenu.openClone", "");
        this.openImageInNewFrame.addActionListener(actionListener);
    }

    private void createFrameMenuItems(ActionListener actionListener) {
        this.frameSource = this.createMenuItem("hotjava.frameMenu.viewSource", "");
        this.frameSource.addActionListener(actionListener);
        this.openFrameInNewWindow = this.createMenuItem("hotjava.frameMenu.openClone", "");
        this.openFrameInNewWindow.addActionListener(actionListener);
    }

    private MenuItem createMenuItem(String string, String string2) {
        String string3 = props.getProperty(string);
        MenuItem menuItem = new MenuItem(string3);
        menuItem.setActionCommand(string2);
        return menuItem;
    }
}

