/*
 * Decompiled with CFR 0.152.
 */
package sunw.hotjava.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.TextComponent;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import sunw.hotjava.HJFrame;
import sunw.hotjava.bean.HTMLBrowsable;
import sunw.hotjava.misc.HJBProperties;
import sunw.hotjava.ui.GoToPlaceDialogButtonPane;
import sunw.hotjava.ui.GoToPlaceDialogFormPane;
import sunw.hotjava.ui.UIHJButton;
import sunw.hotjava.ui.UIHJButtonGroup;
import sunw.hotjava.ui.UserDialog;
import sunw.hotjava.ui.UserFileDialog;
import sunw.hotjava.ui.UserLabel;
import sunw.hotjava.ui.UserTextField;

public class GoToPlaceDialog
extends UserDialog
implements ActionListener {
    private UserTextField textField;
    private UIHJButton goButton;
    private UIHJButton clearButton;
    private UIHJButton dismissButton;
    private UIHJButton fileButton;
    private HTMLBrowsable bean;
    private HJBProperties properties;
    private static String fileDialogDirectory = null;

    public GoToPlaceDialog(String string, HJFrame hJFrame, HJBProperties hJBProperties) {
        this(string, hJFrame, false, hJBProperties);
    }

    public GoToPlaceDialog(String string, HJFrame hJFrame, boolean bl, HJBProperties hJBProperties) {
        super(string, hJFrame, bl, hJBProperties);
        this.bean = hJFrame.getHTMLBrowsable();
        this.properties = hJBProperties;
        this.init();
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl) {
            this.textField.requestFocus();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.textField || object == this.goButton) {
            this.goTo();
        }
        if (object == this.clearButton) {
            this.clear();
        }
        if (object == this.dismissButton) {
            this.dismiss();
        }
        if (object == this.fileButton) {
            this.getFile();
        }
    }

    private void goTo() {
        String string = this.textField.getText();
        if (!string.equals("")) {
            this.bean.setDocumentString(string);
            this.dismiss();
            return;
        }
        Toolkit.getDefaultToolkit().beep();
    }

    private void clear() {
        ((TextComponent)this.textField).setText("");
        this.textField.requestFocus();
    }

    private void dismiss() {
        ((Component)this).hide();
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.initFormPane();
        this.initButtonsPane();
        this.pack();
        this.centerOnScreen();
    }

    private void initFormPane() {
        GoToPlaceDialogFormPane goToPlaceDialogFormPane = new GoToPlaceDialogFormPane();
        goToPlaceDialogFormPane.setLayout(new FlowLayout());
        UserLabel userLabel = new UserLabel("gotodialog.label");
        goToPlaceDialogFormPane.add(userLabel);
        this.textField = new UserTextField("gotodialog.text");
        goToPlaceDialogFormPane.add(this.textField);
        this.textField.addActionListener(this);
        this.fileButton = new UIHJButton("gotodialog.file", this.props);
        goToPlaceDialogFormPane.add(this.fileButton);
        this.fileButton.addActionListener(this);
        this.add("Center", goToPlaceDialogFormPane);
    }

    private void initButtonsPane() {
        GoToPlaceDialogButtonPane goToPlaceDialogButtonPane = new GoToPlaceDialogButtonPane();
        UIHJButtonGroup uIHJButtonGroup = new UIHJButtonGroup(this.props);
        goToPlaceDialogButtonPane.setLayout(new FlowLayout(2));
        this.goButton = new UIHJButton("gotodialog.go", this.props);
        goToPlaceDialogButtonPane.add(this.goButton);
        uIHJButtonGroup.addButtonToGroup(this.goButton);
        this.goButton.addActionListener(this);
        this.clearButton = new UIHJButton("gotodialog.clear", this.props);
        goToPlaceDialogButtonPane.add(this.clearButton);
        uIHJButtonGroup.addButtonToGroup(this.clearButton);
        this.clearButton.addActionListener(this);
        this.dismissButton = new UIHJButton("gotodialog.dismiss", this.props);
        goToPlaceDialogButtonPane.add(this.dismissButton);
        uIHJButtonGroup.addButtonToGroup(this.dismissButton);
        this.dismissButton.addActionListener(this);
        this.add("South", goToPlaceDialogButtonPane);
    }

    private void getFile() {
        String string;
        Frame frame = (Frame)this.getParent();
        UserFileDialog userFileDialog = new UserFileDialog(frame, "hotjava.opendialog");
        if (fileDialogDirectory != null) {
            userFileDialog.setDirectory(fileDialogDirectory);
        }
        ((Component)userFileDialog).setVisible(true);
        String string2 = userFileDialog.getFile();
        fileDialogDirectory = string = userFileDialog.getDirectory();
        if (string2 != null) {
            String string3 = "file:" + string + string2;
            string3 = string3.replace(File.separatorChar, '/');
            ((TextComponent)this.textField).setText(string3);
        }
    }
}

