/*
 * Decompiled with CFR 0.152.
 */
package sunw.hotjava.ui;

import java.awt.BorderLayout;
import java.awt.Panel;
import java.awt.Point;
import java.awt.ScrollPane;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.net.MalformedURLException;
import java.net.URL;
import sunw.hotjava.HJFrame;
import sunw.hotjava.HJWindowManager;
import sunw.hotjava.misc.HJBProperties;
import sunw.hotjava.ui.Bookmark;
import sunw.hotjava.ui.HotCanvas;
import sunw.hotjava.ui.HotList;
import sunw.hotjava.ui.HotListEntry;
import sunw.hotjava.ui.HotListEvent;
import sunw.hotjava.ui.HotListFrame;
import sunw.hotjava.ui.HotListListener;
import sunw.hotjava.ui.ListItem;
import sunw.hotjava.ui.Webmark;

class FolderPanel
extends Panel {
    HotListFrame frm;
    HotCanvas hotCanvas;
    HotList hotlist;
    Panel folderPanel;
    ScrollPane folderPane;
    static final String propName = "hotlistframe";
    static boolean dragged;

    public FolderPanel(HotListFrame hotListFrame) {
        this.frm = hotListFrame;
        this.setLayout(new BorderLayout());
        this.folderPanel = new Panel();
        this.folderPane = new ScrollPane();
        this.folderPane.add(this.folderPanel);
        this.add("Center", this.folderPane);
        HJBProperties hJBProperties = HJBProperties.getHJBProperties("hjbrowser");
        this.folderPanel.setBackground(hJBProperties.getColor("hotlistframe.bgcolor", null));
        this.folderPane.setBackground(hJBProperties.getColor("hotjava.background", null));
    }

    public HotCanvas getCanvas() {
        return this.hotCanvas;
    }

    public void initialize() {
        this.hotlist = this.frm.getHotList();
        String string = this.frm.getListName();
        int n = this.getSize().width;
        int n2 = this.getSize().height;
        this.hotCanvas = new HotCanvas(this.hotlist, this.folderPanel, string, n, n2, this.frm);
        ComponentListener componentListener = this.hotCanvas.getListener();
        this.folderPane.addComponentListener(componentListener);
        this.hotCanvas.setListElementImage(this.frm.getBookImage());
        this.hotCanvas.setListContainerImages(this.frm.getOpenImage(), this.frm.getClosedImage());
        this.invalidate();
        this.folderPanel.setLayout(new BorderLayout());
        this.folderPanel.add("West", this.hotCanvas);
        this.folderPanel.setSize(this.hotCanvas.getPreferredSize());
        this.validate();
        1 var5_5 = new 1();
        this.addMouseListener(var5_5);
        2 var6_6 = new 2();
        this.addMouseMotionListener(var6_6);
        this.hotlist.addHotListListener(new HotListEventListener());
    }

    private void redispatchEvent(MouseEvent mouseEvent) {
        Point point = mouseEvent.getComponent().getLocation();
        mouseEvent.translatePoint(point.x, point.y);
        this.frm.dispatchEvent(mouseEvent);
    }

    public ScrollPane getFolderPane() {
        return this.folderPane;
    }

    public boolean processHotListEvent(HotListEvent hotListEvent) {
        Object object = hotListEvent.getArgument();
        HotListEntry hotListEntry = (HotListEntry)object;
        switch (hotListEvent.getID()) {
            case 50: {
                if (this.hotCanvas.getMainContainer() == null) break;
                this.hotCanvas.addEntry(hotListEntry);
                break;
            }
            case 51: {
                this.hotCanvas.delItem(hotListEntry);
                break;
            }
            case 52: {
                this.hotCanvas.changeFolderState(hotListEntry);
                break;
            }
        }
        return true;
    }

    public void processFolderPanelMouseEvent(MouseEvent mouseEvent) {
        switch (mouseEvent.getID()) {
            case 501: {
                if (mouseEvent.getClickCount() == 2 && !dragged) {
                    this.visitDocument(mouseEvent.isShiftDown());
                    return;
                }
            }
            case 502: {
                ListItem listItem = this.hotCanvas.getSelectedItem();
                if (listItem != null && listItem instanceof Bookmark) {
                    Bookmark bookmark = (Bookmark)listItem;
                    Webmark webmark = bookmark.getWebmark();
                    String string = webmark.getURL();
                    this.frm.setMessage(string);
                } else {
                    this.frm.setMessage("");
                }
                this.redispatchEvent(mouseEvent);
                dragged = false;
                return;
            }
            case 506: {
                this.redispatchEvent(mouseEvent);
                dragged = true;
                return;
            }
        }
    }

    public void visitDocument(boolean bl) {
        ListItem listItem = this.hotCanvas.getSelectedItem();
        if (listItem == null) {
            return;
        }
        if (!(listItem instanceof Bookmark)) {
            return;
        }
        Bookmark bookmark = (Bookmark)listItem;
        Webmark webmark = bookmark.getWebmark();
        try {
            URL uRL = new URL(webmark.getURL());
            HJFrame hJFrame = HJWindowManager.getHJWindowManager().getLastFocusHolder();
            if (bl || hJFrame == null) {
                HJWindowManager.getHJWindowManager().cloneFrame(hJFrame, uRL);
                return;
            }
            hJFrame.getHTMLBrowsable().setDocumentURL(uRL);
            return;
        }
        catch (MalformedURLException malformedURLException) {
            return;
        }
    }

    public void notify(int n, Object object) {
    }

    private class HotListEventListener
    implements HotListListener {
        public void hotlistChanged(HotListEvent hotListEvent) {
            FolderPanel.this.processHotListEvent(hotListEvent);
        }

        HotListEventListener() {
            FolderPanel.this = FolderPanel.this;
        }
    }

    private final class 1
    extends MouseAdapter {
        public void mousePressed(MouseEvent mouseEvent) {
            FolderPanel.this.processFolderPanelMouseEvent(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            FolderPanel.this.processFolderPanelMouseEvent(mouseEvent);
        }

        /* synthetic */ 1() {
        }
    }

    private final class 2
    extends MouseMotionAdapter {
        public void mouseDragged(MouseEvent mouseEvent) {
            FolderPanel.this.processFolderPanelMouseEvent(mouseEvent);
        }

        /* synthetic */ 2() {
        }
    }
}

