/*
 * Decompiled with CFR 0.152.
 */
package sunw.hotjava.ui;

import java.awt.Component;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Vector;
import sunw.hotjava.ui.Bookmark;
import sunw.hotjava.ui.EntrySeparator;
import sunw.hotjava.ui.HotCanvas;
import sunw.hotjava.ui.HotList;
import sunw.hotjava.ui.HotListEntry;
import sunw.hotjava.ui.HotListFrame;
import sunw.hotjava.ui.ListCanvas;
import sunw.hotjava.ui.ListContainer;
import sunw.hotjava.ui.ListItem;
import sunw.hotjava.ui.PageFolder;
import sunw.hotjava.ui.Separator;
import sunw.hotjava.ui.Webmark;

public class Folder
extends ListContainer {
    HotListEntry entry;

    public Folder(HotCanvas hotCanvas, Folder folder, String string, Image image, Image image2) {
        super(folder, string);
        this.setListCanvas(hotCanvas);
        this.setListContainerImages(image, image2);
    }

    public Folder(HotCanvas hotCanvas, Folder folder, String string) {
        super(folder, string);
        this.setListCanvas(hotCanvas);
    }

    public Folder(ListCanvas listCanvas, Folder folder, PageFolder pageFolder, Image image, Image image2) {
        super(folder, pageFolder.title);
        this.setListCanvas(listCanvas);
        this.entry = pageFolder;
        this.setContainerState(pageFolder.closed());
        this.setListContainerImages(image, image2);
    }

    public PageFolder getPageFolder() {
        return (PageFolder)this.entry;
    }

    public void initialize(PageFolder pageFolder) {
        Vector vector = pageFolder.getContents();
        if (vector == null) {
            return;
        }
        int n = 0;
        while (n < vector.size()) {
            HotListEntry hotListEntry = (HotListEntry)vector.elementAt(n);
            if (hotListEntry instanceof Webmark) {
                this.addBookmark(this, (Webmark)hotListEntry);
            }
            if (hotListEntry instanceof Separator) {
                this.addSeparator(this, (Separator)hotListEntry);
            }
            if (hotListEntry instanceof PageFolder) {
                Folder folder = this.addFolder(this, (PageFolder)hotListEntry);
                folder.initialize((PageFolder)hotListEntry);
            }
            ++n;
        }
    }

    public boolean removeItem(ListItem listItem) {
        if (this.contents.removeElement(listItem)) {
            return true;
        }
        int n = 0;
        while (n < this.contents.size()) {
            Folder folder;
            ListItem cfr_ignored_0 = (ListItem)this.contents.elementAt(n);
            if (listItem instanceof Folder && (folder = (Folder)listItem).removeItem(listItem)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean resolveItemLocation(ListItem listItem, Point point) {
        HotList hotList = HotList.getHotList();
        HotListFrame hotListFrame = HotListFrame.getHotListFrame();
        if (this.intersectsOnDrop(point) && listItem != this) {
            Component component = listItem.getCanvas();
            hotList.reparent(this.getHotListEntry(listItem), (PageFolder)this.entry, 0);
            this.total_contents = this.recalculatePositions();
            hotListFrame.updateCanvas(component, (Folder)listItem.getParentListContainer());
            listItem.setParentListContainer(this);
            hotList.exportHTMLFile();
            return true;
        }
        if (this.closed() && !this.isTopList()) {
            return false;
        }
        int n = 0;
        while (n < this.contents.size()) {
            ListContainer listContainer;
            ListItem listItem2 = (ListItem)this.contents.elementAt(n);
            if (listItem2 instanceof Folder) {
                Folder folder;
                listContainer = (Folder)listItem2;
                if (!(listItem instanceof Folder && this.checkParentage(folder = (Folder)listItem, listContainer) || !listContainer.resolveItemLocation(listItem, point))) {
                    this.total_contents = this.isTopList() ? this.recalculatePositions(true) : this.recalculatePositions();
                    return true;
                }
            } else if (listItem2.intersectsOnDrop(point) && listItem != listItem2) {
                if (listItem instanceof Folder && this.checkParentage(listContainer = (Folder)listItem, this)) {
                    this.total_contents = this.recalculatePositions();
                    return true;
                }
                listContainer = listItem.getParentListContainer();
                if (listContainer != this || this.contents.indexOf(listItem) > n) {
                    hotList.reparent(this.getHotListEntry(listItem), (PageFolder)this.entry, n);
                } else {
                    hotList.reparent(this.getHotListEntry(listItem), (PageFolder)this.entry, n - 1);
                }
                this.total_contents = this.recalculatePositions();
                hotListFrame.updateCanvas(listItem.getCanvas(), this);
                listItem.setParentListContainer(this);
                hotList.exportHTMLFile();
                return true;
            }
            ++n;
        }
        this.total_contents = this.recalculatePositions();
        return false;
    }

    public boolean isTopList() {
        ListContainer listContainer = this.getParentListContainer();
        return listContainer == null;
    }

    public boolean doubleClick(int n, int n2) {
        this.getWidth();
        this.getHeight();
        Rectangle rectangle = this.getBoundingBox();
        HotCanvas hotCanvas = (HotCanvas)this.listCanvas;
        HotList hotList = hotCanvas.getHotList();
        if (rectangle.inside(n, n2)) {
            if (this.closed()) {
                hotList.changeFolderValue(this.entry, false);
            } else {
                hotList.changeFolderValue(this.entry, true);
            }
        }
        return true;
    }

    public Folder addFolder(Folder folder, PageFolder pageFolder) {
        PageFolder pageFolder2 = pageFolder.getParent();
        int n = pageFolder2.getItemPos(pageFolder);
        if (n == -1) {
            n = -5;
        }
        Image image = this.listCanvas.getOpenContainerImage();
        Image image2 = this.listCanvas.getClosedContainerImage();
        Folder folder2 = new Folder(this.listCanvas, folder, pageFolder, image, image2);
        folder2.setCanvas(this.listCanvas);
        folder.addItem(folder2, n);
        return folder2;
    }

    public Bookmark addBookmark(Folder folder, Webmark webmark) {
        PageFolder pageFolder = webmark.getParent();
        int n = pageFolder.getItemPos(webmark);
        if (n == -1) {
            n = -5;
        }
        Bookmark bookmark = new Bookmark(folder, webmark, this.listCanvas.getListElementImage());
        bookmark.setCanvas(this.listCanvas);
        folder.addItem(bookmark, n);
        return bookmark;
    }

    public EntrySeparator addSeparator(Folder folder, Separator separator) {
        PageFolder pageFolder = separator.getParent();
        int n = pageFolder.getItemPos(separator);
        if (n == -1) {
            n = -5;
        }
        Image image = this.listCanvas.getListElementImage();
        EntrySeparator entrySeparator = new EntrySeparator(folder, separator, image);
        entrySeparator.setCanvas(this.listCanvas);
        folder.addItem(entrySeparator, n);
        return entrySeparator;
    }

    public ListItem findEntrySibling(HotListEntry hotListEntry) {
        int n = 0;
        while (n < this.contents.size()) {
            Folder folder;
            ListItem listItem;
            ListItem listItem2 = (ListItem)this.contents.elementAt(n);
            HotListEntry hotListEntry2 = this.getHotListEntry(listItem2);
            if (hotListEntry2 == hotListEntry) {
                return listItem2;
            }
            if (listItem2 instanceof Folder && (listItem = (folder = (Folder)listItem2).findEntrySibling(hotListEntry)) != null) {
                return listItem;
            }
            ++n;
        }
        return null;
    }

    public void setHotListEntry(HotListEntry hotListEntry) {
        this.entry = hotListEntry;
    }

    public HotListEntry getHotListEntry() {
        return this.entry;
    }

    private HotListEntry getHotListEntry(ListItem listItem) {
        HotListEntry hotListEntry = null;
        if (listItem instanceof Folder) {
            Folder folder = (Folder)listItem;
            hotListEntry = folder.entry;
        } else if (listItem instanceof Bookmark) {
            Bookmark bookmark = (Bookmark)listItem;
            hotListEntry = bookmark.entry;
        } else if (listItem instanceof EntrySeparator) {
            EntrySeparator entrySeparator = (EntrySeparator)listItem;
            hotListEntry = entrySeparator.entry;
        } else {
            System.out.println(" Invalid ListItem ");
        }
        return hotListEntry;
    }
}

