/*
 * Decompiled with CFR 0.152.
 */
package sunw.hotjava.ui;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Observable;
import java.util.Observer;
import sunw.hotjava.misc.ClockFormat;
import sunw.hotjava.misc.HJBProperties;

public class Clock
extends Canvas
implements Observer {
    HJBProperties props;
    Font font;
    private static int width;
    private static int height;
    private static final int hMargin = 10;
    private static final int vMargin = 4;
    private static final String DEFAULT_CLOCK_FORMAT = "MMM d', 'h:mm a";
    private static String clockPattern;

    Clock(Font font) {
        this.font = !font.isBold() ? new Font(font.getName(), 1, font.getSize()) : font;
        this.props = HJBProperties.getHJBProperties("hjbrowser");
    }

    public void start() {
        this.show();
    }

    public void stop() {
        this.hide();
    }

    public Dimension getPreferredSize() {
        String string = ClockFormat.getFormat(this.props.getProperty("hotjava.clock.format", DEFAULT_CLOCK_FORMAT));
        if (!string.equals(clockPattern)) {
            clockPattern = string;
            Graphics graphics = this.getGraphics();
            if (graphics != null) {
                try {
                    FontMetrics fontMetrics = this.getFontMetrics(this.font);
                    graphics.setFont(this.font);
                    width = fontMetrics.stringWidth(this.getCurrentTime()) + 10;
                    height = fontMetrics.getHeight() + 4;
                }
                finally {
                    Object var4_4 = null;
                    graphics.dispose();
                }
            }
        }
        return new Dimension(width, height);
    }

    public Dimension minimumSize() {
        return this.getPreferredSize();
    }

    public Insets getInsets() {
        return new Insets(0, 0, 0, 0);
    }

    public void paint(Graphics graphics) {
        Rectangle rectangle = this.getBounds();
        graphics.setColor(this.getBackground());
        graphics.getColor();
        Color color = new Color(102, 102, 102);
        Color color2 = new Color(226, 226, 226);
        graphics.setColor(color);
        graphics.drawRect(rectangle.x, rectangle.y, rectangle.width - 2, rectangle.height - 2);
        graphics.setColor(color2);
        graphics.drawRect(rectangle.x + 1, rectangle.y + 1, rectangle.width - 2, rectangle.height - 2);
        graphics.setColor(new Color(0, 0, 127));
        graphics.setFont(this.font);
        FontMetrics fontMetrics = this.getFontMetrics(this.font);
        graphics.drawString(this.getCurrentTime(), rectangle.x + 5, rectangle.y + 2 + fontMetrics.getAscent());
    }

    public static String formatTime(String string) {
        Calendar calendar = Calendar.getInstance();
        Date date = calendar.getTime();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string);
        simpleDateFormat.setCalendar(calendar);
        return simpleDateFormat.format(date);
    }

    protected String getCurrentTime() {
        return Clock.formatTime(clockPattern);
    }

    public void update(Observable observable, Object object) {
        this.repaint();
    }

    static {
        clockPattern = DEFAULT_CLOCK_FORMAT;
    }
}

