/*
 * Decompiled with CFR 0.152.
 */
package sunw.hotjava.tags;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.Point;
import java.awt.PrintJob;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.StringReader;
import java.net.URL;
import sunw.hotjava.bean.HotJavaBrowserBean;
import sunw.hotjava.doc.DocBusyException;
import sunw.hotjava.doc.DocPanel;
import sunw.hotjava.doc.Document;
import sunw.hotjava.doc.DocumentCache;
import sunw.hotjava.doc.DocumentFormatter;
import sunw.hotjava.doc.DocumentPanel;
import sunw.hotjava.doc.Formatter;
import sunw.hotjava.doc.TagItem;
import sunw.hotjava.misc.RequestProcessor;
import sunw.hotjava.tags.FRAME;
import sunw.hotjava.tags.FrameSetPanel;
import sunw.hotjava.tags.Resizable;
import sunw.hotjava.tags.ResizeRequestEvent;
import sunw.html.Attributes;

public class FramePanel
extends Panel
implements DocPanel,
MouseListener,
Resizable {
    private int BORDER_SLOP;
    private static int count;
    private Document doc;
    private DocumentPanel docPanel;
    private boolean resizable;
    private boolean selected = false;
    private int currentPosition;
    private int borderWidth = 4;
    private boolean borderEvaluated;
    private boolean shouldPaintBorder;
    private FrameSetPanel resizeListener;
    private Point gridLoc;
    private DocumentFormatter parentFormatter;
    private String name;
    private FRAME frameTag;

    FramePanel(Formatter formatter, TagItem tagItem, int n, Container container) {
        this.setLayout(null);
        this.parentFormatter = (DocumentFormatter)formatter;
        this.borderWidth = n;
        this.borderEvaluated = false;
        Attributes attributes = tagItem.getAttributes();
        this.frameTag = (FRAME)tagItem;
        URL uRL = this.frameTag.src;
        String string = this.getAttribute("scrolling", attributes, "auto");
        int n2 = uRL != null ? 0 : 2;
        if ("yes".equalsIgnoreCase(string)) {
            n2 = 1;
        } else if ("no".equalsIgnoreCase(string)) {
            n2 = 2;
        } else if ("auto".equalsIgnoreCase(string)) {
            n2 = 0;
        }
        container.add(this);
        this.docPanel = new DocumentPanel(formatter.getDocFont(), n2, this);
        this.docPanel.addMouseListener(this);
        this.add(this.docPanel);
        if (attributes != null) {
            this.name = attributes.get("name");
        }
        if (this.name != null) {
            this.docPanel.setName(this.name);
        } else {
            this.docPanel.setName("XXUnnamedFramePanel" + count++);
        }
        if (uRL == null) {
            String string2 = this.getAttribute("noresize", attributes, null);
            this.resizable = !"noresize".equalsIgnoreCase(string2);
            return;
        }
        Container container2 = container;
        do {
            if (!(container2 instanceof FrameSetPanel) || !uRL.equals(((FrameSetPanel)container2).doc.getURL())) continue;
            uRL = null;
            return;
        } while ((container2 = container2.getParent()) != null);
        URL uRL2 = formatter.getDocument().getURL();
        if (uRL.toExternalForm().toLowerCase().startsWith("doc://unknown.protocol/javascript:")) {
            String string3 = uRL.toExternalForm().substring("doc://unknown.protocol/javascript:".length());
            this.docPanel.setDocumentSource(new StringReader("<html></html>"));
            RequestProcessor requestProcessor = RequestProcessor.getHJBeanQueue();
            FramePanelJSInit framePanelJSInit = new FramePanelJSInit(this.docPanel.getFormatter(), string3, String.valueOf(uRL2) + " (FRAME SRC)", tagItem, n);
            requestProcessor.postRequest(framePanelJSInit);
            return;
        }
        boolean bl = ((FRAME)tagItem).isByReloaded();
        this.doc = DocumentCache.getDocument(uRL, uRL2, bl);
        this.doc.setReloaded(bl);
        this.docPanel.show(this.doc);
        this.finishInitialization(tagItem, n);
    }

    private void finishInitialization(TagItem tagItem, int n) {
        Attributes attributes = tagItem.getAttributes();
        String string = this.getAttribute("noresize", attributes, null);
        this.resizable = !"noresize".equalsIgnoreCase(string);
        int n2 = this.getMarginValue("marginwidth", attributes, 20);
        int n3 = this.getMarginValue("marginheight", attributes, 10);
        this.docPanel.setMargins(n2, n3);
        this.addMouseListener(this);
        String string2 = attributes.get("frameborder");
        if (string2 != null) {
            if (string2.equalsIgnoreCase("no") || string2.equals("0")) {
                this.borderWidth = 0;
            }
            if ((string2.equalsIgnoreCase("yes") || string2.equals("1")) && n == 0) {
                this.borderWidth = 3;
            }
        }
    }

    public FRAME getFrameTag() {
        return this.frameTag;
    }

    protected Document getDocument() {
        return this.doc;
    }

    public String getName() {
        return this.name;
    }

    public void setResizeListener(FrameSetPanel frameSetPanel, Point point) {
        this.resizeListener = frameSetPanel;
        this.gridLoc = point;
        if (!this.resizable && frameSetPanel != null) {
            frameSetPanel.setNotResizable(point);
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        boolean bl = false;
        int n = 0;
        int n2 = this.computeMouseEdge(mouseEvent);
        if (n2 < 0) {
            return;
        }
        if (n2 == 2 && this.resizeListener != null) {
            bl = true;
            n = this.gridLoc.y;
        } else if (n2 == 3 && this.resizeListener != null) {
            bl = true;
            n = this.gridLoc.y + 1;
        } else if (n2 == 0 && this.resizeListener != null) {
            n = this.gridLoc.x;
        } else if (n2 == 1 && this.resizeListener != null) {
            n = this.gridLoc.x + 1;
        } else {
            return;
        }
        ResizeRequestEvent resizeRequestEvent = new ResizeRequestEvent(mouseEvent.getComponent(), mouseEvent.getPoint(), bl, n);
        if (this.resizeListener != null) {
            this.resizeListener.handleResizeEvent(resizeRequestEvent);
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    private int computeMouseEdge(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        if (this.isCloseTo(n, 0)) {
            return 0;
        }
        int n2 = mouseEvent.getY();
        if (this.isCloseTo(n2, 0)) {
            return 2;
        }
        Dimension dimension = this.getSize();
        if (this.isCloseTo(n, dimension.width)) {
            return 1;
        }
        if (this.isCloseTo(n2, dimension.height)) {
            return 3;
        }
        return -1;
    }

    public boolean isCloseTo(int n, int n2) {
        return Math.abs(n - n2) <= this.BORDER_SLOP;
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        if (this.shouldPaintBorder()) {
            this.paintBorder(graphics);
        }
        super.paint(graphics);
    }

    private void paintBorder(Graphics graphics) {
        Dimension dimension = this.getSize();
        graphics.setColor(Color.gray);
        int n = 0;
        while (n < this.borderWidth) {
            graphics.draw3DRect(n, n, dimension.width - (2 * n + 1), dimension.height - (2 * n + 1), false);
            ++n;
        }
        if (this.selected) {
            graphics.setColor(Color.black);
            int n2 = this.borderWidth - 1;
            graphics.drawRect(n2 - 1, n2 - 1, dimension.width - 2 * n2 + 1, dimension.height - 2 * n2 + 1);
            graphics.drawRect(n2, n2, dimension.width - (2 * n2 + 1), dimension.height - (2 * n2 + 1));
        }
    }

    private String getAttribute(String string, Attributes attributes, String string2) {
        String string3 = string2;
        if (attributes != null && (string3 = attributes.get(string)) == null) {
            string3 = string2;
        }
        return string3;
    }

    private int getMarginValue(String string, Attributes attributes, int n) {
        block3: {
            String string2 = this.getAttribute(string, attributes, null);
            if (string2 != null) {
                try {
                    return Integer.parseInt(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    if (!"o".equalsIgnoreCase(string2)) break block3;
                    return 0;
                }
            }
        }
        return n;
    }

    private boolean shouldPaintBorder() {
        if (!this.borderEvaluated) {
            this.shouldPaintBorder = this.decideBorderPaintability();
            this.borderEvaluated = true;
        }
        return this.shouldPaintBorder;
    }

    private boolean decideBorderPaintability() {
        Insets insets = this.getInsets();
        this.BORDER_SLOP = this.borderWidth;
        this.borderWidth -= insets.left;
        return this.borderWidth > 0;
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        Component component = this.getComponent(0);
        if (n3 != 0) {
            component.setBounds(this.borderWidth, this.borderWidth, n3 - 2 * this.borderWidth, n4 - 2 * this.borderWidth);
        }
    }

    public void setBounds(Rectangle rectangle) {
        this.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void activateSubItems() {
        DocumentFormatter documentFormatter = this.getFormatter();
        if (documentFormatter != null) {
            documentFormatter.activateSubItems();
        }
    }

    public void start() {
        DocumentFormatter documentFormatter = this.getFormatter();
        if (documentFormatter == null) {
            return;
        }
        Color color = documentFormatter.getFormatterBackgroundColor();
        if (color != null) {
            this.setBackground(color);
        }
        documentFormatter.start();
    }

    public void stop() {
        DocumentFormatter documentFormatter = this.getFormatter();
        if (documentFormatter != null) {
            documentFormatter.stop();
        }
    }

    public void destroy() {
        if (this.docPanel != null) {
            this.docPanel.destroy();
        }
    }

    public void setObsolete(boolean bl) {
        if (this.docPanel != null) {
            this.docPanel.setObsolete(bl);
        }
    }

    public void interruptLoading() {
        DocumentFormatter documentFormatter = this.getFormatter();
        if (documentFormatter != null) {
            documentFormatter.interruptLoading();
        }
    }

    public void notify(Document document, int n, int n2, int n3) {
        DocumentFormatter documentFormatter = this.getFormatter();
        if (documentFormatter != null) {
            documentFormatter.notify(document, n, n2, n3);
        }
    }

    public void reformat() {
        DocumentFormatter documentFormatter = this.getFormatter();
        if (documentFormatter != null) {
            documentFormatter.reformat();
        }
    }

    public int findYFor(int n) {
        DocumentFormatter documentFormatter = this.getFormatter();
        if (documentFormatter != null) {
            return documentFormatter.findYFor(n);
        }
        return 0;
    }

    public void reload() {
        this.docPanel.reload();
    }

    public void updateDocument() {
        if (this.doc != null) {
            if (this.doc.isExpired()) {
                this.reload();
            } else {
                this.getFormatter().dispatchDocumentEvent(1042, null);
            }
            this.setSelected(true);
            this.docPanel.dispatchDocumentEvent(1041, this);
        }
    }

    public DocumentFormatter getFormatter() {
        return this.docPanel.getFormatter();
    }

    public void print(PrintJob printJob, HotJavaBrowserBean hotJavaBrowserBean) throws DocBusyException {
        this.docPanel.print(printJob, hotJavaBrowserBean);
    }

    public void removeNotify() {
        this.stop();
        this.docPanel.removeMouseListener(this);
        this.docPanel.removePanel(this.docPanel);
        super.removeNotify();
    }

    public void setSelected(boolean bl) {
        this.selected = bl;
        this.repaint();
    }

    public int find(String string, boolean bl) {
        DocumentFormatter documentFormatter = this.docPanel.getFormatter();
        documentFormatter.showSelection(false);
        documentFormatter.select(this.currentPosition, this.currentPosition);
        if (this.docPanel.find(string, bl)) {
            this.currentPosition = documentFormatter.getSelectEnd();
            return this.currentPosition;
        }
        return -1;
    }

    public DocumentPanel getDocumentPanel() {
        return this.docPanel;
    }

    public Formatter getParentFormatter() {
        return this.parentFormatter;
    }

    public int getFrameIndex() {
        return this.frameTag.getFrameIndex();
    }

    static /* synthetic */ Document access$1(FramePanel framePanel) {
        return framePanel.doc;
    }

    class FramePanelJSInit
    extends RequestProcessor.Request {
        private String script;
        private Formatter jsFormatter;
        private String referer;
        private TagItem frameItem;
        private int border;

        public FramePanelJSInit(Formatter formatter, String string, String string2, TagItem tagItem, int n) {
            FramePanel.this = FramePanel.this;
            this.jsFormatter = formatter;
            this.script = string;
            this.referer = string2;
            this.frameItem = tagItem;
            this.border = n;
        }

        public void execute() {
            String string = Formatter.handleScript(FramePanel.this.docPanel.getFormatter(), this.script, this.referer, 0, null);
            if (string != null) {
                FramePanel.this.docPanel.setDocumentSource(new StringReader(string));
            }
            FramePanel.this.doc = FramePanel.this.docPanel.getDocument();
            FramePanel.this.finishInitialization(this.frameItem, this.border);
        }
    }
}

