/*
 * Decompiled with CFR 0.152.
 */
package sunw.hotjava.tags;

import java.awt.Color;
import java.util.StringTokenizer;
import java.util.Vector;
import sunw.hotjava.doc.DocStyle;
import sunw.hotjava.doc.Document;
import sunw.hotjava.doc.FlowTagItem;
import sunw.hotjava.misc.Globals;

public class FONT
extends FlowTagItem {
    private Color col;
    private int relativeSize;
    private boolean sizeSpecified = false;
    private int index;
    private Vector faces;
    private String faceFound;

    public void init(Document document) {
        super.init(document);
        String string = this.getAttribute("size");
        try {
            if (string != null) {
                if (string.startsWith("+")) {
                    this.relativeSize = Integer.parseInt(string.substring(1));
                } else if (string.startsWith("-")) {
                    this.relativeSize = -Integer.parseInt(string.substring(1));
                } else {
                    this.index = Integer.parseInt(string) + 2;
                }
                this.sizeSpecified = true;
            }
        }
        catch (NumberFormatException numberFormatException) {}
        if ((string = this.getAttribute("color")) != null) {
            this.col = Globals.mapNamedColor(string);
        }
        if ((string = this.getAttribute("face")) != null) {
            this.faces = new Vector();
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens()) {
                this.faces.addElement(stringTokenizer.nextToken().trim());
            }
        }
    }

    public void modifyStyle(DocStyle docStyle) {
        int n;
        if (this.sizeSpecified) {
            n = this.index;
            n = n == 0 ? docStyle.doc.basefontSizeAt(docStyle, this.getIndex()) + this.relativeSize : docStyle.adjustFontSize(n);
            docStyle.font = docStyle.font.getIndex(n);
        }
        if (this.col != null) {
            docStyle.color = this.col;
        }
        if (this.faces != null) {
            if (this.faceFound != null) {
                docStyle.font = docStyle.font.getName(this.faceFound);
                return;
            }
            n = 0;
            while (n < this.faces.size()) {
                String string = (String)this.faces.elementAt(n);
                if (docStyle.font.getName(string) != null) {
                    this.faceFound = string;
                    docStyle.font = docStyle.font.getName(this.faceFound);
                    return;
                }
                ++n;
            }
        }
    }
}

