/*
 * Decompiled with CFR 0.152.
 */
package sunw.hotjava.security;

import java.net.InetAddress;
import sunw.hotjava.misc.Set;

public class ExtPermissions {
    private boolean allowExec = false;
    private boolean readAllFiles = false;
    private Set readAccess;
    private boolean writeAllFiles = false;
    private Set writeAccess;
    private boolean connectAll = false;
    private Set netConnect;
    private boolean acceptAll = false;
    private Set netAccept;
    private boolean listenAll = false;
    private Set netListen;
    private boolean propertiesAll = false;
    private Set propertiesAccess;
    private boolean deleteAllFiles = false;
    private Set deleteAccess;

    void allowRead(String string) {
        if (this.readAccess == null) {
            this.readAccess = new Set();
        }
        this.readAccess.add(string);
    }

    void allowAllRead() {
        this.readAccess = null;
        this.readAllFiles = true;
    }

    boolean readOK(String string) {
        if (this.readAllFiles) {
            return true;
        }
        return this.readAccess != null && this.readAccess.isMember(string);
    }

    void allowDelete(String string) {
        if (this.deleteAccess == null) {
            this.deleteAccess = new Set();
        }
        this.deleteAccess.add(string);
    }

    void allowAllDelete() {
        this.deleteAccess = null;
        this.deleteAllFiles = true;
    }

    boolean deleteOK(String string) {
        if (this.deleteAllFiles) {
            return true;
        }
        return this.deleteAccess != null && this.deleteAccess.isMember(string);
    }

    void allowWrite(String string) {
        if (this.writeAccess == null) {
            this.writeAccess = new Set();
        }
        this.writeAccess.add(string);
    }

    void allowAllWrite() {
        this.writeAccess = null;
        this.writeAllFiles = true;
    }

    boolean writeOK(String string) {
        if (this.writeAllFiles) {
            return true;
        }
        return this.writeAccess != null && this.writeAccess.isMember(string);
    }

    boolean execOK() {
        return this.allowExec;
    }

    void allowAllExec() {
        this.allowExec = true;
    }

    void allowProp(String string) {
        if (this.propertiesAccess == null) {
            this.propertiesAccess = new Set();
        }
        this.propertiesAccess.add(string);
    }

    void allowAllProps() {
        this.propertiesAll = true;
        this.propertiesAccess = null;
    }

    boolean propOK(String string) {
        if (this.propertiesAll) {
            return true;
        }
        return this.propertiesAccess != null && this.propertiesAccess.isMember(string);
    }

    boolean listenOK(int n) {
        if (this.listenAll) {
            return true;
        }
        return this.netListen != null && this.netListen.isMember(new Integer(n));
    }

    void allowListen(int n) {
        if (this.netListen == null) {
            this.netListen = new Set();
        }
        this.netListen.add(new Integer(n));
    }

    void allowAllListen() {
        this.listenAll = true;
        this.netListen = null;
    }

    private String hostPortString(String string, int n) {
        return String.valueOf(string) + ":" + n;
    }

    boolean connectOK(String string, int n) {
        String string2 = this.hostPortString(string, n);
        if (this.connectAll) {
            return true;
        }
        return this.netConnect != null && this.netConnect.isMember(string2);
    }

    boolean multicastOK(InetAddress inetAddress) {
        return this.connectAll;
    }

    void allowConnect(String string, int n) {
        String string2 = this.hostPortString(string, n);
        if (this.netConnect == null) {
            this.netConnect = new Set();
        }
        this.netConnect.add(string2);
    }

    void allowAllConnect() {
        this.connectAll = true;
        this.netConnect = null;
    }

    boolean acceptOK(String string, int n) {
        String string2 = this.hostPortString(string, n);
        if (this.acceptAll) {
            return true;
        }
        return this.netAccept != null && this.netAccept.isMember(string2);
    }

    void allowAccept(String string, int n) {
        String string2 = this.hostPortString(string, n);
        if (this.netAccept == null) {
            this.netAccept = new Set();
        }
        this.netAccept.add(string2);
    }

    void allowAllAccept() {
        this.netAccept = null;
        this.acceptAll = true;
    }
}

