/*
 * Decompiled with CFR 0.152.
 */
package sunw.hotjava.misc;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.TimeZone;

public class RfcDateParser {
    private static final String debugProp = "hotjava.debug.RfcDateParser";
    private boolean isGMT = false;
    private static boolean usingJDK;
    static final String[] standardFormats;
    static final String[] gmtStandardFormats;
    String dateString;

    public RfcDateParser(String string) {
        this.dateString = string.trim();
        if (this.dateString.indexOf("GMT") != -1) {
            this.isGMT = true;
        }
        try {
            Class.forName("java.text.SimpleDateFormat");
            usingJDK = true;
            return;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return;
        }
    }

    public Date getDate() {
        if (usingJDK) {
            int n = this.isGMT ? gmtStandardFormats.length : standardFormats.length;
            int n2 = 0;
            while (n2 < n) {
                Date date = null;
                date = this.isGMT ? this.tryParsing(gmtStandardFormats[n2]) : this.tryParsing(standardFormats[n2]);
                if (date != null) {
                    return date;
                }
                ++n2;
            }
            return null;
        }
        return this.parseNoJDKDate();
    }

    private Date tryParsing(String string) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string, Locale.US);
        if (this.isGMT) {
            simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        }
        try {
            return simpleDateFormat.parse(this.dateString);
        }
        catch (Exception exception) {
            return null;
        }
    }

    /*
     * Unable to fully structure code
     */
    private Date parseNoJDKDate() {
        block8: {
            block9: {
                block10: {
                    block11: {
                        var1_1 = null;
                        try {
                            var1_1 = new Date(this.dateString);
                        }
                        catch (Exception v0) {}
                        if (var1_1 != null) break block8;
                        var2_2 = new String();
                        var3_3 = new StringTokenizer(this.dateString, " ");
                        if (var3_3.countTokens() < 3) break block9;
                        var2_2 = var2_2.concat(var3_3.nextToken());
                        var4_4 = var3_3.nextToken();
                        var5_5 = var4_4.lastIndexOf(45);
                        var6_6 = var4_4.substring(0, var5_5);
                        if (var5_5 < 0) break block10;
                        var7_7 = var4_4.substring(var5_5 + 1);
                        if (var7_7.length() != 2) break block11;
                        try {
                            var8_8 = Integer.parseInt(var7_7);
                            if (var8_8 >= 70) {
                                return null;
                            }
                            var9_9 = Integer.toString(var8_8 += 2000);
                            var2_2 = var2_2.concat(" " + var6_6 + "-" + var9_9);
                            if (true) ** GOTO lbl32
                        }
                        catch (Exception v1) {
                            return null;
                        }
                    }
                    return null;
                }
                return null;
                do {
                    var2_2 = var2_2.concat(" " + var3_3.nextToken());
lbl32:
                    // 2 sources

                } while (var3_3.hasMoreTokens());
                try {
                    var1_1 = new Date(var2_2);
                }
                catch (Exception v2) {}
                break block8;
            }
            return null;
        }
        return var1_1;
    }

    static {
        standardFormats = new String[]{"EEEE', 'dd-MMM-yy HH:mm:ss z", "EEEE', 'dd-MMM-yy HH:mm:ss", "EEE', 'dd-MMM-yyyy HH:mm:ss z", "EEE', 'dd MMM yyyy HH:mm:ss z", "EEEE', 'dd MMM yyyy HH:mm:ss z", "EEE', 'dd MMM yyyy hh:mm:ss z", "EEEE', 'dd MMM yyyy hh:mm:ss z", "EEE MMM dd HH:mm:ss z yyyy", "EEE MMM dd HH:mm:ss yyyy", "EEE', 'dd-MMM-yy HH:mm:ss", "EEE', 'dd-MMM-yyyy HH:mm:ss"};
        gmtStandardFormats = new String[]{"EEEE',' dd-MMM-yy HH:mm:ss 'GMT'", "EEE',' dd-MMM-yyyy HH:mm:ss 'GMT'", "EEE',' dd MMM yyyy HH:mm:ss 'GMT'", "EEEE',' dd MMM yyyy HH:mm:ss 'GMT'", "EEE',' dd MMM yyyy hh:mm:ss 'GMT'", "EEEE',' dd MMM yyyy hh:mm:ss 'GMT'", "EEE MMM dd HH:mm:ss 'GMT' yyyy"};
    }
}

