/*
 * Decompiled with CFR 0.152.
 */
package sunw.hotjava.misc;

import java.lang.reflect.Field;
import java.net.URL;
import java.util.Date;
import java.util.StringTokenizer;
import sunw.hotjava.misc.HJBProperties;
import sunw.hotjava.misc.RfcDateParser;

public class HttpCookie {
    private Date expirationDate;
    private String nameAndValue;
    private String path;
    private String domain;
    private boolean isSecure = false;
    private static boolean defaultSet;
    private static long defExprTime;

    public HttpCookie(String string) {
        this.parseCookieString(string);
    }

    public HttpCookie(Date date, String string, String string2, String string3, boolean bl) {
        this.expirationDate = date;
        this.nameAndValue = string;
        this.path = string2;
        this.domain = string3;
        this.isSecure = bl;
    }

    public HttpCookie(URL uRL, String string) {
        this.parseCookieString(string);
        this.applyDefaults(uRL);
    }

    private void applyDefaults(URL uRL) {
        if (this.domain == null) {
            this.domain = String.valueOf(uRL.getHost()) + ":" + (uRL.getPort() == -1 ? 80 : uRL.getPort());
        }
        if (this.path == null) {
            this.path = uRL.getFile();
            int n = this.path.lastIndexOf("/");
            if (n > -1) {
                this.path = this.path.substring(0, n);
            }
        }
    }

    private void parseCookieString(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        if (!stringTokenizer.hasMoreTokens()) {
            this.nameAndValue = "=";
            return;
        }
        this.nameAndValue = stringTokenizer.nextToken().trim();
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            if (string2.equalsIgnoreCase("secure")) {
                this.isSecure = true;
                continue;
            }
            int n = string2.indexOf("=");
            if (n < 0) continue;
            String string3 = string2.substring(0, n);
            String string4 = string2.substring(n + 1);
            if (string3.equalsIgnoreCase("path")) {
                this.path = string4;
                continue;
            }
            if (string3.equalsIgnoreCase("domain")) {
                if (string4.indexOf(".") == 0) {
                    this.domain = string4.substring(1);
                    continue;
                }
                this.domain = string4;
                continue;
            }
            if (!string3.equalsIgnoreCase("expires")) continue;
            this.expirationDate = this.parseExpireDate(string4);
        }
    }

    private Date getDefaultExpiration() {
        if (!defaultSet) {
            Field field = null;
            try {
                Class<?> clazz = Class.forName("sunw.hotjava.misc.Globals");
                field = clazz.getDeclaredField("beanProps");
            }
            catch (NoSuchFieldException noSuchFieldException) {
            }
            catch (ClassNotFoundException classNotFoundException) {
                System.out.println("$$ Ann : HttpCookie: Class not found!");
            }
            if (field != null) {
                try {
                    HJBProperties hJBProperties = HJBProperties.getHJBProperties((String)field.get(null));
                    defExprTime = hJBProperties.getInteger("hotjava.cookies.default.expiration");
                }
                catch (IllegalAccessException illegalAccessException) {}
            }
            defaultSet = true;
        }
        return new Date(System.currentTimeMillis() + defExprTime);
    }

    public String getNameValue() {
        return this.nameAndValue;
    }

    public String getName() {
        if (this.nameAndValue == null) {
            return "=";
        }
        int n = this.nameAndValue.indexOf("=");
        if (n < 0) {
            return "=";
        }
        return this.nameAndValue.substring(0, n);
    }

    public String getDomain() {
        return this.domain;
    }

    public String getPath() {
        return this.path;
    }

    public Date getExpirationDate() {
        return this.expirationDate;
    }

    public boolean hasExpired() {
        if (this.expirationDate == null) {
            return false;
        }
        return this.expirationDate.getTime() <= System.currentTimeMillis();
    }

    public boolean isSaveable() {
        return this.expirationDate != null && this.expirationDate.getTime() > System.currentTimeMillis();
    }

    public boolean isSaveableInMemory() {
        return this.expirationDate == null || this.expirationDate != null && this.expirationDate.getTime() > System.currentTimeMillis();
    }

    public boolean isSecure() {
        return this.isSecure;
    }

    private Date parseExpireDate(String string) {
        RfcDateParser rfcDateParser = new RfcDateParser(string);
        Date date = rfcDateParser.getDate();
        if (date == null) {
            date = this.getDefaultExpiration();
        }
        return date;
    }

    public String toString() {
        String string;
        String string2 = string = this.nameAndValue == null ? "=" : this.nameAndValue;
        if (this.expirationDate != null) {
            string = String.valueOf(string) + "; expires=" + this.expirationDate;
        }
        if (this.path != null) {
            string = String.valueOf(string) + "; path=" + this.path;
        }
        if (this.domain != null) {
            string = String.valueOf(string) + "; domain=" + this.domain;
        }
        if (this.isSecure) {
            string = String.valueOf(string) + "; secure";
        }
        return string;
    }
}

