/*
 * Decompiled with CFR 0.152.
 */
package sunw.hotjava.doc;

import java.io.Serializable;

public class Measurement
implements Serializable {
    static final long serialVersionUID = 1321832065397428135L;
    private int minWidth;
    private int prefWidth;
    private int floaterMinWidth;
    private int floaterPrefWidth;

    public void reset() {
        this.prefWidth = 0;
        this.minWidth = 0;
        this.floaterPrefWidth = 0;
        this.floaterMinWidth = 0;
    }

    public void adjustBy(int n) {
        this.minWidth += n;
        this.prefWidth += n;
    }

    public void adjustMinBy(int n) {
        this.minWidth += n;
    }

    public int getMinWidth() {
        return this.minWidth;
    }

    public void setMinWidth(int n) {
        this.minWidth = this.minWidth >= n ? this.minWidth : n;
    }

    public int getPreferredWidth() {
        return this.prefWidth;
    }

    public void setPreferredWidth(int n) {
        this.prefWidth = this.prefWidth >= n ? this.prefWidth : n;
    }

    public void setFloaterMinWidth(int n) {
        this.floaterMinWidth = this.floaterMinWidth >= n ? this.floaterMinWidth : n;
    }

    public void setFloaterPreferredWidth(int n) {
        this.floaterPrefWidth = this.floaterPrefWidth >= n ? this.floaterPrefWidth : n;
    }

    public void adjustForFloaters() {
        this.minWidth = this.floaterMinWidth >= this.minWidth ? this.floaterMinWidth : this.minWidth;
        this.prefWidth = this.floaterPrefWidth >= this.prefWidth ? this.floaterPrefWidth : this.prefWidth;
    }

    public void adjustForFloatersNoBreak() {
        this.minWidth = this.floaterMinWidth + this.minWidth;
        this.prefWidth = this.floaterPrefWidth + this.prefWidth;
    }

    public void append(Measurement measurement) {
        this.minWidth = this.minWidth >= measurement.minWidth ? this.minWidth : measurement.minWidth;
        this.prefWidth += measurement.prefWidth;
        this.floaterMinWidth = this.floaterMinWidth >= measurement.floaterMinWidth ? this.floaterMinWidth : measurement.floaterMinWidth;
        this.floaterPrefWidth = this.floaterPrefWidth >= measurement.floaterPrefWidth ? this.floaterPrefWidth : measurement.floaterPrefWidth;
    }

    public void appendNoBreak(Measurement measurement) {
        this.minWidth += measurement.minWidth;
        this.prefWidth += measurement.prefWidth;
        this.floaterMinWidth = this.floaterMinWidth >= measurement.floaterMinWidth ? this.floaterMinWidth : measurement.floaterMinWidth;
        this.floaterPrefWidth = this.floaterPrefWidth >= measurement.floaterPrefWidth ? this.floaterPrefWidth : measurement.floaterPrefWidth;
    }

    public void unify(Measurement measurement) {
        this.minWidth = this.minWidth >= measurement.minWidth ? this.minWidth : measurement.minWidth;
        this.prefWidth = this.prefWidth >= measurement.prefWidth ? this.prefWidth : measurement.prefWidth;
        this.floaterMinWidth = this.floaterMinWidth >= measurement.floaterMinWidth ? this.floaterMinWidth : measurement.floaterMinWidth;
        this.floaterPrefWidth = this.floaterPrefWidth >= measurement.floaterPrefWidth ? this.floaterPrefWidth : measurement.floaterPrefWidth;
    }

    public String toString() {
        return "Measurement[minWidth=" + this.minWidth + ", prefWidth=" + this.prefWidth + "]";
    }
}

