/*
 * Decompiled with CFR 0.152.
 */
package sunw.hotjava.doc;

import java.awt.Font;
import java.awt.FontMetrics;
import java.util.StringTokenizer;
import sunw.hotjava.doc.DocStyle;
import sunw.hotjava.misc.Globals;
import sunw.hotjava.misc.HJBProperties;

public final class DocFont
extends Font {
    int index;
    boolean forPrinting;
    private DocFont typewriter;
    private DocFont bold;
    private DocFont italic;
    private FontMetrics metrics;
    private DocFont[] sizes;
    private int[] sizeMap;
    private static int[][] sharedSizeMaps = new int[2][];
    private static final int maxSize = 300;
    private static final int chunkSize = 100;
    private static int arrayCount;
    private static DocFont[] fontArray;

    private static synchronized int[] initSharedSizeMap(int n, boolean bl) {
        if (sharedSizeMaps[n] == null) {
            int[] nArray = new int[32];
            String string = bl ? "printfonts.sizes" : "fonts.sizes";
            HJBProperties hJBProperties = HJBProperties.getHJBProperties("beanPropertiesKey");
            StringTokenizer stringTokenizer = new StringTokenizer(hJBProperties.getProperty(string), ", \t\n");
            int n2 = 0;
            while (n2 < nArray.length && stringTokenizer.hasMoreTokens()) {
                nArray[n2++] = Integer.valueOf(stringTokenizer.nextToken());
            }
            DocFont.sharedSizeMaps[n] = new int[n2];
            System.arraycopy(nArray, 0, sharedSizeMaps[n], 0, n2);
        }
        return sharedSizeMaps[n];
    }

    private static int getInitialSize(int n, boolean bl) {
        int n2 = bl ? 1 : 0;
        int[] nArray = sharedSizeMaps[n2] != null ? sharedSizeMaps[n2] : DocFont.initSharedSizeMap(n2, bl);
        return nArray[n];
    }

    public static DocFont findFont(boolean bl, int n, int n2) {
        String string = bl ? "hotjava.printfont" : "hotjava.docfont";
        String string2 = HJBProperties.getHJBProperties("beanPropertiesKey").getProperty(string);
        return DocFont.getFont(string2, n, n2, bl);
    }

    private DocFont(String string, int n, int n2, boolean bl) {
        super(string, n, DocFont.getInitialSize(n2, bl));
        this.forPrinting = bl;
        this.index = n2;
        int n3 = bl ? 1 : 0;
        this.sizeMap = sharedSizeMaps[n3];
        this.sizes = new DocFont[this.sizeMap.length];
    }

    private static synchronized DocFont getFont(String string, int n, int n2, boolean bl) {
        int n3 = 0;
        while (n3 < arrayCount) {
            if (DocFont.fontArray[n3].index == n2 && fontArray[n3].getStyle() == n && DocFont.fontArray[n3].forPrinting == bl && string.equalsIgnoreCase(fontArray[n3].getName())) {
                return fontArray[n3];
            }
            ++n3;
        }
        if (arrayCount == 300) {
            return new DocFont(string, n, n2, bl);
        }
        if (arrayCount == fontArray.length) {
            DocFont[] docFontArray = new DocFont[fontArray.length + 100];
            if (fontArray != null) {
                System.arraycopy(fontArray, 0, docFontArray, 0, arrayCount);
            }
            fontArray = docFontArray;
        }
        DocFont docFont = new DocFont(string, n, n2, bl);
        DocFont.fontArray[DocFont.arrayCount++] = docFont;
        return docFont;
    }

    public DocFont getName(String string) {
        return DocFont.getFont(string, this.style, this.index, this.forPrinting);
    }

    public DocFont getBold() {
        if (this.bold == null) {
            this.bold = DocFont.getFont(this.name, this.style | 1, this.index, this.forPrinting);
        }
        return this.bold;
    }

    public DocFont getItalic() {
        if (this.italic == null) {
            this.italic = DocFont.getFont(this.name, this.style | 2, this.index, this.forPrinting);
        }
        return this.italic;
    }

    public DocFont getTypewriter() {
        if (this.typewriter == null) {
            this.typewriter = DocFont.getFont("Monospaced", this.style, this.index, this.forPrinting);
        }
        return this.typewriter;
    }

    public DocFont getIndex(int n) {
        if (n < 0) {
            n = 0;
        } else if (n >= this.sizeMap.length) {
            n = this.sizeMap.length - 1;
        }
        if (this.sizes[n] == null) {
            this.sizes[n] = DocFont.getFont(this.name, this.style, n, this.forPrinting);
        }
        return this.sizes[n];
    }

    public DocFont getBigger(int n) {
        return this.getIndex(this.index + n);
    }

    public DocFont getSmaller(int n) {
        return this.getIndex(this.index - n);
    }

    public int getIndex() {
        return this.index;
    }

    public FontMetrics getFontMetrics(DocStyle docStyle) {
        if (docStyle != null && docStyle.nonScreenGraphics != null) {
            return docStyle.nonScreenGraphics.getFontMetrics(this);
        }
        if (this.metrics == null) {
            this.metrics = Globals.getFontMetrics(this);
        }
        return this.metrics;
    }

    static {
        fontArray = new DocFont[100];
    }
}

