/*
 * Decompiled with CFR 0.152.
 */
package sunw.hotjava.bean;

import java.awt.Canvas;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.image.ImageObserver;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import sunw.hotjava.applet.AppletImageRef;
import sunw.hotjava.bean.ImageCacher;
import sunw.hotjava.misc.SelfCleaningHashtable;

public class ImageCache
implements ImageCacher {
    private static SelfCleaningHashtable imgHash = new SelfCleaningHashtable(50);
    private static SelfCleaningHashtable emptyHash = new SelfCleaningHashtable(1);
    private static DocumentImages[] documents = new DocumentImages[0];
    private static Canvas comp = new Canvas();
    private static int docImageNumber;

    public ImageCache() {
        this.setReferenceDepth(1);
    }

    public void setReferenceDepth(int n) {
        SelfCleaningHashtable selfCleaningHashtable = imgHash;
        synchronized (selfCleaningHashtable) {
            DocumentImages[] documentImagesArray = documents;
            documents = new DocumentImages[n];
            int n2 = 0;
            while (n2 < n && n2 < documentImagesArray.length) {
                ImageCache.documents[n2] = documentImagesArray[n2];
                ++n2;
            }
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Image getImage(Object object, URL uRL, URL uRL2) {
        SelfCleaningHashtable selfCleaningHashtable = imgHash;
        synchronized (selfCleaningHashtable) {
            if (documents.length == 0) return this.getImageHashImage(uRL, uRL2);
            if (object == null) {
                return this.getImageHashImage(uRL, uRL2);
            }
            int n = 0;
            while (n < documents.length) {
                if (documents[n] != null && documents[n].getKey().equals(object)) {
                    if (n == 0) return documents[0].getImage(uRL, uRL2);
                    DocumentImages documentImages = documents[n];
                    System.arraycopy(documents, 0, documents, 1, n);
                    ImageCache.documents[0] = documentImages;
                    return documents[0].getImage(uRL, uRL2);
                }
                ++n;
            }
            DocumentImages documentImages = new DocumentImages(object);
            if (documents.length == 1) {
                ImageCache.documents[0] = documentImages;
                return documentImages.getImage(uRL, uRL2);
            } else {
                DocumentImages[] documentImagesArray = new DocumentImages[documents.length];
                System.arraycopy(documents, 0, documentImagesArray, 1, documentImagesArray.length - 1);
                documents = documentImagesArray;
                ImageCache.documents[0] = documentImages;
            }
            return documentImages.getImage(uRL, uRL2);
        }
    }

    public void flushAllImages() {
        SelfCleaningHashtable selfCleaningHashtable;
        SelfCleaningHashtable selfCleaningHashtable2 = selfCleaningHashtable = imgHash;
        synchronized (selfCleaningHashtable2) {
            imgHash = emptyHash;
            documents = new DocumentImages[documents.length];
            emptyHash = new SelfCleaningHashtable(1);
            return;
        }
    }

    public void flushDocumentImages(Object object) {
        int n = 0;
        SelfCleaningHashtable selfCleaningHashtable = imgHash;
        synchronized (selfCleaningHashtable) {
            int n2 = 0;
            while (n2 < documents.length) {
                if (documents[n2] != null && !documents[n2].getKey().equals(object)) {
                    if (n < n2) {
                        ImageCache.documents[n] = documents[n2];
                        ImageCache.documents[n2] = null;
                    }
                    ++n;
                } else {
                    ImageCache.documents[n2] = null;
                }
                ++n2;
            }
            return;
        }
    }

    private Image getImageHashImage(URL uRL, URL uRL2) {
        SelfCleaningHashtable selfCleaningHashtable = imgHash;
        synchronized (selfCleaningHashtable) {
            Image image;
            AppletImageRef appletImageRef = (AppletImageRef)((Object)imgHash.get(uRL));
            if (appletImageRef == null) {
                appletImageRef = new AppletImageRef(uRL);
                appletImageRef.get(uRL2);
                imgHash.put(uRL, (Object)appletImageRef);
            }
            Object object = appletImageRef.get(uRL2);
            Image image2 = image = (Image)object;
            Object var5_8 = null;
            return image2;
        }
    }

    class DocumentImages
    implements ImageObserver {
        private Object key;
        private int myDocImageNumber;
        private Hashtable images;
        private Hashtable imageIDs;
        private MediaTracker mediaTracker;
        private int lastImageID;

        public DocumentImages(Object object) {
            ImageCache.this = ImageCache.this;
            int n = docImageNumber;
            docImageNumber = n + 1;
            this.myDocImageNumber = n;
            this.key = object;
            this.images = new Hashtable(20);
            this.imageIDs = new Hashtable(20);
            this.mediaTracker = new MediaTracker(comp);
        }

        public Object getKey() {
            return this.key;
        }

        public synchronized Image getImage(URL uRL, URL uRL2) {
            Image image = null;
            Image image2 = (Image)this.images.get(uRL);
            if (image2 != null) {
                return image2;
            }
            SelfCleaningHashtable selfCleaningHashtable = imgHash;
            synchronized (selfCleaningHashtable) {
                image = ImageCache.this.getImageHashImage(uRL, uRL2);
                this.images.put(uRL, image);
                this.imageIDs.put(new Integer(this.lastImageID), image);
                comp.prepareImage(image, this);
                this.mediaTracker.addImage(image, this.lastImageID);
                ++this.lastImageID;
                Enumeration enumeration = this.imageIDs.keys();
                while (enumeration.hasMoreElements()) {
                    Integer n = (Integer)enumeration.nextElement();
                    int n2 = this.mediaTracker.statusID(n, true);
                    switch (n2) {
                        case 2: 
                        case 4: 
                        case 8: {
                            Image image3 = (Image)this.imageIDs.remove(n);
                            this.mediaTracker.removeImage(image3);
                            break;
                        }
                    }
                }
                Image image4 = image;
                Object var7_11 = null;
                return image4;
            }
        }

        public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
            return (n & 0x20) != 0;
        }
    }
}

