/*
 * Decompiled with CFR 0.152.
 */
package sunw.hotjava.applets;

import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.KeyListener;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Hashtable;
import java.util.StringTokenizer;
import sun.net.ftp.FtpClient;
import sun.net.www.http.HttpClient;
import sunw.hotjava.HJWindowManager;
import sunw.hotjava.applet.PrefsPanel;
import sunw.hotjava.misc.HJBProperties;
import sunw.hotjava.ui.ConfirmDialog;
import sunw.hotjava.ui.MultiLineLabel;

class ProxiesPanel
extends Panel
implements PrefsPanel {
    private TextField[] fields = new TextField[10];
    private String[] names = new String[10];
    private static int HTTP;
    private static int HTTPPORT;
    private static int FTP;
    private static int FTPPORT;
    private static int GOPHER;
    private static int GOPHERPORT;
    private static int SOCKS;
    private static int SOCKSPORT;
    private static int SECURITY;
    private static int SECURITYPORT;
    private KeyListener keylistener;
    private TextArea bypassTA;
    private HJBProperties props = HJBProperties.getHJBProperties("hjbrowser");
    private String propname = "general.proxies.preferences";
    private Font regular;
    private Font regularBold;
    private Font headings;

    private void addLine(int n, GridBagConstraints gridBagConstraints, String string, int n2, String string2, String string3) {
        gridBagConstraints.insets = new Insets(5, 10, 5, 0);
        gridBagConstraints.gridy = n;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 0;
        MultiLineLabel multiLineLabel = new MultiLineLabel(String.valueOf(this.props.getProperty(String.valueOf(this.propname) + "." + string)) + "     ");
        multiLineLabel.setMarginWidth(0);
        multiLineLabel.setFont(this.regular);
        this.add((Component)multiLineLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 5;
        this.fields[n2] = new TextField(30);
        this.fields[n2].setFont(this.regular);
        this.add((Component)this.fields[n2], gridBagConstraints);
        this.names[n2] = string2;
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridwidth = 1;
        MultiLineLabel multiLineLabel2 = new MultiLineLabel("        " + this.props.getProperty(String.valueOf(this.propname) + ".port.label"));
        multiLineLabel2.setFont(this.regular);
        this.add((Component)multiLineLabel2, gridBagConstraints);
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        this.fields[n2 + 1] = new TextField(5);
        this.fields[n2 + 1].setFont(this.regular);
        this.add((Component)this.fields[n2 + 1], gridBagConstraints);
        this.names[n2 + 1] = string3;
    }

    public ProxiesPanel(KeyListener keyListener, String string, Font font, Font font2, Font font3) {
        this.regular = font;
        this.regularBold = font2;
        this.headings = font3;
        this.keylistener = keyListener;
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 8;
        gridBagConstraints.anchor = 17;
        MultiLineLabel multiLineLabel = new MultiLineLabel(string);
        multiLineLabel.setFont(font3);
        multiLineLabel.setMarginHeight(0);
        this.add((Component)multiLineLabel, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        MultiLineLabel multiLineLabel2 = new MultiLineLabel(this.props.getProperty(String.valueOf(this.propname) + ".lt1.label"));
        multiLineLabel2.setFont(font);
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        multiLineLabel2.setMarginWidth(20);
        gridBagConstraints.gridwidth = 8;
        gridBagConstraints.fill = 0;
        this.add((Component)multiLineLabel2, gridBagConstraints);
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        gridBagConstraints.weighty = 0.1;
        this.addLine(3, gridBagConstraints, "http.label", HTTP, "http.proxyHost", "http.proxyPort");
        this.addLine(4, gridBagConstraints, "security.label", SECURITY, "https.proxyHost", "https.proxyPort");
        this.addLine(5, gridBagConstraints, "ftp.label", FTP, "ftpProxyHost", "ftpProxyPort");
        this.addLine(6, gridBagConstraints, "gopher.label", GOPHER, "gopherProxyHost", "gopherProxyPort");
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 3;
        MultiLineLabel multiLineLabel3 = new MultiLineLabel(this.props.getProperty(String.valueOf(this.propname) + ".bypass.label"));
        multiLineLabel3.setFont(font);
        gridBagConstraints.insets = new Insets(0, 10, 5, 0);
        multiLineLabel3.setMarginHeight(0);
        this.add((Component)multiLineLabel3, gridBagConstraints);
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 8;
        MultiLineLabel multiLineLabel4 = new MultiLineLabel(this.props.getProperty(String.valueOf(this.propname) + ".text"));
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        gridBagConstraints.fill = 0;
        multiLineLabel4.setMarginWidth(20);
        multiLineLabel4.setFont(font);
        this.add((Component)multiLineLabel4, gridBagConstraints);
        gridBagConstraints.insets = new Insets(0, 10, 0, 10);
        gridBagConstraints.gridwidth = 8;
        this.bypassTA = new TextArea(3, 25);
        gridBagConstraints.gridy = 10;
        gridBagConstraints.fill = 2;
        this.add((Component)this.bypassTA, gridBagConstraints);
        gridBagConstraints.weighty = 0.1;
        gridBagConstraints.fill = 0;
        this.addLine(12, gridBagConstraints, "socks.label", SOCKS, "socksProxyHost", "socksProxyPort");
        int n = 0;
        while (n < this.fields.length) {
            this.fields[n].addKeyListener(keyListener);
            ++n;
        }
        this.init();
    }

    private void decodeInto(TextArea textArea) {
        StringBuffer stringBuffer = new StringBuffer("");
        String string = this.props.getProperty("http.nonProxyHosts");
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "|", false);
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken().toLowerCase();
                if (string2.charAt(0) == '*') {
                    string2 = string2.substring(1);
                } else if (string2.equals("localhost")) continue;
                stringBuffer.append(string2);
                stringBuffer.append("\n");
            }
        }
        textArea.setText(stringBuffer.toString());
    }

    private String encodeFrom(TextArea textArea) {
        String string = textArea.getText();
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(string, " \t\n\r,;|", false);
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        stringBuffer.append("localhost");
        hashtable.put("localhost", new Object());
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().toLowerCase();
            if (hashtable.containsKey(string2)) continue;
            hashtable.put(string2, new Object());
            stringBuffer.append('|');
            if (string2.charAt(0) == '.') {
                stringBuffer.append('*');
            }
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    private Frame getFrame() {
        return HJWindowManager.getHJWindowManager().getLastFocusHolder();
    }

    private boolean checkForErrors(TextArea textArea) {
        String string = textArea.getText();
        StringTokenizer stringTokenizer = new StringTokenizer(string, " \t\n\r,;|", false);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (this.validToken(string2)) continue;
            this.showError("dontproxy.error", string2);
            return false;
        }
        return true;
    }

    private boolean validToken(String string) {
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (!(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '.' || c == '-' || c == '_')) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private void init() {
        this.props = HJBProperties.getHJBProperties("beanPropertiesKey");
        int n = 0;
        while (n < this.fields.length) {
            if (this.fields[n] != null) {
                ((TextComponent)this.fields[n]).setText(this.props.getProperty(this.names[n], ""));
            }
            ++n;
        }
        this.decodeInto(this.bypassTA);
    }

    protected boolean validHost(String string) {
        if (string == null || string.length() == 0) {
            return true;
        }
        InetAddress inetAddress = null;
        try {
            inetAddress = InetAddress.getByName(string);
        }
        catch (UnknownHostException unknownHostException) {
            return false;
        }
        return true;
    }

    protected boolean validPort(String string) {
        int n;
        if (string == null || string.length() == 0) {
            return true;
        }
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return n >= 1;
    }

    private void showError(String string, String string2) {
        String[] stringArray = new String[]{string2};
        ((Component)new ConfirmDialog(string, this.getFrame(), 1, stringArray)).setVisible(true);
    }

    protected boolean validateHostAndPort(String string, String string2) {
        if (!this.validHost(string)) {
            this.showError("badproxy.error", string);
            return false;
        }
        if (!this.validPort(string2)) {
            this.showError("badport.error", string2);
            return false;
        }
        return true;
    }

    public void stop() {
        int n = 0;
        while (n < this.fields.length) {
            this.fields[n].removeKeyListener(this.keylistener);
            ++n;
        }
    }

    public int apply() {
        boolean bl = false;
        int n = 0;
        while (n < this.fields.length) {
            if (!this.validateHostAndPort(this.fields[n].getText(), this.fields[n + 1].getText())) {
                return 0;
            }
            n += 2;
        }
        if (!this.checkForErrors(this.bypassTA)) {
            return 0;
        }
        n = 0;
        while (n < this.fields.length) {
            bl |= this.updateProp(this.names[n], this.fields[n].getText());
            ++n;
        }
        if (bl |= this.updateProp("http.nonProxyHosts", this.encodeFrom(this.bypassTA))) {
            HttpClient.resetProperties();
            FtpClient.useFtpProxy = this.props.isPropertyExists("ftpProxySet") ? this.props.getBoolean("ftpProxySet") : true;
            FtpClient.ftpProxyHost = this.props.getProperty("ftpProxyHost");
            FtpClient.ftpProxyPort = this.props.getInteger("ftpProxyPort", 80);
        }
        return 1;
    }

    private boolean updateProp(String string, String string2) {
        String string3 = this.props.getProperty(string);
        if (!string2.equals(string3)) {
            if (string2.length() == 0) {
                this.props.remove(string);
            } else {
                this.props.put(string, string2);
            }
            return true;
        }
        return false;
    }

    static {
        HTTPPORT = 1;
        FTP = 2;
        FTPPORT = 3;
        GOPHER = 4;
        GOPHERPORT = 5;
        SOCKS = 6;
        SOCKSPORT = 7;
        SECURITY = 8;
        SECURITYPORT = 9;
    }
}

