/*
 * Decompiled with CFR 0.152.
 */
package sunw.hotjava.applets;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.List;
import java.awt.Panel;
import java.awt.TextComponent;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import sun.net.www.MimeEntry;
import sunw.hotjava.HJFrame;
import sunw.hotjava.HJWindowManager;
import sunw.hotjava.applets.TypeSubtypeMap;
import sunw.hotjava.misc.ContentViewersManager;
import sunw.hotjava.misc.HJBProperties;
import sunw.hotjava.ui.ConfirmDialog;
import sunw.hotjava.ui.EnterKeyListener;
import sunw.hotjava.ui.KeyPressInterest;
import sunw.hotjava.ui.MultiLineLabel;
import sunw.hotjava.ui.UIHJButton;
import sunw.hotjava.ui.UIHJButtonGroup;
import sunw.hotjava.ui.UserChoice;
import sunw.hotjava.ui.UserDialog;
import sunw.hotjava.ui.UserFileDialog;
import sunw.hotjava.ui.UserLabel;
import sunw.hotjava.ui.UserTextField;

public class ContentViewersPreferencesDialog
extends UserDialog
implements ActionListener,
ItemListener,
KeyPressInterest {
    private final String propname = "general.prefs.contentviewer";
    List typesList;
    UserChoice actionChoices;
    UserTextField description;
    UserTextField application;
    UserTextField extensions;
    UIHJButton delete;
    UIHJButton newDefinition;
    UIHJButton chooseApplication;
    UserLabel typesListLabel;
    UserLabel actionLabel;
    UserLabel descriptionLabel;
    UserLabel applicationLabel;
    UserLabel extensionsLabel;
    boolean editable = false;
    TypeSubtypeMap typeSubtypeMap;
    UserLabel typeLabel;
    UserLabel subtypeLabel;
    UserChoice typeChoices;
    UserTextField subtypeTextField;
    List subtypesList;
    ButtonPanel cmdRowPanel;
    EnterKeyListener keylistener;
    private String descriptionToReplace;
    private boolean definingNew;
    private MimeEntry saved;
    HJBProperties props = HJBProperties.getHJBProperties("hjbrowser");
    final String newLabel = this.props.getPropertyReplace("button.viewer.newbutton.text", "New");
    private static ContentViewersPreferencesDialog singleton = null;
    static String fileDialogDirectory;
    protected static final int CHOICE_INVALID = -1;
    protected static final int CHOICE_VIEW_IN_BROWSER = 0;
    protected static final int CHOICE_VIEW_IN_APPLICATION = 1;
    protected static final int CHOICE_SAVE = 2;
    protected static final int CHOICE_ASK = 3;
    private static final int[] choiceToActionMapping;
    private static final int[] actionToChoiceMapping;

    public static ContentViewersPreferencesDialog getSingleton() {
        if (singleton == null) {
            singleton = new ContentViewersPreferencesDialog();
        }
        singleton.toFront();
        singleton.requestFocus();
        return singleton;
    }

    private ContentViewersPreferencesDialog() {
        super("general.prefs.contentviewer.dialog", HJWindowManager.getHJWindowManager().getLastFocusHolder(), false, HJBProperties.getHJBProperties("hjbrowser"));
        Serializable serializable;
        Object object;
        try {
            this.keylistener = new EnterKeyListener(this);
            this.setLayout(new BorderLayout());
            Panel panel = new Panel();
            panel.setLayout(new GridLayout(2, 1));
            Font font = Font.getFont("general.prefs.font.regular");
            object = Font.getFont("general.prefs.font.headings");
            serializable = new MultiLineLabel(this.props.getProperty("general.prefs.contentviewer.title"), 10, 10, 0, (Font)object);
            MultiLineLabel multiLineLabel = new MultiLineLabel(this.props.getProperty("general.prefs.contentviewer.body"), 10, 0, 0, font);
            panel.add((Component)serializable);
            panel.add(multiLineLabel);
            this.add((Component)panel, "North");
            Panel panel2 = new Panel();
            GridBagLayout gridBagLayout = new GridBagLayout();
            panel2.setLayout(gridBagLayout);
            Panel panel3 = new Panel();
            GridBagLayout gridBagLayout2 = new GridBagLayout();
            panel3.setLayout(gridBagLayout2);
            this.typesListLabel = new UserLabel("viewer.description.list.label");
            this.typesList = this.makeTypesList();
            this.typesList.addItemListener(this);
            this.actionLabel = new UserLabel("viewer.action.label");
            this.actionChoices = new UserChoice("viewer.actionchoice", this.props);
            this.actionChoices.addItemListener(this);
            this.descriptionLabel = new UserLabel("viewer.description.label");
            this.description = new UserTextField("viewer.description");
            this.description.addKeyListener(this.keylistener);
            this.applicationLabel = new UserLabel("viewer.application.label");
            this.application = new UserTextField("viewer.application");
            this.application.addKeyListener(this.keylistener);
            this.chooseApplication = new UIHJButton("viewer.chooseapplicationbutton", this.props);
            this.chooseApplication.addActionListener(this);
            this.extensionsLabel = new UserLabel("viewer.extensions.label");
            this.extensions = new UserTextField("viewer.extensions");
            this.extensions.addKeyListener(this.keylistener);
            UIHJButtonGroup uIHJButtonGroup = new UIHJButtonGroup(this.props);
            Panel panel4 = new Panel();
            this.newDefinition = new UIHJButton("viewer.newbutton", this.props);
            this.newDefinition.addActionListener(this);
            this.delete = new UIHJButton("viewer.deletebutton", this.props);
            this.delete.addActionListener(this);
            uIHJButtonGroup.addButtonToGroup(this.newDefinition);
            uIHJButtonGroup.addButtonToGroup(this.delete);
            panel4.add(this.newDefinition);
            panel4.add(this.delete);
            this.newDefinition.setDefaultButton(false);
            this.editable = true;
            this.typeSubtypeMap = new TypeSubtypeMap();
            this.typeLabel = new UserLabel("viewer.type.label");
            this.typeChoices = new UserChoice("viewer.typechoice", this.props);
            this.typeChoices.enable(this.editable);
            this.subtypeLabel = new UserLabel("viewer.subtype.label");
            this.subtypeTextField = new UserTextField("viewer.subtype");
            this.subtypeTextField.addKeyListener(this.keylistener);
            this.subtypeTextField.setEditable(this.editable);
            this.subtypesList = new List(3);
            this.add(panel2, gridBagLayout, this.typesListLabel, 0, 0, 1, 1, 16, 0.0, 0, 15, 0, 0, 0);
            this.add(panel2, gridBagLayout, this.typesList, 0, 1, 2, -1, 10, 1.0, 1.0, 1, 15, 0, 5, 0);
            this.add(panel2, gridBagLayout, panel4, 0, 7, 1, 0, 11, 0.0, 2, 30, 5, 0, 0);
            this.add(panel3, gridBagLayout2, this.descriptionLabel, 2, 1, 1, 1, 13, 0.0, 0, 0, 0);
            this.add(panel3, gridBagLayout2, this.description, 3, 1, 1, 1, 17, 1.0, 2, 0, 5);
            this.add(panel3, gridBagLayout2, this.extensionsLabel, 2, 2, 1, 1, 13, 1.0, 0, 0, 0, 5, 0);
            this.add(panel3, gridBagLayout2, this.extensions, 3, 2, 1, 1, 17, 1.0, 2, 0, 5, 5, 0);
            this.add(panel3, gridBagLayout2, this.actionLabel, 2, 3, 1, 1, 13, 0.0, 0, 0, 0, 5, 0);
            this.add(panel3, gridBagLayout2, this.actionChoices, 3, 3, 1, 1, 17, 1.0, 0, 0, 5, 5, 0);
            this.add(panel3, gridBagLayout2, this.applicationLabel, 2, 4, 1, 1, 13, 0.0, 0, 0, 0, 5, 0);
            this.add(panel3, gridBagLayout2, this.application, 3, 4, 1, 1, 17, 1.0, 2, 0, 5, 5, 0);
            this.add(panel3, gridBagLayout2, this.chooseApplication, 4, 4, 1, 1, 17, 0.0, 2, 0, 5, 5, 0);
            this.add(panel3, gridBagLayout2, this.typeLabel, 2, 5, 1, 1, 13, 0.0, 0, 0, 0, 5, 0);
            this.add(panel3, gridBagLayout2, this.typeChoices, 3, 5, 1, 1, 17, 1.0, 0, 0, 5, 5, 0);
            this.add(panel3, gridBagLayout2, this.subtypeLabel, 2, 6, 1, 1, 13, 0.0, 0, 0, 0, 5, 0);
            this.add(panel3, gridBagLayout2, this.subtypeTextField, 3, 6, 1, 1, 17, 1.0, 2, 0, 5, 5, 0);
            this.add(panel3, gridBagLayout2, this.subtypesList, 3, 7, 1, 1, 11, 1.0, 2, 0, 5, 0, 0);
            this.add((Component)panel2, "West");
            this.add((Component)panel3, "Center");
            this.cmdRowPanel = new ButtonPanel(this);
            this.add((Component)this.cmdRowPanel, "South");
        }
        catch (Exception exception) {
            System.err.println("ContentViewersPreferencesDialog.update exception");
            exception.printStackTrace();
        }
        this.reset();
        int n = Integer.getInteger("general.prefs.dialogwidth");
        int n2 = Integer.getInteger("general.prefs.dialogheight");
        if (n > 0 && n2 > 0) {
            ((Component)this).setSize(n, n2);
        } else {
            object = Toolkit.getDefaultToolkit();
            serializable = ((Toolkit)object).getScreenSize();
            ((Component)this).setSize(serializable.width / 4, serializable.height / 4);
        }
        this.centerOnScreen();
        this.show();
    }

    public void processEnterEvent(KeyEvent keyEvent) {
        this.cmdRowPanel.doDefaultAction();
    }

    public void apply() {
        Object object;
        Object object2;
        Object object3;
        ContentViewersManager contentViewersManager = ContentViewersManager.getManager();
        this.saved = (MimeEntry)contentViewersManager.getCurrentViewer().clone();
        String string = this.description.getText();
        if (string == null || string.length() == 0) {
            object3 = HJWindowManager.getHJWindowManager().getLastFocusHolder();
            object2 = new ConfirmDialog("contentviewer.description", (Frame)object3, 1);
            ((Dialog)object2).show();
        }
        contentViewersManager.setDescription(string);
        contentViewersManager.setAction(this.mapChoiceToAction(this.actionChoices.getSelectedIndex()));
        object3 = this.application.getText();
        if (((String)object3).length() > 0 && ((String)object3).indexOf("%s", 0) == -1) {
            contentViewersManager.setCommand(String.valueOf(object3) + " %s");
        } else {
            contentViewersManager.setCommand((String)object3);
        }
        contentViewersManager.setFileExtensions(this.extensions.getText());
        if (this.subtypeTextField.isEditable() && !"".equals(this.subtypeTextField.getText())) {
            object2 = this.typeChoices.getSelectedItem().toLowerCase();
            object = this.subtypeTextField.getText().trim().toLowerCase();
            contentViewersManager.setType(String.valueOf(object2) + "/" + (String)object);
        }
        this.descriptionToReplace = null;
        object2 = contentViewersManager.getCurrentViewer();
        object = contentViewersManager.getContentViewer(((MimeEntry)object2).getType());
        if ((this.definingNew || !((MimeEntry)object2).getType().equals(this.saved.getType())) && object != null && ((MimeEntry)object).getType().equals(((MimeEntry)object2).getType())) {
            HJFrame hJFrame = HJWindowManager.getHJWindowManager().getLastFocusHolder();
            ConfirmDialog confirmDialog = new ConfirmDialog("contentviewer.replacetype", hJFrame, 2, true, false);
            confirmDialog.show();
            if (confirmDialog.getAnswer() == 0) {
                this.descriptionToReplace = ((MimeEntry)object).getDescription();
            } else {
                this.definingNew = false;
                contentViewersManager.setCurrentViewer(this.saved);
                return;
            }
        }
        if (!this.definingNew && !((MimeEntry)object2).getType().equals(this.saved.getType())) {
            contentViewersManager.remove(this.saved.getType());
        }
        this.definingNew = false;
        contentViewersManager.apply();
        contentViewersManager.setCurrentViewer((MimeEntry)object2);
        if (!contentViewersManager.save()) {
            System.out.println("ContentViewersButtonApplet: save failed!");
        }
        HJWindowManager.getHJWindowManager();
        contentViewersManager.notifyObservers("end-define-type");
        this.update();
    }

    public void ok() {
        this.apply();
        singleton = null;
        this.dispose();
    }

    public void cancel() {
        this.reset();
        singleton = null;
        this.dispose();
        this.delete.removeActionListener(this);
        this.chooseApplication.removeActionListener(this);
        this.newDefinition.removeActionListener(this);
        this.description.removeKeyListener(this.keylistener);
        this.application.removeKeyListener(this.keylistener);
        this.extensions.removeKeyListener(this.keylistener);
        this.subtypeTextField.removeKeyListener(this.keylistener);
    }

    public void help() {
        HJBProperties hJBProperties = HJBProperties.getHJBProperties("hjbrowser");
        try {
            String string = hJBProperties.getProperty("general.prefs.contentviewer.help");
            URL uRL = new URL(string);
            HJWindowManager.getHJWindowManager().openFrame("_hotjava_help", uRL);
            return;
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
            return;
        }
    }

    public void reset() {
        ContentViewersManager contentViewersManager = ContentViewersManager.getManager();
        contentViewersManager.undoRemove();
        contentViewersManager.notifyObservers();
        this.update();
        HJWindowManager.getHJWindowManager();
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.typesList) {
            this.selectViewer(((List)itemEvent.getSource()).getSelectedItem());
            return;
        }
        if (itemEvent.getSource() == this.actionChoices) {
            this.setApplicationFieldEditState();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(this.delete.getActionCommand())) {
            this.deleteType();
        }
        if (string.equals(this.newDefinition.getActionCommand())) {
            this.defineNewType();
        }
        if (string.equals(this.chooseApplication.getActionCommand())) {
            this.askForApplication();
        }
    }

    public boolean handleEvent(Event event) {
        switch (event.id) {
            case 701: {
                if (this.subtypesList != (List)event.target) break;
                this.handleSubtypeChoice();
                break;
            }
        }
        return super.handleEvent(event);
    }

    public boolean action(Event event, Object object) {
        if (event.target == this.typeChoices) {
            return this.handleTypeChoice();
        }
        if (event.target == this.subtypesList) {
            return this.handleSubtypeChoice();
        }
        return false;
    }

    boolean deleteType() {
        ContentViewersManager contentViewersManager = ContentViewersManager.getManager();
        int n = this.typesList.getSelectedIndex();
        this.typesList.getSelectedItem();
        contentViewersManager.removeCurrentViewer();
        int n2 = this.typesList.getItemCount() - 1;
        if (n < n2) {
            contentViewersManager.setCurrentViewerByDescription(this.typesList.getItem(n + 1));
        } else {
            contentViewersManager.setCurrentViewerByDescription(this.typesList.getItem(n2 - 1));
        }
        this.typesList.remove(n);
        contentViewersManager.notifyObservers();
        this.update();
        return true;
    }

    boolean defineNewType() {
        ContentViewersManager contentViewersManager = ContentViewersManager.getManager();
        contentViewersManager.setCurrentViewerByType("application/other");
        contentViewersManager.notifyObservers("begin-define-type");
        this.definingNew = true;
        this.update();
        return true;
    }

    boolean applyDefinition() {
        ContentViewersManager contentViewersManager = ContentViewersManager.getManager();
        contentViewersManager.setCurrentViewerByDescription(this.description.getText());
        contentViewersManager.notifyObservers("end-define-type");
        return true;
    }

    boolean askForApplication() {
        File file = this.askUserForFile("viewer.chooseapplicationdialog", 0);
        if (file != null) {
            ((TextComponent)this.application).setText(file.getAbsolutePath());
        }
        return true;
    }

    boolean selectViewer(String string) {
        if (string != null) {
            ContentViewersManager contentViewersManager = ContentViewersManager.getManager();
            contentViewersManager.setCurrentViewerByDescription(string);
            contentViewersManager.notifyObservers();
            this.update();
        }
        return true;
    }

    boolean setApplicationFieldEditState() {
        int n = this.actionChoices.getSelectedIndex();
        return this.setApplicationFieldEditState(n);
    }

    boolean setApplicationFieldEditState(int n) {
        switch (n) {
            case 0: 
            case 2: 
            case 3: {
                this.applicationLabel.setEnabled(false);
                this.application.setEditable(false);
                this.chooseApplication.setEnabled(false);
                break;
            }
            case 1: {
                this.applicationLabel.setEnabled(true);
                this.application.setEditable(true);
                this.chooseApplication.setEnabled(true);
                break;
            }
        }
        return true;
    }

    private void fillList(List list) {
        ContentViewersManager contentViewersManager = ContentViewersManager.getManager();
        MimeEntry[] mimeEntryArray = contentViewersManager.getSortedViewers();
        int n = 0;
        while (n < mimeEntryArray.length) {
            if (!"content/unknown".equals(mimeEntryArray[n].getType()) && !"unknown/unknown".equals(mimeEntryArray[n].getType())) {
                list.add(mimeEntryArray[n].getDescription());
            }
            ++n;
        }
    }

    private void insertIntoTypesList(MimeEntry mimeEntry) {
        this.insertIntoTypesList(mimeEntry.getDescription());
    }

    private void insertIntoTypesList(String string) {
        if (this.descriptionToReplace != null) {
            this.typesList.remove(this.descriptionToReplace);
        }
        int n = this.typesList.getItemCount();
        int n2 = 0;
        while (n2 < n) {
            int n3 = this.typesList.getItem(n2).compareTo(string);
            if (n3 == 0) {
                return;
            }
            if (n3 > 0) {
                this.typesList.add(string, n2);
                return;
            }
            ++n2;
        }
        this.typesList.add(string);
    }

    private void resetTypesList() {
        if (this.typesList != null) {
            this.typesList.removeAll();
            this.fillList(this.typesList);
        }
    }

    private void add(Panel panel, GridBagLayout gridBagLayout, Component component, int n, int n2, int n3, int n4, int n5, double d, int n6) {
        this.add(panel, gridBagLayout, component, n, n2, n3, n4, n5, d, n6, 5, 5, 5, 5);
    }

    private void add(Panel panel, GridBagLayout gridBagLayout, Component component, int n, int n2, int n3, int n4, int n5, double d, int n6, int n7, int n8) {
        this.add(panel, gridBagLayout, component, n, n2, n3, n4, n5, d, n6, n7, n8, 5, 5);
    }

    private void add(Panel panel, GridBagLayout gridBagLayout, Component component, int n, int n2, int n3, int n4, int n5, double d, int n6, int n7, int n8, int n9, int n10) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(n9, n7, n10, n8);
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagConstraints.anchor = n5;
        gridBagConstraints.weightx = d;
        gridBagConstraints.fill = n6;
        panel.add(component);
        gridBagLayout.setConstraints(component, gridBagConstraints);
    }

    private void add(Panel panel, GridBagLayout gridBagLayout, Component component, int n, int n2, int n3, int n4, int n5, double d, double d2, int n6, int n7, int n8, int n9, int n10) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(n9, n7, n10, n8);
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagConstraints.anchor = n5;
        gridBagConstraints.weightx = d;
        gridBagConstraints.weighty = d2;
        gridBagConstraints.fill = n6;
        panel.add(component);
        gridBagLayout.setConstraints(component, gridBagConstraints);
    }

    private List makeTypesList() {
        List list = new List(14);
        this.fillList(list);
        return list;
    }

    private void update() {
        int n;
        if (!this.definingNew) {
            this.resetTypesList();
        }
        ContentViewersManager contentViewersManager = ContentViewersManager.getManager();
        MimeEntry mimeEntry = contentViewersManager.getCurrentViewer();
        String string = mimeEntry.getDescription();
        ((TextComponent)this.description).setText(string);
        if (!string.equalsIgnoreCase(this.typesList.getSelectedItem())) {
            this.selectDescribedItem(string);
        }
        if ("text/plain".equalsIgnoreCase(mimeEntry.getType())) {
            this.delete.setEnabled(false);
            if (this.actionChoices.getItemCount() > 2) {
                this.actionChoices.remove(2);
                this.actionChoices.remove(2);
            }
        } else {
            this.delete.setEnabled(true);
            if (this.actionChoices.getItemCount() < 3) {
                String string2 = this.props.getPropertyReplace("viewer.actionchoice.save", "Save");
                this.actionChoices.add(string2);
                string2 = this.props.getPropertyReplace("viewer.actionchoice.ask", "Always Ask");
                this.actionChoices.add(string2);
            }
        }
        if ((n = this.mapActionToChoice(mimeEntry.getAction())) == -1) {
            this.actionChoices.select(0);
        } else {
            this.actionChoices.select(n);
        }
        if (!this.newDefinition.isEnabled()) {
            this.newDefinition.setEnabled(true);
        }
        String string3 = mimeEntry.getLaunchString() != null ? mimeEntry.getLaunchString() : "";
        ((TextComponent)this.application).setText(string3);
        this.setApplicationFieldEditState();
        ((TextComponent)this.extensions).setText(mimeEntry.getExtensionsAsList());
        String string4 = this.getViewerType(mimeEntry);
        int n2 = this.mapTypeToChoice(string4);
        this.typeChoices.select(n2);
        this.typeChoices.enable(this.definingNew);
        this.typeLabel.enable(this.definingNew);
        String string5 = this.getViewerSubtype(mimeEntry);
        ((TextComponent)this.subtypeTextField).setText(string5);
        this.subtypeTextField.setEditable(this.definingNew || this.editable);
        this.subtypeLabel.enable(this.definingNew || this.editable);
        this.handleTypeChoice(n2, string5);
        this.subtypesList.enable(this.definingNew || this.editable);
    }

    private void selectDescribedItem(String string) {
        int n = this.typesList.getItemCount();
        int n2 = 0;
        while (n2 < n) {
            if (string.equals(this.typesList.getItem(n2))) {
                this.typesList.select(n2);
                this.typesList.makeVisible(n2);
                return;
            }
            ++n2;
        }
    }

    private boolean handleTypeChoice() {
        return this.handleTypeChoice(this.typeChoices.getSelectedIndex());
    }

    private boolean handleTypeChoice(int n) {
        return this.handleTypeChoice(this.typeChoices.getSelectedIndex(), null);
    }

    private boolean handleTypeChoice(int n, String string) {
        try {
            String[] stringArray;
            if (!this.typeSubtypeMap.typeHasSubtype(n, string)) {
                this.typeSubtypeMap.addSubtype(n, string);
            }
            if ((stringArray = this.typeSubtypeMap.getSubtypes(n)) == null) {
                return true;
            }
            this.subtypesList.removeAll();
            int n2 = 0;
            while (n2 < stringArray.length) {
                this.subtypesList.add(stringArray[n2]);
                ++n2;
            }
            this.subtypesList.add("other");
            if (string != null) {
                String[] stringArray2 = this.subtypesList.getItems();
                int n3 = 0;
                while (n3 < stringArray2.length) {
                    if (string.equals(stringArray2[n3])) {
                        this.subtypesList.select(n3);
                        this.subtypesList.makeVisible(n3);
                    }
                    ++n3;
                }
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            indexOutOfBoundsException.printStackTrace();
        }
        return true;
    }

    private boolean handleSubtypeChoice() {
        String string = this.subtypesList.getSelectedItem();
        if ("other".equalsIgnoreCase(string)) {
            ((TextComponent)this.subtypeTextField).setText("x-");
        } else {
            ((TextComponent)this.subtypeTextField).setText(string);
        }
        return true;
    }

    private int mapTypeToChoice(String string) {
        int n = this.typeChoices.countItems();
        int n2 = 0;
        while (n2 < n) {
            if (string.equalsIgnoreCase(this.typeChoices.getItem(n2))) {
                return n2;
            }
            ++n2;
        }
        return 0;
    }

    private String getViewerType(MimeEntry mimeEntry) {
        String string = mimeEntry.getType();
        int n = string.indexOf("/");
        return string.substring(0, n);
    }

    private String getViewerSubtype(MimeEntry mimeEntry) {
        String string = mimeEntry.getType();
        int n = string.indexOf("/");
        return string.substring(n + 1);
    }

    public void clear() {
        int n = this.typesList.getSelectedIndex();
        if (n != -1) {
            this.typesList.deselect(n);
        }
        this.newDefinition.setEnabled(false);
        this.delete.setEnabled(false);
        this.actionChoices.select(1);
        ((TextComponent)this.description).setText("");
        ((TextComponent)this.extensions).setText("");
        ((TextComponent)this.application).setText("");
        this.application.setEditable(true);
        this.applicationLabel.setEnabled(true);
        this.chooseApplication.setEnabled(true);
    }

    public File askUserForFile(String string, int n) {
        return this.askUserForFile(string, n, null);
    }

    public File askUserForFile(String string, int n, String string2) {
        HJFrame hJFrame = HJWindowManager.getHJWindowManager().getLastFocusHolder();
        File file = null;
        UserFileDialog userFileDialog = new UserFileDialog((Frame)hJFrame, string, n);
        userFileDialog.setDirectory(this.getFileDialogDirectory());
        if (string2 != null) {
            userFileDialog.setFile(string2);
        }
        userFileDialog.show();
        hJFrame.showStatus("");
        String string3 = userFileDialog.getDirectory();
        ContentViewersPreferencesDialog.setFileDialogDirectory(string3);
        String string4 = userFileDialog.getFile();
        if (string4 != null) {
            if (string3.endsWith(File.separator)) {
                string3 = string3.substring(0, string3.lastIndexOf(File.separator));
            }
            file = new File(string3, string4);
            if (n == 1 && !userFileDialog.providesSaveConfirmation() && file.exists()) {
                ConfirmDialog confirmDialog = new ConfirmDialog("overwrite.file", hJFrame);
                confirmDialog.show();
                if (confirmDialog.getAnswer() == 0) {
                    file = null;
                }
            }
        }
        return file;
    }

    private String getFileDialogDirectory() {
        if (fileDialogDirectory == null) {
            fileDialogDirectory = System.getProperty("hotjava.file.dialog.directory");
            if (fileDialogDirectory != null) {
                File file = new File(fileDialogDirectory);
                try {
                    if (!file.isDirectory()) {
                        fileDialogDirectory = null;
                    }
                }
                catch (SecurityException securityException) {
                    fileDialogDirectory = null;
                }
            }
            if (fileDialogDirectory == null) {
                fileDialogDirectory = Boolean.getBoolean("hotjava.file.dialog.use.startup.dir") ? System.getProperty("user.dir") : System.getProperty("user.home");
            }
        }
        return fileDialogDirectory;
    }

    public static void setFileDialogDirectory(String string) {
        fileDialogDirectory = string;
    }

    protected int mapChoiceToAction(int n) {
        return choiceToActionMapping[n];
    }

    protected int mapActionToChoice(int n) {
        return actionToChoiceMapping[n];
    }

    static {
        int[] nArray = new int[4];
        nArray[0] = 1;
        nArray[1] = 3;
        nArray[2] = 2;
        choiceToActionMapping = nArray;
        int[] nArray2 = new int[4];
        nArray2[0] = 3;
        nArray2[2] = 2;
        nArray2[3] = 1;
        actionToChoiceMapping = nArray2;
    }

    class ButtonPanel
    extends Panel
    implements ActionListener {
        GridBagLayout gridbag;
        GridBagConstraints c;
        private ContentViewersPreferencesDialog contentViewer;
        private HJBProperties props1;
        private UIHJButton defaultButton;
        private final int OK = 0;
        private final int APPLY = 1;
        private final int CANCEL = 2;
        private final int HELP = 3;
        private UIHJButton[] cmdButtons = new UIHJButton[4];

        public ButtonPanel(ContentViewersPreferencesDialog contentViewersPreferencesDialog2) {
            ContentViewersPreferencesDialog.this = ContentViewersPreferencesDialog.this;
            this.props1 = HJBProperties.getHJBProperties("hjbrowser");
            this.contentViewer = contentViewersPreferencesDialog2;
            this.setLayout(new FlowLayout(2));
            this.addButtons();
        }

        public Dimension getMinimumSize() {
            return new Dimension(this.getParent().getSize().width, 50);
        }

        public Dimension getPreferredSize() {
            return this.getMinimumSize();
        }

        public void doDefaultAction() {
            if (this.defaultButton == null) {
                int n = 0;
                while (n < this.cmdButtons.length) {
                    if (this.cmdButtons[n].isDefault()) {
                        this.defaultButton = this.cmdButtons[n];
                        break;
                    }
                    ++n;
                }
            }
            ActionEvent actionEvent = new ActionEvent(this.defaultButton, 0, this.defaultButton.getActionCommand());
            this.actionPerformed(actionEvent);
        }

        public void addButtons() {
            String string = "prefsdialog";
            UIHJButtonGroup uIHJButtonGroup = new UIHJButtonGroup(this.props1);
            this.cmdButtons[0] = new UIHJButton(String.valueOf(string) + ".ok", this.props1);
            this.cmdButtons[0].setActionCommand("ok");
            this.cmdButtons[1] = new UIHJButton(String.valueOf(string) + ".apply", this.props1);
            this.cmdButtons[1].setActionCommand("apply");
            this.cmdButtons[2] = new UIHJButton(String.valueOf(string) + ".cancel", this.props1);
            this.cmdButtons[2].setActionCommand("cancel");
            this.cmdButtons[3] = new UIHJButton(String.valueOf(string) + ".help", this.props1);
            this.cmdButtons[3].setActionCommand("help");
            int n = 0;
            while (n < this.cmdButtons.length) {
                this.add(this.cmdButtons[n]);
                this.cmdButtons[n].addActionListener(this);
                uIHJButtonGroup.addButtonToGroup(this.cmdButtons[n]);
                ++n;
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getActionCommand().equals("ok")) {
                this.contentViewer.ok();
                return;
            }
            if (actionEvent.getActionCommand().equals("apply")) {
                this.contentViewer.apply();
                return;
            }
            if (actionEvent.getActionCommand().equals("cancel")) {
                this.contentViewer.cancel();
                return;
            }
            if (actionEvent.getActionCommand().equals("help")) {
                this.contentViewer.help();
            }
        }
    }
}

