/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xfile;

import com.sun.xfile.XFile;
import com.sun.xfile.XFileAccessor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

public class XFileInputStream
extends InputStream {
    private long fp;
    private XFileAccessor xfa;

    public XFileInputStream(XFile xFile) throws IOException {
        this.xfa = xFile.newAccessor();
        if (!this.xfa.open(xFile, true, true)) {
            throw new FileNotFoundException("no file");
        }
        if (!this.xfa.canRead()) {
            throw new IOException("no read permission");
        }
    }

    public XFileInputStream(String string) throws IOException {
        this(new XFile(string));
    }

    private synchronized int XFAread(byte[] byArray, int n, int n2) throws IOException {
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n2 == 0) {
            return 0;
        }
        if (n < 0 || n2 < 0 || n >= byArray.length || n + n2 > byArray.length) {
            throw new IllegalArgumentException("Invalid argument");
        }
        int n3 = this.xfa.read(byArray, n, n2, this.fp);
        if (n3 <= 0) {
            return -1;
        }
        this.fp += (long)n3;
        return n3;
    }

    public int read() throws IOException {
        byte[] byArray = new byte[1];
        if (this.XFAread(byArray, 0, 1) != 1) {
            return -1;
        }
        return byArray[0];
    }

    public int read(byte[] byArray) throws IOException {
        return this.XFAread(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        return this.XFAread(byArray, n, n2);
    }

    public int available() throws IOException {
        return (int)(this.xfa.length() - this.fp);
    }

    public long skip(long l) throws IOException {
        if (l < 0L) {
            throw new IllegalArgumentException("illegal skip: " + l);
        }
        this.fp += l;
        return l;
    }

    public void close() throws IOException {
        this.xfa.close();
    }
}

