/*
 * Decompiled with CFR 0.152.
 */
package com.sun.rpc;

import com.sun.rpc.Connection;
import com.sun.rpc.Xdr;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;

public class ConnectDatagram
extends Connection {
    DatagramSocket ds = new DatagramSocket();
    DatagramPacket dp;
    InetAddress addr;

    public ConnectDatagram(String string, int n, int n2) throws IOException {
        super(string, n, "udp", n2);
        this.addr = InetAddress.getByName(string);
        this.start();
    }

    void sendOne(Xdr xdr) throws IOException {
        this.interrupt();
        this.ds.send(new DatagramPacket(xdr.xdr_buf(), xdr.xdr_offset(), this.addr, this.port));
    }

    void receiveOne(Xdr xdr, int n) throws IOException {
        this.ds.setSoTimeout(n);
        this.dp = new DatagramPacket(xdr.xdr_buf(), xdr.xdr_buf().length);
        this.ds.receive(this.dp);
    }

    InetAddress getPeer() {
        return this.dp.getAddress();
    }

    void dropConnection() {
        this.suspend();
    }

    void checkConnection() {
        this.resume();
    }

    protected void finalize() throws Throwable {
        if (this.ds != null) {
            this.ds.close();
            this.ds = null;
        }
        super.finalize();
    }
}

