/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.im;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Toolkit;
import sun.awt.SunToolkit;
import sun.awt.im.InputMethod;
import sun.awt.im.InputMethodAdapter;
import sun.awt.im.InputMethodContext;

public class InputContext {
    private InputMethod inputMethod;
    private boolean inputMethodCreationFailed;
    private Component currentClientComponent;

    protected InputContext() {
    }

    public static InputContext getInstance() {
        return new InputMethodContext();
    }

    public synchronized void dispatchEvent(AWTEvent aWTEvent) {
        InputMethod inputMethod = this.getInputMethod();
        int n = aWTEvent.getID();
        switch (n) {
            case 103: {
                this.dispose();
                this.currentClientComponent = null;
                return;
            }
            case 1004: {
                this.activate((Component)aWTEvent.getSource());
                if (inputMethod == null) break;
                inputMethod.dispatchEvent(aWTEvent);
                return;
            }
            case 1005: {
                if (inputMethod != null) {
                    inputMethod.dispatchEvent(aWTEvent);
                }
                this.deactivate((Component)aWTEvent.getSource());
                return;
            }
            default: {
                if (inputMethod == null) break;
                inputMethod.dispatchEvent(aWTEvent);
            }
        }
    }

    synchronized void activate(Component component) {
        this.currentClientComponent = component;
        if (this.inputMethod != null) {
            if (this.inputMethod instanceof InputMethodAdapter) {
                ((InputMethodAdapter)this.inputMethod).setClientComponent(component);
            }
            this.inputMethod.activate();
        }
    }

    synchronized void deactivate(Component component) {
        if (this.inputMethod != null) {
            this.inputMethod.deactivate();
        }
        this.currentClientComponent = null;
    }

    Component getClientComponent() {
        Component component = this.currentClientComponent;
        return component;
    }

    public void dispose() {
        if (this.inputMethod != null) {
            this.inputMethod.dispose();
            this.inputMethod = null;
        }
    }

    InputMethod getInputMethod() {
        if (this.inputMethod != null) {
            return this.inputMethod;
        }
        if (this.inputMethodCreationFailed) {
            return null;
        }
        try {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            this.inputMethod = ((SunToolkit)toolkit).getInputMethodAdapter();
        }
        catch (Exception exception) {
            this.inputMethodCreationFailed = true;
        }
        if (this.inputMethod != null) {
            this.inputMethod.setInputContext((InputMethodContext)this);
        }
        return this.inputMethod;
    }
}

