/*
 * Decompiled with CFR 0.152.
 */
package sunw.hotjava.doc;

import java.awt.Container;
import java.net.URL;
import sunw.hotjava.doc.DocFont;
import sunw.hotjava.doc.Document;
import sunw.hotjava.doc.DocumentFormatter;
import sunw.hotjava.doc.PreservedState;

public class DocumentFormatterRef {
    private DocumentFormatter formatter;
    private PreservedState preservedState;
    private int refCount;
    public boolean offsetStored = false;

    public DocumentFormatterRef(Container container, Document document, DocFont docFont) {
        this.formatter = new DocumentFormatter(container, document, docFont);
    }

    public DocumentFormatter getFormatter() {
        if (this.formatter == null) {
            this.reconstitute();
        } else {
            this.formatter.setRepaintOnWake(true);
        }
        return this.formatter;
    }

    public void updateDocument() {
        if (this.formatter == null) {
            return;
        }
        if (this.formatter.getDocument().isExpired()) {
            this.flush();
            this.reconstitute();
            return;
        }
        this.formatter.updateDocument();
    }

    DocumentFormatter getFormatterIfNotRemoved() {
        return this.formatter;
    }

    public Document getDocument() {
        DocumentFormatter documentFormatter = this.getFormatter();
        return documentFormatter.getDocument();
    }

    public URL getURL() {
        URL uRL = this.formatter != null ? this.formatter.getDocument().getURL() : this.preservedState.getURL();
        return uRL;
    }

    boolean isDocument(Document document) {
        return this.formatter != null && this.formatter.getDocument() == document;
    }

    public void setDocFont(DocFont docFont) {
        if (this.formatter != null) {
            this.formatter.setDocFont(docFont);
            return;
        }
        this.preservedState.setDocFont(docFont);
    }

    public void addClient() {
        ++this.refCount;
    }

    public void removeClient() {
        if (this.refCount > 0) {
            --this.refCount;
            if (this.refCount == 0) {
                this.flush();
            }
        }
    }

    public void removeAllClients() {
        if (this.refCount > 0) {
            this.refCount = 0;
            this.flush();
        }
    }

    private void flush() {
        this.preservedState = new PreservedState(this.formatter);
        this.formatter.stop();
        this.formatter.destroy();
        this.formatter = null;
    }

    private void reconstitute() {
        this.formatter = this.preservedState.reconstituteFormatter();
        this.preservedState = null;
    }
}

