/*
 * Decompiled with CFR 0.152.
 */
package java.text;

final class CompactIntArray
implements Cloneable {
    public static final int UNICODECOUNT = 65536;
    private static final int DEBUGSHOWOVERLAPLIMIT = 100;
    private static final boolean DEBUGTRACE = false;
    private static final boolean DEBUGSMALL = false;
    private static final boolean DEBUGOVERLAP = false;
    private static final int DEBUGSMALLLIMIT = 30000;
    private static final int BLOCKSHIFT = 7;
    private static final int BLOCKCOUNT = 128;
    private static final int INDEXSHIFT = 9;
    private static final int INDEXCOUNT = 512;
    private static final int BLOCKMASK = 127;
    private int[] values;
    private short[] indices;
    private boolean isCompact;

    public CompactIntArray() {
        this(0);
    }

    public CompactIntArray(int n) {
        this.values = new int[65536];
        this.indices = new short[512];
        int n2 = 0;
        while (n2 < 65536) {
            this.values[n2] = n;
            ++n2;
        }
        n2 = 0;
        while (n2 < 512) {
            this.indices[n2] = (short)(n2 << 7);
            ++n2;
        }
        this.isCompact = false;
    }

    public CompactIntArray(short[] sArray, int[] nArray) {
        if (sArray.length != 512) {
            throw new IllegalArgumentException("Index out of bounds.");
        }
        int n = 0;
        while (n < 512) {
            short s = sArray[n];
            if (s < 0 || s >= nArray.length + 128) {
                throw new IllegalArgumentException("Index out of bounds.");
            }
            ++n;
        }
        this.indices = sArray;
        this.values = nArray;
    }

    public int elementAt(char c) {
        return this.values[(this.indices[c >> 7] & 0xFFFF) + (c & 0x7F)];
    }

    public void setElementAt(char c, int n) {
        if (this.isCompact) {
            this.expand();
        }
        this.values[c] = n;
    }

    public void setElementAt(char n, char c, int n2) {
        if (this.isCompact) {
            this.expand();
        }
        int n3 = n;
        while (n3 <= c) {
            this.values[n3] = n2;
            ++n3;
        }
    }

    public void compact() {
        if (!this.isCompact) {
            char[] cArray = new char[65536];
            int n = 128;
            int n2 = 0;
            while (n2 < 128) {
                cArray[n2] = (char)n2;
                ++n2;
            }
            this.indices[0] = 0;
            int n3 = 1;
            while (n3 < 512) {
                int n4 = n3 << 7;
                int n5 = this.FindOverlappingPosition(n4, cArray, n);
                int n6 = n5 + 128;
                if (n6 > n) {
                    n2 = n;
                    while (n2 < n6) {
                        cArray[n2] = (char)(n2 - n5 + n4);
                        ++n2;
                    }
                    n = n6;
                }
                this.indices[n3] = (short)n5;
                ++n3;
            }
            int[] nArray = new int[n];
            n2 = 0;
            while (n2 < n) {
                nArray[n2] = this.values[cArray[n2]];
                ++n2;
            }
            this.values = null;
            this.values = nArray;
            this.isCompact = true;
        }
    }

    public short[] getIndexArray() {
        return this.indices;
    }

    public int[] getStringArray() {
        return this.values;
    }

    public Object clone() {
        try {
            CompactIntArray compactIntArray = (CompactIntArray)super.clone();
            compactIntArray.values = (int[])this.values.clone();
            compactIntArray.indices = (short[])this.indices.clone();
            return compactIntArray;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        CompactIntArray compactIntArray = (CompactIntArray)object;
        int n = 0;
        while (n < 65536) {
            if (this.elementAt((char)n) != compactIntArray.elementAt((char)n)) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public int hashCode() {
        int n = 0;
        int n2 = Math.min(3, this.values.length / 16);
        int n3 = 0;
        while (n3 < this.values.length) {
            n = n * 37 + this.values[n3];
            n3 += n2;
        }
        return n;
    }

    void writeArrays() {
        int n = this.values.length > 0 ? this.values.length : this.values.length + 65536;
        System.out.println("{");
        int n2 = 0;
        while (n2 < 511) {
            System.out.print("(short)" + (this.indices[n2] >= 0 ? this.indices[n2] : this.indices[n2] + 65536) + ", ");
            if (n2 != 0 && n2 % 10 == 0) {
                System.out.println();
            }
            ++n2;
        }
        System.out.println("(short)" + (this.indices[511] >= 0 ? this.indices[n2] : this.indices[n2] + 65536) + " }");
        System.out.println("{");
        n2 = 0;
        while (n2 < n - 1) {
            System.out.print(String.valueOf(this.values[n2]) + ", ");
            if (n2 != 0 && n2 % 16 == 0) {
                System.out.println();
            }
            ++n2;
        }
        System.out.println(String.valueOf(this.values[n - 1]) + " }");
    }

    void printIndex(short n, short s) {
        int n2 = n;
        while (n2 < s) {
            System.out.println(String.valueOf(n2) + " -> : " + (this.indices[n2] >= 0 ? this.indices[n2] : this.indices[n2] + 65536));
            ++n2;
        }
        System.out.println();
    }

    void printPlainArray(int n, int n2, char[] cArray) {
        if (cArray != null) {
            int n3 = n;
            while (n3 < n + n2) {
                System.out.print(" " + this.values[cArray[n3]]);
                ++n3;
            }
        } else {
            int n4 = n;
            while (n4 < n + n2) {
                System.out.print(" " + this.values[n4]);
                ++n4;
            }
        }
        System.out.println("    Range: start " + n + " , count " + n2);
    }

    private void expand() {
        if (this.isCompact) {
            int[] nArray = new int[65536];
            int n = 0;
            while (n < 65536) {
                nArray[n] = this.elementAt((char)n);
                ++n;
            }
            n = 0;
            while (n < 512) {
                this.indices[n] = (short)(n << 7);
                ++n;
            }
            this.values = null;
            this.values = nArray;
            this.isCompact = false;
        }
    }

    private short capacity() {
        return (short)this.values.length;
    }

    private int[] getArray() {
        return this.values;
    }

    private int FindOverlappingPosition(int n, char[] cArray, int n2) {
        int n3 = 0;
        while (n3 < n2) {
            int n4 = 128;
            if (n3 + 128 > n2) {
                n4 = (short)(n2 - n3);
            }
            int n5 = 0;
            while (n5 < n4) {
                if (this.values[n + n5] != this.values[cArray[n3 + n5]]) break;
                n5 = (short)(n5 + 1);
            }
            if (n5 == n4) break;
            n3 += 128;
        }
        return n3;
    }
}

