/*
 * Decompiled with CFR 0.152.
 */
package sunw.hotjava.ui;

import java.awt.TextArea;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import sunw.hotjava.ui.Console;

class ConsoleOutput {
    TextArea consoleTextArea;
    ConsoleOutputStream out;
    ConsoleOutputStream err;

    ConsoleOutput(TextArea textArea) throws Throwable {
        this.consoleTextArea = textArea;
        this.out = new ConsoleOutputStream(System.out);
        this.err = new ConsoleOutputStream(System.err);
        try {
            System.setOut(new PrintStream(this.out, true));
            System.setErr(new PrintStream(this.err, true));
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            this.err = null;
            this.out = null;
            throw throwable;
        }
    }

    void dispose() {
        if (this.out == null || this.err == null) {
            return;
        }
        try {
            System.setOut(this.out.oldPrintStream);
            System.setErr(this.err.oldPrintStream);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            Console.showStatus("restoreFail.msg");
        }
        Console.showStatus("disabled.msg");
    }

    void clear() {
        this.consoleTextArea.setText("");
    }

    class ConsoleOutputStream
    extends ByteArrayOutputStream {
        PrintStream oldPrintStream;

        ConsoleOutputStream(PrintStream printStream) {
            super(128);
            ConsoleOutput.this = ConsoleOutput.this;
            this.oldPrintStream = printStream;
        }

        public synchronized void flush() {
            ConsoleOutput.this.consoleTextArea.append(this.toString());
            try {
                this.writeTo(this.oldPrintStream);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            this.reset();
        }
    }
}

