/*
 * Decompiled with CFR 0.152.
 */
package sunw.hotjava.bean;

import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import sunw.hotjava.bean.PoolEntry;
import sunw.hotjava.bean.URLPoolEvent;
import sunw.hotjava.bean.URLPoolListener;
import sunw.hotjava.bean.URLPooler;
import sunw.hotjava.misc.HJBProperties;

public class URLPool
implements URLPooler,
Runnable {
    private static Hashtable pool;
    private static long expire;
    private static transient Vector urlpoolListeners;
    private static HJBProperties properties;
    private static boolean initialized;
    private static final int DEFAULT_EXPIRE = 7;
    private static final int MSPERDAY = 86400000;
    private static String fname;

    public URLPool() {
        if (!initialized) {
            this.initURLPool();
        }
    }

    private void initURLPool() {
        initialized = true;
        urlpoolListeners = null;
        pool = new Hashtable();
        expire = 604800000L;
    }

    public PoolEntry[] getURLPoolEntries() {
        PoolEntry[] poolEntryArray;
        Hashtable hashtable;
        int n = 0;
        Hashtable hashtable2 = hashtable = pool;
        synchronized (hashtable2) {
            hashtable = (Hashtable)pool.clone();
            poolEntryArray = new PoolEntry[hashtable.size()];
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                Date date = (Date)hashtable.get(string);
                poolEntryArray[n++] = new PoolEntry(date, string);
            }
        }
        return poolEntryArray;
    }

    public void addToURLPool(PoolEntry[] poolEntryArray) {
        if (poolEntryArray != null) {
            int n = 0;
            while (n < poolEntryArray.length) {
                this.add(poolEntryArray[n].url, poolEntryArray[n].lastTouched);
                ++n;
            }
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean createURLPoolFromFile(String var1_1) {
        new Hashtable<K, V>();
        System.err.println("Loading: " + var1_1);
        if (var1_1 == null) {
            return false;
        }
        try {
            var2_2 = null;
            try {
                var2_2 = new BufferedInputStream(new FileInputStream(var1_1));
                var5_3 = new char[512];
                var6_4 = var2_2.read();
                var7_5 = new Date().getTime();
                ** GOTO lbl41
                {
                    var6_4 = var2_2.read();
                    do {
                        if (var6_4 == 32 || var6_4 == 9 || var6_4 == 10 || var6_4 == 13) continue block6;
                        if (var6_4 == 35) ** GOTO lbl20
                        var9_6 = 0L;
                        if (true) ** GOTO lbl25
lbl-1000:
                        // 1 sources

                        {
                            var6_4 = var2_2.read();
lbl20:
                            // 2 sources

                            ** while (var6_4 != -1 && var6_4 != 10 && var6_4 != 13)
                        }
lbl21:
                        // 1 sources

                        continue;
                        do {
                            var9_6 = var9_6 * 10L + (long)var6_4 - 48L;
                            var6_4 = var2_2.read();
lbl25:
                            // 2 sources

                        } while (var6_4 >= 48 && var6_4 <= 57);
                        var9_6 *= 1000L;
                        while (var6_4 == 32 || var6_4 == 9) {
                            var6_4 = var2_2.read();
                        }
                        var11_7 = 0;
                        while (var6_4 != -1 && var6_4 != 10 && var6_4 != 13) {
                            if (var11_7 < var5_3.length) {
                                var5_3[var11_7++] = (char)var6_4;
                            }
                            var6_4 = var2_2.read();
                        }
                        if (var11_7 <= 0 || var7_5 - var9_6 >= URLPool.expire) continue;
                        var12_8 = new char[var11_7];
                        System.arraycopy(var5_3, 0, var12_8, 0, var11_7);
                        var13_9 = new String(var12_8, 0, var11_7);
                        this.add(var13_9, new Date(var9_6));
lbl41:
                        // 4 sources

                    } while (var6_4 > 0);
                }
                return true;
            }
            finally {
                var4_10 = null;
                if (var2_2 != null) {
                    var2_2.close();
                }
            }
        }
        catch (FileNotFoundException v0) {
            System.err.println("Failed to load: " + var1_1);
            return false;
        }
        catch (IOException v1) {
            System.err.println("Failed to load: " + var1_1);
            return false;
        }
    }

    public void add(String string) {
        Date date = new Date();
        this.add(string, date);
    }

    private void add(String string, Date date) {
        Date date2 = pool.put(string, date);
        if (date2 == null || !date2.equals(date)) {
            this.fireURLPoolEvent(new URLPoolEvent(0));
        }
    }

    public void saveURLPoolToFile(String string) {
        if (string != null) {
            fname = string;
            Thread thread = new Thread((Runnable)this, "SaveURLPool");
            thread.setPriority(3);
            thread.start();
        }
    }

    public Date get(String string) {
        return (Date)pool.get(string);
    }

    public void run() {
        Object object;
        Enumeration enumeration;
        String[] stringArray;
        System.err.println("Saving: " + fname);
        int n = 0;
        Hashtable hashtable = pool;
        Object object2 = hashtable;
        synchronized (object2) {
            stringArray = new String[hashtable.size()];
            enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                object = (String)enumeration.nextElement();
                stringArray[n++] = object;
            }
        }
        try {
            object2 = null;
            try {
                object = new Date();
                long l = ((Date)object).getTime();
                object2 = new PrintWriter((Writer)new BufferedWriter(new FileWriter(fname)), false);
                ((PrintWriter)object2).println("# " + object);
                int n2 = 0;
                while (n2 < n) {
                    String string = stringArray[n2];
                    Date date = (Date)hashtable.get(string);
                    if (date != null) {
                        long l2 = date.getTime();
                        if (l - l2 < expire) {
                            ((PrintWriter)object2).print(l2 / 1000L);
                            ((PrintWriter)object2).print(' ');
                            ((PrintWriter)object2).println(string);
                        } else {
                            pool.remove(string);
                        }
                    }
                    ++n2;
                }
                return;
            }
            finally {
                enumeration = null;
                if (object2 != null) {
                    ((PrintWriter)object2).close();
                }
            }
        }
        catch (IOException iOException) {
            System.err.println("Failed to save: " + fname);
            return;
        }
    }

    public void setURLExpirationAmt(int n) {
        expire = 86400000 * n;
    }

    public int getURLExpirationAmt() {
        return (int)(expire / 86400000L);
    }

    public void discardAllURLs() {
        pool.clear();
        this.fireURLPoolEvent(new URLPoolEvent(1));
    }

    public void purgeExpiredURLs() {
        String[] stringArray;
        int n = 0;
        Hashtable hashtable = pool;
        Cloneable cloneable = hashtable;
        synchronized (cloneable) {
            stringArray = new String[hashtable.size()];
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                stringArray[n++] = string;
            }
        }
        cloneable = new Date();
        long l = ((Date)cloneable).getTime();
        int n2 = 0;
        while (n2 < n) {
            long l2;
            String string = stringArray[n2];
            Date date = (Date)hashtable.get(string);
            if (date != null && l - (l2 = date.getTime()) >= expire) {
                pool.remove(string);
            }
            ++n2;
        }
    }

    public void addURLPoolListener(URLPoolListener uRLPoolListener) {
        if (urlpoolListeners == null) {
            urlpoolListeners = new Vector(2, 2);
        }
        urlpoolListeners.addElement(uRLPoolListener);
    }

    public void removeURLPoolListener(URLPoolListener uRLPoolListener) {
        if (urlpoolListeners != null) {
            urlpoolListeners.removeElement(uRLPoolListener);
            if (urlpoolListeners.size() == 0) {
                urlpoolListeners = null;
            }
        }
    }

    public void fireURLPoolEvent(URLPoolEvent uRLPoolEvent) {
        if (urlpoolListeners == null) {
            return;
        }
        int n = urlpoolListeners.size();
        int n2 = 0;
        while (n2 < n) {
            URLPoolListener uRLPoolListener = (URLPoolListener)urlpoolListeners.elementAt(n2);
            uRLPoolListener.urlPoolChanged(uRLPoolEvent);
            ++n2;
        }
    }
}

