/*
 * Decompiled with CFR 0.152.
 */
package sunw.hotjava.tags;

import java.awt.Graphics;
import sunw.hotjava.doc.DocLine;
import sunw.hotjava.doc.DocStyle;
import sunw.hotjava.doc.Document;
import sunw.hotjava.doc.EmptyTagItem;
import sunw.hotjava.doc.Floatable;
import sunw.hotjava.doc.FormatState;
import sunw.hotjava.doc.Formatter;
import sunw.hotjava.doc.MeasureState;
import sunw.hotjava.doc.Measurement;
import sunw.hotjava.doc.TagItem;
import sunw.hotjava.doc.VBreakInfo;
import sunw.hotjava.tags.Align;

public class SPACER
extends EmptyTagItem
implements Floatable {
    private static final int HORIZONTAL = 0;
    private static final int VERTICAL = 1;
    private static final int BLOCK = 2;
    private int type;
    private int align;
    private int height;
    private int width;
    private int size;

    public void init(Document document) {
        String string = this.getAttribute("type");
        if (string == null) {
            string = "horizontal";
        }
        this.type = string.equals("vertical") ? 1 : (string.equals("block") ? 2 : 0);
        this.align = Align.getAlign(this.atts);
        if (this.type == 2) {
            this.height = TagItem.parseInt(this.atts, "height", 0, 0);
            this.width = TagItem.parseInt(this.atts, "width", 0, 0);
            return;
        }
        this.size = TagItem.parseInt(this.atts, "size", 0, 0);
    }

    public int getAscent(Formatter formatter, FormatState formatState) {
        switch (this.type) {
            case 0: {
                return 0;
            }
            case 1: {
                return Align.getAscent(formatState, this.align, this.size);
            }
            case 2: {
                return Align.getAscent(formatState, this.align, this.height);
            }
        }
        return 0;
    }

    public int getDescent(Formatter formatter, FormatState formatState) {
        switch (this.type) {
            case 0: {
                return 0;
            }
            case 1: {
                return Align.getDescent(formatState, this.align, this.size);
            }
            case 2: {
                return Align.getDescent(formatState, this.align, this.height);
            }
        }
        return 0;
    }

    public int getWidth(DocStyle docStyle) {
        switch (this.type) {
            case 0: {
                return this.size;
            }
            case 1: {
                return 0;
            }
            case 2: {
                return this.width;
            }
        }
        return 0;
    }

    public boolean format(Formatter formatter, FormatState formatState, FormatState formatState2) {
        switch (this.type) {
            case 0: {
                return this.formatHorizontal(formatter, formatState, formatState2);
            }
            case 1: {
                return this.formatVertical(formatter, formatState, formatState2);
            }
            case 2: {
                return this.formatBlock(formatter, formatState, formatState2);
            }
        }
        return false;
    }

    private boolean formatHorizontal(Formatter formatter, FormatState formatState, FormatState formatState2) {
        return super.format(formatter, formatState, formatState2);
    }

    private boolean formatVertical(Formatter formatter, FormatState formatState, FormatState formatState2) {
        if (formatState.state != 0) {
            formatState.below = Math.max(formatState.below, this.size);
            return true;
        }
        formatState.state = 1;
        formatState.pos += this.getIncrement();
        return false;
    }

    private boolean formatBlock(Formatter formatter, FormatState formatState, FormatState formatState2) {
        if (this.alignIsFloating()) {
            boolean bl = false;
            if (!formatter.isFloater(this) && formatState.width + this.getWidth(formatter, formatState.style) > formatState.maxWidth) {
                if (formatState.startPos != formatState.pos) {
                    formatState.below += formatter.getCumulativeFloaterHeight(formatState.y);
                    return true;
                }
                bl = true;
            }
            formatter.queueFloater(formatter, formatState, this, this.getAscent(formatter, formatState) + this.getDescent(formatter, formatState), this.align == 7);
            formatState.pos += this.getIncrement();
            return bl;
        }
        return super.format(formatter, formatState, formatState2);
    }

    public boolean measureItem(Formatter formatter, FormatState formatState, Measurement measurement, MeasureState measureState) {
        int n = this.getWidth(formatter, measureState.style);
        if (this.type == 2 && this.alignIsFloating()) {
            measurement.setFloaterMinWidth(n);
            measurement.setFloaterPreferredWidth(n);
        } else {
            measurement.setMinWidth(n);
            measurement.setPreferredWidth(n);
        }
        measureState.pos += this.getIncrement();
        return false;
    }

    private boolean alignIsFloating() {
        return this.align == 7 || this.align == 8;
    }

    public int paint(Formatter formatter, Graphics graphics, int n, int n2, DocLine docLine) {
        formatter.displayPos += this.getIncrement();
        if (this.alignIsFloating()) {
            return 0;
        }
        return this.getWidth(formatter.displayStyle);
    }

    public int paint(Formatter formatter, Graphics graphics, int n, int n2) {
        formatter.displayPos += this.getIncrement();
        return this.getWidth(formatter.displayStyle);
    }

    public int print(Formatter formatter, Graphics graphics, int n, int n2, VBreakInfo vBreakInfo) {
        return this.paint(formatter, graphics, n, n2);
    }
}

