/*
 * Decompiled with CFR 0.152.
 */
package sunw.hotjava.protocol.http;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Locale;
import sun.net.ProgressData;
import sun.net.ProgressEntry;
import sun.net.www.protocol.http.HttpURLConnection;
import sunw.hotjava.bean.CookieJarInterface;
import sunw.hotjava.bean.HotJavaBrowserBean;
import sunw.hotjava.misc.HJBProperties;
import sunw.hotjava.misc.RequestProcessor;
import sunw.hotjava.protocol.http.Handler;

public class HttpURLConnectionCookie
extends HttpURLConnection {
    private boolean inputGiven = false;
    private HandleUnclosedStream unclosedStreamHandler = new HandleUnclosedStream();
    private static CookieJarInterface cookiesObj = HotJavaBrowserBean.getCookiesManager();

    protected HttpURLConnectionCookie(URL uRL, Handler handler) throws IOException {
        super(uRL, handler);
    }

    public HttpURLConnectionCookie(URL uRL, String string, int n) {
        super(uRL, string, n);
    }

    public void connect() throws IOException {
        if (!this.connected && cookiesObj != null) {
            HJBProperties hJBProperties = HJBProperties.getHJBProperties("beanPropertiesKey");
            String string = System.getProperty("http.agent", "hotjava");
            String string2 = String.valueOf(System.getProperty("os.arch", "")) + " [" + Locale.getDefault().getLanguage() + "] " + System.getProperty("os.name", "") + " " + System.getProperty("os.version", "") + "; " + hJBProperties.getProperty("browser.differentiator", "");
            string = String.valueOf(string) + " (" + string2 + ")";
            this.setRequestProperty("User-Agent", string);
            cookiesObj.applyRelevantCookies(this.url, this);
        }
        super.connect();
    }

    public InputStream getInputStream() throws IOException {
        InputStream inputStream = super.getInputStream();
        HttpURLConnectionCookie httpURLConnectionCookie = this;
        synchronized (httpURLConnectionCookie) {
            if (!this.inputGiven) {
                this.inputGiven = true;
                if (cookiesObj != null) {
                    cookiesObj.recordAnyCookies(this);
                }
            }
        }
        return inputStream;
    }

    public String getContentType() {
        String string = this.getHeaderField("content-type");
        if (string != null && string.endsWith("x-x509-ca-cert")) {
            string = string.replace('-', '_');
        }
        return string;
    }

    public void finalize() {
        if (this.pe != null) {
            this.unclosedStreamHandler.setProgressEntry(this.pe);
            RequestProcessor.getHJBeanQueue().postRequest(this.unclosedStreamHandler);
            this.pe = null;
        }
    }

    class HandleUnclosedStream
    extends RequestProcessor.Request {
        ProgressEntry pe;

        public HandleUnclosedStream() {
            HttpURLConnectionCookie.this = HttpURLConnectionCookie.this;
        }

        public void setProgressEntry(ProgressEntry progressEntry) {
            this.pe = progressEntry;
        }

        public void execute() {
            ProgressData.pdata.unregister(this.pe);
            this.pe = null;
        }
    }
}

