/*
 * Decompiled with CFR 0.152.
 */
package sun.security.x509;

import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.util.Date;
import sun.security.pkcs.PKCS10;
import sun.security.util.BigInt;
import sun.security.x509.CertException;
import sun.security.x509.X500Name;
import sun.security.x509.X500Signer;
import sun.security.x509.X509Cert;
import sun.security.x509.X509Key;

public final class CertAndKeyGen {
    private SecureRandom prng;
    private String sigAlg;
    private KeyPairGenerator keyGen;
    private X509Key publicKey;
    private PrivateKey privateKey;

    public CertAndKeyGen(String string, String string2) throws NoSuchAlgorithmException {
        this.keyGen = KeyPairGenerator.getInstance(string);
        this.sigAlg = string2;
    }

    public void setRandom(SecureRandom secureRandom) {
        this.prng = secureRandom;
    }

    public void generate(int n) throws InvalidKeyException {
        KeyPair keyPair;
        try {
            if (this.prng == null) {
                this.prng = new SecureRandom();
            }
            this.keyGen.initialize(n, this.prng);
            keyPair = this.keyGen.generateKeyPair();
        }
        catch (Exception exception) {
            throw new IllegalArgumentException(exception.getMessage());
        }
        PublicKey publicKey = keyPair.getPublic();
        if (!(publicKey instanceof X509Key)) {
            throw new InvalidKeyException("public key " + publicKey + " not an X509Key.");
        }
        this.publicKey = (X509Key)publicKey;
        this.privateKey = keyPair.getPrivate();
    }

    public X509Key getPublicKey() {
        return this.publicKey;
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public X509Cert getSelfCert(X500Name x500Name, long l) throws InvalidKeyException, SignatureException, NoSuchAlgorithmException {
        try {
            X500Signer x500Signer = this.getSigner(x500Name);
            Date date = new Date();
            Date date2 = new Date();
            date2.setTime(date2.getTime() + l * 1000L);
            X509Cert x509Cert = new X509Cert(x500Name, this.publicKey, date, date2);
            x509Cert.encodeAndSign(new BigInt((int)(date.getTime() / 1000L)), x500Signer);
            return x509Cert;
        }
        catch (IOException iOException) {
            throw new CertException(8, " getSelfCert");
        }
    }

    public PKCS10 getCertRequest(X500Name x500Name) throws InvalidKeyException, SignatureException {
        PKCS10 pKCS10 = new PKCS10(this.publicKey);
        try {
            pKCS10.encodeAndSign(this.getSigner(x500Name));
        }
        catch (IOException iOException) {
            throw new SignatureException(String.valueOf(this.sigAlg) + " IOException");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new SignatureException(String.valueOf(this.sigAlg) + " unavailable?");
        }
        return pKCS10;
    }

    private X500Signer getSigner(X500Name x500Name) throws InvalidKeyException, NoSuchAlgorithmException {
        Signature signature = Signature.getInstance(this.sigAlg);
        signature.initSign(this.privateKey);
        return new X500Signer(signature, x500Name);
    }
}

