/*
 * Decompiled with CFR 0.152.
 */
package sunw.hotjava.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.MouseEvent;
import sunw.hotjava.ui.DragAndDropEvent;
import sunw.hotjava.ui.DragAndDropEventMulticaster;
import sunw.hotjava.ui.DragAndDropListener;
import sunw.hotjava.ui.DragStartInfo;

public class DraggableContainer
extends Window {
    public static final int DROP_EVENT = 91959;
    public static final int DRAG_START = 90256;
    public static final int DRAG_DONE = 50296;
    private Point disp;
    private int adjustmentFactor;
    private Component draggable;
    private Component dragArena;
    protected DragAndDropListener listeners;

    public DraggableContainer(Frame frame, Component component, DragStartInfo dragStartInfo) {
        super(frame);
        this.draggable = dragStartInfo.getDraggee();
        this.setLayout(null);
        this.add(this.draggable);
        this.dragArena = component;
        this.resize(5, 5);
        this.addNotify();
        Dimension dimension = this.draggable.getPreferredSize();
        this.resize(dimension.width, dimension.height);
        Component component2 = dragStartInfo.getSourceComponent();
        Point point = component2.getLocationOnScreen();
        Point point2 = dragStartInfo.getSourceLocation();
        point.x += point2.x;
        point.y += point2.y;
        int n = dragStartInfo.getAdjustmentFactor();
        this.move(point.x, point.y + n);
        this.disp = new Point(dragStartInfo.getDisplacement());
        this.show();
    }

    public synchronized void addDragAndDropListener(DragAndDropListener dragAndDropListener) {
        this.listeners = DragAndDropEventMulticaster.add(this.listeners, dragAndDropListener);
    }

    public synchronized void removeDragAndDropListener(DragAndDropListener dragAndDropListener) {
        this.listeners = DragAndDropEventMulticaster.remove(this.listeners, dragAndDropListener);
    }

    public void dispatchDragAndDropEvent(int n, Object object) {
        if (this.listeners != null) {
            DragAndDropEvent dragAndDropEvent = new DragAndDropEvent(this, n, object);
            this.listeners.dragAndDropPerformed(dragAndDropEvent);
        }
    }

    public void dispatchDragAndDropEvent(Object object, int n, Point point, Object object2) {
        if (this.listeners != null) {
            DragAndDropEvent dragAndDropEvent = new DragAndDropEvent(object, n, point, object2);
            this.listeners.dragAndDropPerformed(dragAndDropEvent);
        }
    }

    public void processDragAndDropEvent(Component component, MouseEvent mouseEvent) {
        this.adjustEventCoordinates(component, mouseEvent);
        this.processDragAndDropMouseEvent(mouseEvent);
    }

    public boolean processDragAndDropMouseEvent(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        switch (mouseEvent.getID()) {
            case 502: {
                Component component = this.findTarget(mouseEvent);
                if (component == null) break;
                Point point2 = new Point(point.x, point.y);
                Point point3 = this.translateCoordinateSpace(point2, this, component);
                this.dispatchDragAndDropEvent(component, 91959, point3, this.draggable);
                break;
            }
            case 506: {
                this.clampEventToArena(mouseEvent);
                Point point4 = this.getLocation();
                this.move(point4.x + point.x - this.disp.x, point4.y + point.y + this.adjustmentFactor - this.disp.y);
                Component component = this.findTarget(mouseEvent);
                if (component == null) break;
                Point point5 = new Point(point.x, point.y);
                Point point6 = this.translateCoordinateSpace(point5, this, component);
                this.dispatchDragAndDropEvent(component, 91962, point6, this.draggable);
                break;
            }
        }
        return true;
    }

    protected void clampEventToArena(MouseEvent mouseEvent) {
    }

    protected Component findTarget(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        Point point2 = this.translateCoordinateSpace(new Point(point.x, point.y), this, this.dragArena);
        return this.dragArena.locate(point2.x, point2.y);
    }

    protected void adjustEventCoordinates(Component component, MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        Point point2 = this.translateCoordinateSpace(new Point(point.x, point.y), component, this);
        mouseEvent.translatePoint(-point.x, -point.y);
        mouseEvent.translatePoint(point2.x, point2.y);
    }

    protected Point translateCoordinateSpace(Point point, Component component, Component component2) {
        Point point2 = this.localToGlobal(point, component);
        return this.globalToLocal(point2, component2);
    }

    protected Point localToGlobal(Point point, Component component) {
        Point point2 = component.getLocationOnScreen();
        point2.x += point.x;
        point2.y += point.y;
        return point2;
    }

    protected Point globalToLocal(Point point, Component component) {
        Point point2 = component.getLocationOnScreen();
        point2.x = point.x - point2.x;
        point2.y = point.y - point2.y;
        return point2;
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        this.draggable.paint(graphics);
    }

    public void move(int n, int n2) {
        super.move(n, n2);
        this.show();
    }

    public Component getDraggee() {
        return this.draggable;
    }
}

