/*
 * Decompiled with CFR 0.152.
 */
package sunw.html;

import java.util.BitSet;
import java.util.Vector;
import sunw.html.ContentModel;
import sunw.html.ContentModelState;
import sunw.html.DTD;
import sunw.html.DTDConstants;
import sunw.html.Element;
import sunw.html.Tag;

public final class TagStack
implements DTDConstants {
    Tag tag;
    Element elem;
    ContentModelState state;
    TagStack next;
    BitSet inclusions;
    BitSet exclusions;
    boolean net;
    boolean pre;

    TagStack(Tag tag, TagStack tagStack) {
        this.tag = tag;
        this.elem = tag.getElement();
        this.next = tagStack;
        Element element = tag.getElement();
        if (element.getContent() != null) {
            this.state = new ContentModelState(element.getContent());
        }
        if (tagStack != null) {
            this.inclusions = tagStack.inclusions;
            this.exclusions = tagStack.exclusions;
            this.pre = tagStack.pre;
        }
        if (tag.isPreformatted()) {
            this.pre = true;
        }
        if (element.inclusions != null) {
            if (this.inclusions != null) {
                this.inclusions = (BitSet)this.inclusions.clone();
                this.inclusions.or(element.inclusions);
            } else {
                this.inclusions = element.inclusions;
            }
        }
        if (element.exclusions != null) {
            if (this.exclusions != null) {
                this.exclusions = (BitSet)this.exclusions.clone();
                this.exclusions.or(element.exclusions);
                return;
            }
            this.exclusions = element.exclusions;
        }
    }

    public Tag getTag() {
        return this.tag;
    }

    public Element first() {
        if (this.state != null) {
            return this.state.first();
        }
        return null;
    }

    public ContentModel contentModel() {
        if (this.state == null) {
            return null;
        }
        return this.state.getModel();
    }

    boolean excluded(int n) {
        return this.exclusions != null && this.exclusions.get(this.elem.getIndex());
    }

    boolean included(Vector vector, DTD dTD) {
        int n = 0;
        while (n < this.inclusions.size()) {
            if (this.inclusions.get(n)) {
                vector.addElement(dTD.getElement(n));
                System.out.println("Element add thru' inclusions: " + dTD.getElement(n).getName());
            }
            ++n;
        }
        return !vector.isEmpty();
    }

    boolean advance(Element element) {
        if (this.exclusions != null && this.exclusions.get(element.getIndex())) {
            return false;
        }
        if (this.state != null) {
            ContentModelState contentModelState = this.state.advance(element);
            if (contentModelState != null) {
                if (element.getType() != 19) {
                    this.state = contentModelState;
                }
                return true;
            }
        } else if (this.elem.getType() == 19) {
            return true;
        }
        return this.inclusions != null && this.inclusions.get(element.getIndex());
    }

    boolean terminate() {
        return this.state == null || this.state.terminate();
    }

    public String toString() {
        if (this.next == null) {
            return "<" + this.tag.getElement().getName() + ">";
        }
        return String.valueOf(this.next) + " <" + this.tag.getElement().getName() + ">";
    }
}

