/*
 * Decompiled with CFR 0.152.
 */
package sunw.hotjava.tags;

import java.awt.FontMetrics;
import java.awt.Graphics;
import sunw.hotjava.doc.BlockTagItem;
import sunw.hotjava.doc.DocItem;
import sunw.hotjava.doc.DocLine;
import sunw.hotjava.doc.DocStyle;
import sunw.hotjava.doc.Document;
import sunw.hotjava.doc.FormatState;
import sunw.hotjava.doc.Formatter;
import sunw.hotjava.tags.LI;
import sunw.hotjava.tags.OL;

public class UL
extends BlockTagItem {
    int bulletType = 0;
    boolean topLevel = true;
    private Document doc;

    public void init(Document document) {
        this.doc = document;
    }

    public int paint(Formatter formatter, Graphics graphics, int n, int n2, DocLine docLine) {
        String string = this.getAttribute("type");
        if (string != null) {
            this.bulletType = LI.bulletNameToType(string);
            return super.paint(formatter, graphics, n, n2, docLine);
        }
        UL uL = this.findEnclosingUL(formatter);
        if (uL != null) {
            this.bulletType = LI.nextBulletType(uL.bulletType);
            this.topLevel = false;
        }
        return super.paint(formatter, graphics, n, n2, docLine);
    }

    private UL findEnclosingUL(Formatter formatter) {
        DocStyle docStyle = formatter.displayStyle;
        docStyle = docStyle.next;
        while (docStyle != null) {
            if (docStyle.tag instanceof UL) {
                return (UL)docStyle.tag;
            }
            docStyle = docStyle.next;
        }
        return null;
    }

    public boolean formatStartTag(Formatter formatter, FormatState formatState, FormatState formatState2) {
        if (formatState.style.tag instanceof UL || formatState.style.tag instanceof OL || formatState.style.tag instanceof LI) {
            int n = formatState.above;
            int n2 = formatState.ascent;
            if (!super.formatStartTag(formatter, formatState, formatState2)) {
                formatState.above = n;
                formatState.ascent = n2;
                return false;
            }
            return true;
        }
        return super.formatStartTag(formatter, formatState, formatState2);
    }

    public boolean formatEndTag(Formatter formatter, FormatState formatState, FormatState formatState2) {
        if (this.doc.length() >> 12 > this.getIndex() + this.getOffset() + 1) {
            DocItem docItem = this.doc.getItem(this.getIndex() + this.getOffset() + 1);
            if (docItem.getOffset() < 0) {
                docItem = this.doc.getItem(docItem.getIndex() + docItem.getOffset());
            }
            if (docItem.getOffset() != 0 && (docItem instanceof LI || docItem instanceof UL || docItem instanceof OL)) {
                int n = formatState.below;
                int n2 = formatState.descent;
                if (!super.formatEndTag(formatter, formatState, formatState2)) {
                    formatState.below = n;
                    formatState.descent = n2;
                    return false;
                }
                return true;
            }
        }
        return super.formatEndTag(formatter, formatState, formatState2);
    }

    public void modifyStyle(DocStyle docStyle) {
        super.modifyStyle(docStyle);
        FontMetrics fontMetrics = docStyle.getFontMetrics();
        docStyle.ascent = fontMetrics.getAscent();
        docStyle.descent = fontMetrics.getDescent();
    }
}

