/*
 * Decompiled with CFR 0.152.
 */
package sunw.hotjava.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import sunw.hotjava.ui.BarCanvas;
import sunw.hotjava.ui.ValueUpdateable;

class ValueBar
extends BarCanvas
implements ValueUpdateable {
    private long maxValue = 1L;
    private long minValue;
    private long value;
    private Color fullColor = Color.blue;
    private Color emptyColor = Color.white;

    ValueBar(int n, int n2, int n3) {
        super(n, n2);
        this.orientation = n3;
    }

    public void updateValue(long l) {
        this.value = l;
        Graphics graphics = this.getGraphics();
        try {
            this.paint(graphics);
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            graphics.dispose();
            throw throwable;
        }
        Object var5_3 = null;
        graphics.dispose();
    }

    void setMaxValue(long l) {
        this.maxValue = l;
        this.repaint(10L);
    }

    void setMinValue(long l) {
        this.minValue = l;
        this.repaint(10L);
    }

    Color getFullColor() {
        return this.fullColor;
    }

    void setFullColor(Color color) {
        this.fullColor = color;
        this.repaint(10L);
    }

    Color getEmptyColor() {
        return this.emptyColor;
    }

    void setEmptyColor(Color color) {
        this.emptyColor = color;
        this.repaint(10L);
    }

    public void paint(Graphics graphics) {
        if (this.maxValue <= this.minValue || graphics == null) {
            return;
        }
        this.drawWell(graphics);
        double d = (double)(this.value - this.minValue) / (double)(this.maxValue - this.minValue);
        Dimension dimension = this.getPreferredSize();
        int n = dimension.height - 6;
        int n2 = dimension.width - 6;
        if (this.orientation == 1) {
            int n3 = n - (int)(d * (double)n);
            if (n3 - 1 > 0) {
                graphics.setColor(this.emptyColor);
                graphics.fillRect(3, 3, n2, n3 - 1);
            }
            if (n3 < n) {
                graphics.setColor(this.fullColor);
                graphics.fillRect(3, 3 + n3, n2, n - n3);
                return;
            }
        } else {
            int n4 = (int)(d * (double)n2);
            graphics.setColor(this.fullColor);
            graphics.fillRect(3, 3, n4, n);
            if (n4 + 1 < n2) {
                graphics.setColor(this.emptyColor);
                graphics.fillRect(3 + n4 + 1, 3, n2 - n4 - 1, n);
            }
        }
    }
}

