/*
 * Decompiled with CFR 0.152.
 */
package sunw.hotjava.security;

import java.awt.CheckboxGroup;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.net.URL;
import sunw.hotjava.misc.HJBProperties;
import sunw.hotjava.security.CommonSecurity;
import sunw.hotjava.security.SDCheckbox;
import sunw.hotjava.ui.BagDialog;
import sunw.hotjava.ui.EnterKeyListener;
import sunw.hotjava.ui.KeyPressInterest;
import sunw.hotjava.ui.MultiLineLabel;
import sunw.hotjava.ui.UIHJButton;
import sunw.hotjava.ui.UserImageLabel;

final class SecurityDialog
extends BagDialog
implements KeyPressInterest,
ActionListener {
    static String propName = "hotjava.security";
    private Label label;
    private Label objLabel;
    private MultiLineLabel despLabel;
    private Label appLabel;
    private Label siteLabel;
    private Label certLabel;
    private CheckboxGroup group;
    private Class clazz;
    private URL base;
    private SDCheckbox first;
    private SDCheckbox all;
    private static Object lock = new Object();
    private EnterKeyListener keylistener;
    static final int DENIED = 0;
    static final int ALLOWED = 1;
    static final int ALLOW_ALL = 2;
    private HJBProperties properties = HJBProperties.getHJBProperties("hjbrowser");

    public SecurityDialog(Frame frame) {
        super(propName, frame, HJBProperties.getHJBProperties("hjbrowser"));
        this.keylistener = new EnterKeyListener(this);
        GridBagLayout gridBagLayout = (GridBagLayout)this.getLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        UserImageLabel userImageLabel = new UserImageLabel("securitydialog.icon.quest", this.properties);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(10, 20, 0, 40);
        this.addComponent(userImageLabel, gridBagLayout, gridBagConstraints);
        gridBagConstraints.insets = new Insets(4, 20, 0, 0);
        this.label = new Label("permission");
        this.addComponent(this.label, gridBagLayout, gridBagConstraints);
        gridBagConstraints.insets = new Insets(8, 32, 8, 0);
        this.objLabel = new Label("target");
        this.addComponent(this.objLabel, gridBagLayout, gridBagConstraints);
        gridBagConstraints.insets = new Insets(5, 20, 5, 0);
        this.despLabel = new MultiLineLabel("", 4, 0, 0);
        this.addComponent(this.despLabel, gridBagLayout, gridBagConstraints);
        gridBagConstraints.insets = new Insets(0, 20, 0, 0);
        this.appLabel = new Label("applet");
        this.addComponent(this.appLabel, gridBagLayout, gridBagConstraints);
        gridBagConstraints.insets = new Insets(0, 32, 0, 0);
        this.siteLabel = new Label("site");
        this.addComponent(this.siteLabel, gridBagLayout, gridBagConstraints);
        this.certLabel = new Label("cert");
        this.addComponent(this.certLabel, gridBagLayout, gridBagConstraints);
        gridBagConstraints.insets = new Insets(8, 32, 0, 0);
        this.group = new CheckboxGroup();
        this.first = new SDCheckbox("allow", true, this.group, 1, this.keylistener);
        this.addComponent(this.first, gridBagLayout, gridBagConstraints);
        gridBagConstraints.insets = new Insets(0, 32, 0, 0);
        this.all = new SDCheckbox("allow.all", false, this.group, 2, this.keylistener);
        this.addComponent(this.all, gridBagLayout, gridBagConstraints);
        SDCheckbox sDCheckbox = new SDCheckbox("deny", false, this.group, 0, this.keylistener);
        this.addComponent(sDCheckbox, gridBagLayout, gridBagConstraints);
        gridBagConstraints.insets = new Insets(0, 5, 5, 10);
        gridBagConstraints.anchor = 13;
        this.ok = new UIHJButton(String.valueOf(propName) + ".ok", true, this.hjbProperties);
        this.ok.addActionListener(this);
        this.addComponent(this.ok, gridBagLayout, gridBagConstraints);
    }

    private int getAuthorization(String string, String string2) {
        int n = this.askAuthorization(string, string2);
        return n;
    }

    private int askAuthorization(String string, String string2) {
        Object object = lock;
        synchronized (object) {
            this.result = 0;
            this.group.setSelectedCheckbox(this.first);
            String string3 = this.getProp(string, "Applet wants to " + string);
            this.label.setText(string3);
            this.objLabel.setText(String.valueOf(string2));
            string3 = this.getProp(String.valueOf(string) + ".desp");
            if (string3 != null) {
                this.despLabel.setLabel(string3);
                this.despLabel.setFont(new Font("Dialog", 0, 12));
            } else {
                this.remove(this.despLabel);
            }
            CommonSecurity commonSecurity = (CommonSecurity)((Object)System.getSecurityManager());
            string3 = commonSecurity.getClassName();
            string3 = string3 == null ? this.getProp("applet.unknown") : String.valueOf(this.getProp("applet")) + " " + string3;
            this.appLabel.setText(string3);
            string3 = commonSecurity.getSiteName();
            string3 = string3 == null ? this.getProp("site.unknown") : String.valueOf(this.getProp("site")) + " " + string3;
            this.siteLabel.setText(string3);
            string3 = commonSecurity.getSignerName();
            string3 = string3 == null ? this.getProp("signer.unknown") : String.valueOf(this.getProp("signer")) + " " + string3;
            this.certLabel.setText(string3);
            string3 = this.getProp(String.valueOf(string) + ".all", "Allow all similar actions");
            this.all.setLabel(string3);
        }
        return this.handleDialog();
    }

    public int getReadAuthorization(String string) {
        return this.getAuthorization("read", string);
    }

    public int getWriteAuthorization(String string) {
        return this.getAuthorization("write", string);
    }

    public int getDeleteAuthorization(String string) {
        return this.getAuthorization("delete", string);
    }

    public int getExecAuthorization(String string) {
        return this.getAuthorization("exec", string);
    }

    public int getPropAuthorization(String string) {
        return this.getAuthorization("prop", string);
    }

    public int getConnectAuthorization(String string) {
        return this.getAuthorization("connect", string);
    }

    public int getAcceptAuthorization(String string) {
        return this.getAuthorization("accept", string);
    }

    public int getListenAuthorization(String string) {
        return this.getAuthorization("listen", string);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.ok) {
            SDCheckbox sDCheckbox = (SDCheckbox)this.group.getSelectedCheckbox();
            this.result = sDCheckbox.value;
            ((Component)this).setVisible(false);
        }
    }

    public void processEnterEvent(KeyEvent keyEvent) {
        this.actionPerformed(new ActionEvent(this.ok, 0, ""));
    }

    public int handleDialog() {
        this.pack();
        this.invalidate();
        this.validate();
        this.centerOnScreen();
        ((Component)this).setVisible(true);
        this.dispose();
        return this.result;
    }
}

