/*
 * Decompiled with CFR 0.152.
 */
package sunw.hotjava.ui;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Point;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import sunw.hotjava.misc.HJBProperties;
import sunw.hotjava.ui.Console;
import sunw.hotjava.ui.ConsoleOutput;
import sunw.hotjava.ui.RaisedPanel;

class ConsoleFrame
extends Frame {
    ConsoleOutput console;
    boolean iconic = false;
    HJBProperties properties = HJBProperties.getHJBProperties("hjbrowser");

    ConsoleFrame() {
        super("javaconsole");
        Image image;
        this.addWindowListener(new FrameCloseAdapter());
        String string = this.properties.getProperty("javaconsole.title");
        if (string != null) {
            this.setTitle(string);
        }
        if ((image = this.properties.getImage("hotjava.icon")) != null) {
            this.setLayout(new BorderLayout());
        }
        this.add("South", this.newButtonPanel());
        try {
            this.add("Center", this.newConsoleTextArea());
            this.pack();
            ((Component)this).setVisible(true);
            Console.showStatus("enabled.msg");
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            Console.showStatus("redirectFail.msg");
        }
        ((Component)this).setBackground(this.properties.getColor("hotjava.background", null));
    }

    TextArea newConsoleTextArea() throws Throwable {
        int n = this.properties.getInteger("javaconsole.textRows", 16);
        int n2 = this.properties.getInteger("javaconsole.textColumns", 52);
        TextArea textArea = new TextArea("", n, n2, 1);
        Font font = Font.getFont("javaconsole.textFont");
        if (font != null) {
            textArea.setFont(font);
        }
        textArea.setEditable(false);
        this.console = new ConsoleOutput(textArea);
        return textArea;
    }

    Panel newButtonPanel() {
        RaisedPanel raisedPanel = new RaisedPanel();
        raisedPanel.setLayout(new FlowLayout(1, 18, 4));
        Button button = new Button();
        button.setLabel(this.properties.getProperty("javaconsole.clear.text"));
        button.addActionListener(new ClearConsole());
        Button button2 = new Button();
        button2.setLabel(this.properties.getProperty("javaconsole.close.text"));
        button2.addActionListener(new CloseConsole());
        raisedPanel.add(button);
        raisedPanel.add(button2);
        return raisedPanel;
    }

    public void toFront() {
        if (this.iconic) {
            Point point = this.getLocation();
            ((Component)this).setVisible(false);
            ((Component)this).setLocation(point);
            ((Component)this).setVisible(true);
            return;
        }
        super.toFront();
    }

    public void dispose() {
        this.console.dispose();
        super.dispose();
    }

    public void clear() {
        this.console.clear();
    }

    class FrameCloseAdapter
    extends WindowAdapter {
        public void windowIconified(WindowEvent windowEvent) {
            ConsoleFrame.this.iconic = true;
        }

        public void windowDeiconified(WindowEvent windowEvent) {
            ConsoleFrame.this.iconic = false;
        }

        public void windowClosing(WindowEvent windowEvent) {
            Console.close();
        }

        FrameCloseAdapter() {
            ConsoleFrame.this = ConsoleFrame.this;
        }
    }

    class ClearConsole
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            Console.clear();
        }

        ClearConsole() {
            ConsoleFrame.this = ConsoleFrame.this;
        }
    }

    class CloseConsole
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            Console.close();
        }

        CloseConsole() {
            ConsoleFrame.this = ConsoleFrame.this;
        }
    }
}

