/*
 * Decompiled with CFR 0.152.
 */
package sunw.hotjava.ui;

import java.awt.Checkbox;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import sunw.hotjava.misc.HJBProperties;
import sunw.hotjava.ui.BagDialog;
import sunw.hotjava.ui.EnterKeyListener;
import sunw.hotjava.ui.KeyPressInterest;
import sunw.hotjava.ui.MultiLineLabel;
import sunw.hotjava.ui.UIHJButton;
import sunw.hotjava.ui.UIHJButtonGroup;
import sunw.hotjava.ui.UserImageLabel;

public class CheckboxDialog
extends BagDialog
implements ActionListener,
KeyPressInterest {
    private Checkbox checkbox;
    private UIHJButton[] buttons;
    private boolean hasCheckbox;
    private boolean cboxanswer;
    private int answer;
    private String prompt;
    private MultiLineLabel mlabel;
    private EnterKeyListener enterKeyListener;

    public CheckboxDialog(Frame frame, String string, HJBProperties hJBProperties) {
        this(frame, string, hJBProperties, false);
    }

    public CheckboxDialog(Frame frame, String string, HJBProperties hJBProperties, boolean bl) {
        super(string, frame, hJBProperties);
        this.hasCheckbox = bl;
        this.enterKeyListener = new EnterKeyListener(this);
        GridBagLayout gridBagLayout = (GridBagLayout)this.getLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = -1;
        UserImageLabel userImageLabel = new UserImageLabel("securitydialog.icon.quest", hJBProperties);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(10, 20, 0, 40);
        this.addComponent(userImageLabel, gridBagLayout, gridBagConstraints);
        gridBagConstraints.insets = new Insets(10, 10, 5, 10);
        gridBagConstraints.anchor = 10;
        if (this.prompt == null) {
            this.prompt = hJBProperties.getProperty("confirm." + this.getName() + ".prompt", "Which do you want to do?");
        }
        this.mlabel = new MultiLineLabel(this.prompt);
        this.addComponent(this.mlabel, gridBagLayout, gridBagConstraints);
        if (this.hasCheckbox) {
            this.checkbox = new Checkbox(hJBProperties.getProperty("confirm." + this.getName() + ".checkbox", "Checkbox label"));
            this.addComponent(this.checkbox, gridBagLayout, gridBagConstraints);
            this.checkbox.addKeyListener(this.enterKeyListener);
        }
        Panel panel = new Panel();
        ((FlowLayout)panel.getLayout()).setAlignment(2);
        UIHJButtonGroup uIHJButtonGroup = new UIHJButtonGroup(hJBProperties);
        this.buttons = new UIHJButton[2];
        this.buttons[0] = new UIHJButton(String.valueOf(this.getName()) + ".0", hJBProperties);
        this.buttons[1] = new UIHJButton(String.valueOf(this.getName()) + ".1", hJBProperties);
        uIHJButtonGroup.addButtonToGroup(this.buttons[0]);
        uIHJButtonGroup.addButtonToGroup(this.buttons[1]);
        panel.add(this.buttons[0]);
        panel.add(this.buttons[1]);
        this.buttons[0].addActionListener(this);
        this.buttons[1].addActionListener(this);
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.addComponent(panel, gridBagLayout, gridBagConstraints);
        String string2 = hJBProperties.getProperty("confirm." + this.getName() + ".title", "Confirm Dialog");
        this.setTitle(string2);
        this.pack();
        this.centerOnScreen();
    }

    public void setPrompt(String string) {
        this.prompt = string;
        this.mlabel.setLabel(this.prompt);
        ((Component)this).setSize(this.getPreferredSize());
    }

    public void processEnterEvent(KeyEvent keyEvent) {
        int n = 0;
        while (n < this.buttons.length) {
            this.buttons[n].removeActionListener(this);
            if (this.buttons[n].isDefault()) {
                this.actionPerformed(new ActionEvent(this.buttons[n], 0, ""));
                return;
            }
            ++n;
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        boolean bl = false;
        int n = 0;
        while (n < this.buttons.length) {
            this.buttons[n].removeActionListener(this);
            if ((UIHJButton)actionEvent.getSource() == this.buttons[n]) {
                this.answer = n;
                this.cboxanswer = this.checkbox.getState();
                ((Component)this).hide();
                bl = true;
            }
            ++n;
        }
        if (bl) {
            return;
        }
        ((Component)this).hide();
        super.processEvent(actionEvent);
    }

    public int getAnswer() {
        return this.answer;
    }

    public boolean getCheckboxAnswer() {
        return this.cboxanswer;
    }
}

