/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.EventDispatchThread;
import java.awt.EventQueueItem;
import java.awt.EventQueueListener;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.PaintEvent;
import java.util.EventListener;

public class EventQueue {
    private static int threadInitNumber;
    private EventQueueItem queue = null;
    EventQueueListener eventQueueListener;

    private static synchronized int nextThreadNum() {
        return threadInitNumber++;
    }

    public EventQueue() {
        String string = "AWT-EventQueue-" + EventQueue.nextThreadNum();
        new EventDispatchThread(string, this).start();
    }

    public synchronized void postEvent(AWTEvent aWTEvent) {
        EventQueueItem eventQueueItem = new EventQueueItem(aWTEvent);
        if (this.queue == null) {
            this.queue = eventQueueItem;
            this.notifyAll();
        } else {
            EventQueueItem eventQueueItem2 = this.queue;
            while (true) {
                if (eventQueueItem2.id == eventQueueItem.id) {
                    switch (eventQueueItem2.id) {
                        case 503: 
                        case 506: {
                            MouseEvent mouseEvent = (MouseEvent)eventQueueItem2.event;
                            if (mouseEvent.getSource() != ((MouseEvent)aWTEvent).getSource() || mouseEvent.getModifiers() != ((MouseEvent)aWTEvent).getModifiers()) break;
                            eventQueueItem2.event = eventQueueItem.event;
                            return;
                        }
                        case 800: 
                        case 801: {
                            Rectangle rectangle;
                            PaintEvent paintEvent = (PaintEvent)eventQueueItem2.event;
                            if (paintEvent.getSource() != aWTEvent.getSource()) break;
                            Rectangle rectangle2 = paintEvent.getUpdateRect();
                            if (!rectangle2.equals(rectangle = ((PaintEvent)aWTEvent).getUpdateRect())) {
                                paintEvent.setUpdateRect(rectangle2.union(rectangle));
                            }
                            return;
                        }
                    }
                }
                if (eventQueueItem2.next == null) break;
                eventQueueItem2 = eventQueueItem2.next;
            }
            eventQueueItem2.next = eventQueueItem;
        }
        this.notifyEventQueueListeners(aWTEvent);
    }

    public synchronized AWTEvent getNextEvent() throws InterruptedException {
        while (this.queue == null) {
            this.wait();
        }
        EventQueueItem eventQueueItem = this.queue;
        this.queue = this.queue.next;
        return eventQueueItem.event;
    }

    public synchronized AWTEvent peekEvent() {
        if (this.queue != null) {
            return this.queue.event;
        }
        return null;
    }

    public synchronized AWTEvent peekEvent(int n) {
        EventQueueItem eventQueueItem = this.queue;
        while (eventQueueItem != null) {
            if (eventQueueItem.id == n) {
                return eventQueueItem.event;
            }
            eventQueueItem = eventQueueItem.next;
        }
        return null;
    }

    synchronized void addEventQueueListener(EventQueueListener eventQueueListener) {
        this.eventQueueListener = EventQueueMulticaster.add(this.eventQueueListener, eventQueueListener);
    }

    synchronized void removeEventQueueListener(EventQueueListener eventQueueListener) {
        this.eventQueueListener = EventQueueMulticaster.remove(this.eventQueueListener, eventQueueListener);
    }

    synchronized void changeKeyEventFocus(Object object) {
        EventQueueItem eventQueueItem = this.queue;
        while (eventQueueItem != null) {
            if (eventQueueItem.event instanceof KeyEvent) {
                eventQueueItem.event.setSource(object);
            }
            eventQueueItem = eventQueueItem.next;
        }
    }

    synchronized void removeSourceEvents(Object object) {
        EventQueueItem eventQueueItem = this.queue;
        EventQueueItem eventQueueItem2 = null;
        while (eventQueueItem != null) {
            if (eventQueueItem.event.getSource().equals(object)) {
                if (eventQueueItem2 == null) {
                    this.queue = eventQueueItem.next;
                } else {
                    eventQueueItem2.next = eventQueueItem.next;
                }
            }
            eventQueueItem2 = eventQueueItem;
            eventQueueItem = eventQueueItem.next;
        }
    }

    synchronized void removeEvents(Class clazz, int n) {
        EventQueueItem eventQueueItem = this.queue;
        EventQueueItem eventQueueItem2 = null;
        while (eventQueueItem != null) {
            if (clazz.isInstance(eventQueueItem.event) && eventQueueItem.event.getID() == n) {
                if (eventQueueItem2 == null) {
                    this.queue = eventQueueItem.next;
                } else {
                    eventQueueItem2.next = eventQueueItem.next;
                }
            }
            eventQueueItem2 = eventQueueItem;
            eventQueueItem = eventQueueItem.next;
        }
    }

    private void notifyEventQueueListeners(AWTEvent aWTEvent) {
        if (this.eventQueueListener != null) {
            this.eventQueueListener.eventPosted(aWTEvent);
        }
    }

    private static class EventQueueMulticaster
    extends AWTEventMulticaster
    implements EventQueueListener {
        EventQueueMulticaster(EventListener eventListener, EventListener eventListener2) {
            super(eventListener, eventListener2);
        }

        static EventQueueListener add(EventQueueListener eventQueueListener, EventQueueListener eventQueueListener2) {
            return (EventQueueListener)EventQueueMulticaster.addInternal(eventQueueListener, eventQueueListener2);
        }

        static EventQueueListener remove(EventQueueListener eventQueueListener, EventQueueListener eventQueueListener2) {
            return (EventQueueListener)AWTEventMulticaster.removeInternal(eventQueueListener, eventQueueListener2);
        }

        protected static EventListener addInternal(EventListener eventListener, EventListener eventListener2) {
            if (eventListener == null) {
                return eventListener2;
            }
            if (eventListener2 == null) {
                return eventListener;
            }
            return new EventQueueMulticaster(eventListener, eventListener2);
        }

        public void eventPosted(AWTEvent aWTEvent) {
            ((EventQueueListener)this.a).eventPosted(aWTEvent);
            ((EventQueueListener)this.b).eventPosted(aWTEvent);
        }
    }
}

