/*
 * Decompiled with CFR 0.152.
 */
package sunw.hotjava.ui;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Panel;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.Vector;
import sunw.hotjava.ui.Folder;
import sunw.hotjava.ui.HotCanvas;
import sunw.hotjava.ui.HotList;
import sunw.hotjava.ui.HotListEntry;
import sunw.hotjava.ui.HotListFrame;
import sunw.hotjava.ui.ListContainer;
import sunw.hotjava.ui.ListItem;
import sunw.hotjava.ui.PageFolder;

public class BrowserListCanvas
extends HotCanvas {
    public HotCanvas canvas;
    ListItem oldSelection;

    public BrowserListCanvas(HotList hotList, Panel panel, String string, int n, int n2, HotListFrame hotListFrame) {
        super(hotList, panel, string, n, n2, hotListFrame);
    }

    public void initialize(PageFolder pageFolder, HotCanvas hotCanvas) {
        this.canvas = hotCanvas;
        this.initialize(pageFolder);
    }

    public boolean mousePressedOnCanvas(MouseEvent mouseEvent) {
        this.oldSelection = this.getSelectedItem();
        super.mousePressedOnCanvas(mouseEvent);
        if (mouseEvent.getClickCount() == 2) {
            this.hotFolder.recalculatePositions(true);
            this.adjustSize();
        }
        if (this.getSelectedItem() != null) {
            this.frm.setListName(this.getSelectedItem().getTitle());
        }
        this.redispatchEvent(mouseEvent);
        return false;
    }

    public void processHiliteEvent(Component component, Point point) {
        Graphics graphics;
        block3: {
            ListItem listItem = this.mainFolder.locateItemOnDrag(point.x, point.y);
            graphics = this.getGraphics();
            try {
                if (listItem != null) {
                    this.eraseHiliteBox(graphics);
                    this.paintHiliteBox(graphics, listItem);
                    break block3;
                }
                this.eraseHiliteBox(graphics);
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                graphics.dispose();
                throw throwable;
            }
        }
        Object var6_5 = null;
        graphics.dispose();
    }

    protected boolean isDragSource() {
        return false;
    }

    public ListItem previousSelection() {
        return this.oldSelection;
    }

    public Folder getFolder(String string) {
        Vector vector = this.hotFolder.getContents();
        int n = 0;
        while (n < vector.size()) {
            Folder folder = (Folder)vector.elementAt(n);
            String string2 = folder.getTitle();
            if (string2.equals(string)) {
                return folder;
            }
            ++n;
        }
        return null;
    }

    public void paint(Graphics graphics) {
        ListContainer listContainer = this.getMainContainer();
        if (listContainer == null) {
            return;
        }
        listContainer.drawChildren(graphics);
    }

    public void addEntry(HotListEntry hotListEntry, boolean bl) {
        try {
            Folder folder = null;
            folder = (Folder)this.getMainContainer();
            if (hotListEntry instanceof PageFolder) {
                folder.addFolder(folder, (PageFolder)hotListEntry);
            }
            this.hotFolder.recalculatePositions(bl);
            this.adjustSize();
            this.repaint();
            return;
        }
        catch (Exception exception) {
            System.out.println("addEntry: " + exception);
            return;
        }
    }

    public void delItem(HotListEntry hotListEntry, boolean bl) {
        ListItem listItem = this.hotFolder.findEntrySibling(hotListEntry);
        if (listItem == null) {
            return;
        }
        listItem.removeMyself();
        this.setCurrentItem(null);
        this.setSelectedItem(null);
        this.hotFolder.recalculatePositions(bl);
        this.adjustSize();
        this.repaint();
    }
}

