/*
 * Decompiled with CFR 0.152.
 */
package sunw.hotjava.applets;

import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import sunw.hotjava.misc.Compare;
import sunw.hotjava.misc.Sort;

class TypeSubtypeMap
implements Compare {
    String[][] map = new String[7][];
    static final int APPLICATION = 0;
    static final int AUDIO = 1;
    static final int IMAGE = 2;
    static final int MESSAGE = 3;
    static final int MULTIPART = 4;
    static final int TEXT = 5;
    static final int VIDEO = 6;
    static final String[] typeNames = new String[]{"application", "audio", "image", "message", "multipart", "text", "video"};
    static /* synthetic */ Class class$sunw$hotjava$misc$HJBProperties;

    public TypeSubtypeMap() {
        try {
            InputStream inputStream = (class$sunw$hotjava$misc$HJBProperties != null ? class$sunw$hotjava$misc$HJBProperties : (class$sunw$hotjava$misc$HJBProperties = TypeSubtypeMap.class$("sunw.hotjava.misc.HJBProperties"))).getResourceAsStream("/lib/type-subtypes-map.properties");
            if (inputStream == null) {
                throw new IOException("Unable to find a property file : type-subtypes-map.properties");
            }
            this.read(inputStream);
            inputStream.close();
            return;
        }
        catch (IOException iOException) {
            System.err.println("TypeSubtypeMap constructor failed: " + iOException);
            return;
        }
    }

    private void read(InputStream inputStream) {
        Properties properties = new Properties();
        try {
            properties.load(inputStream);
            int n = 0;
            while (n < typeNames.length) {
                String string = (String)((Hashtable)properties).get(typeNames[n]);
                this.parse(n, string);
                ++n;
            }
            return;
        }
        catch (IOException iOException) {
            System.err.println("TypeSubtypeMap.read failed: " + iOException);
            return;
        }
    }

    private void parse(int n, String string) {
        if (string == null) {
            System.err.println("TypeSubtypeMap.parse got empty list");
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
        int n2 = stringTokenizer.countTokens();
        Object[] objectArray = new String[n2];
        int n3 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            objectArray[n3] = stringTokenizer.nextToken();
            ++n3;
        }
        Sort.quicksort(objectArray, this);
        this.map[n] = objectArray;
    }

    public String[] getSubtypes(int n) {
        try {
            return this.map[n];
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return null;
        }
    }

    public boolean typeHasSubtype(int n, String string) {
        String[] stringArray = this.map[n];
        if (string == null || stringArray == null) {
            return false;
        }
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (string.equals(stringArray[n2])) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void addSubtype(int n, String string) {
        try {
            if (string == null) {
                return;
            }
            String[] stringArray = this.map[n];
            if (stringArray == null) {
                stringArray = new String[]{string};
                this.map[n] = stringArray;
                return;
            }
            if (this.typeHasSubtype(n, string)) {
                return;
            }
            Object[] objectArray = new String[stringArray.length + 1];
            System.arraycopy(stringArray, 0, objectArray, 0, stringArray.length);
            objectArray[stringArray.length] = string;
            Sort.quicksort(objectArray, this);
            this.map[n] = objectArray;
            return;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            indexOutOfBoundsException.printStackTrace();
            return;
        }
    }

    public int doCompare(Object object, Object object2) {
        String string = (String)object;
        String string2 = (String)object2;
        return string.compareTo(string2);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

