/*
 * Decompiled with CFR 0.152.
 */
package sun.awt;

import java.awt.AWTException;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Image;
import java.awt.Toolkit;
import java.net.URL;
import java.util.Hashtable;
import sun.awt.im.InputMethod;
import sun.awt.image.ByteArrayImageSource;
import sun.awt.image.FileImageSource;
import sun.awt.image.URLImageSource;

public abstract class SunToolkit
extends Toolkit {
    protected static EventQueue theEventQueue;
    protected static final Hashtable peerMap;
    static Hashtable imgHash;

    public SunToolkit() {
        String string = Toolkit.getProperty("AWT.EventQueueClass", "java.awt.EventQueue");
        try {
            theEventQueue = (EventQueue)Class.forName(string).newInstance();
            return;
        }
        catch (Exception exception) {
            System.err.println("Failed loading " + string + ": " + exception);
            theEventQueue = new EventQueue();
            return;
        }
    }

    protected static Object targetToPeer(Object object) {
        if (object != null) {
            return peerMap.get(object);
        }
        return null;
    }

    protected static void targetDisposedPeer(Object object, Object object2) {
        if (object != null && object2 != null) {
            Hashtable hashtable = peerMap;
            synchronized (hashtable) {
                if (peerMap.get(object) == object2) {
                    peerMap.remove(object);
                }
                return;
            }
        }
    }

    public Dimension getScreenSize() {
        return new Dimension(this.getScreenWidth(), this.getScreenHeight());
    }

    protected abstract int getScreenWidth();

    protected abstract int getScreenHeight();

    public String[] getFontList() {
        String[] stringArray = new String[]{"Dialog", "SansSerif", "Serif", "Monospaced", "DialogInput"};
        return stringArray;
    }

    static synchronized Image getImageFromHash(Toolkit toolkit, URL uRL) {
        Image image;
        block3: {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                securityManager.checkConnect(uRL.getHost(), uRL.getPort());
            }
            if ((image = (Image)imgHash.get(uRL)) != null) break block3;
            try {
                image = toolkit.createImage(new URLImageSource(uRL));
                imgHash.put(uRL, image);
            }
            catch (Exception exception) {}
        }
        return image;
    }

    static synchronized Image getImageFromHash(Toolkit toolkit, String string) {
        Image image;
        block3: {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                securityManager.checkRead(string);
            }
            if ((image = (Image)imgHash.get(string)) != null) break block3;
            try {
                image = toolkit.createImage(new FileImageSource(string));
                imgHash.put(string, image);
            }
            catch (Exception exception) {}
        }
        return image;
    }

    public Image getImage(String string) {
        return SunToolkit.getImageFromHash((Toolkit)this, string);
    }

    public Image getImage(URL uRL) {
        return SunToolkit.getImageFromHash((Toolkit)this, uRL);
    }

    public Image createImage(byte[] byArray, int n, int n2) {
        return this.createImage(new ByteArrayImageSource(byArray, n, n2));
    }

    protected EventQueue getSystemEventQueueImpl() {
        return theEventQueue;
    }

    public static Container getNativeContainer(Component component) {
        return Toolkit.getNativeContainer(component);
    }

    public abstract InputMethod getInputMethodAdapter() throws AWTException;

    public boolean enableInputMethodsForTextComponent() {
        return false;
    }

    static {
        peerMap = new Hashtable();
        imgHash = new Hashtable();
    }
}

