/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www;

import java.io.File;
import java.io.InputStream;
import java.net.URLConnection;
import java.util.StringTokenizer;
import sun.net.www.ApplicationLaunchException;
import sun.net.www.MimeLauncher;
import sun.net.www.MimeTable;

public class MimeEntry
implements Cloneable {
    public static final String defaultImagePath = "doc:/lib/images/ftp";
    private String typeName;
    private String tempFileNameTemplate;
    private int action;
    private String command;
    private String description;
    private String imageFileName;
    private String[] fileExtensions;
    boolean starred;
    public static final int UNKNOWN = 0;
    public static final int LOAD_INTO_BROWSER = 1;
    public static final int SAVE_TO_FILE = 2;
    public static final int LAUNCH_APPLICATION = 3;
    static final String[] actionKeywords = new String[]{"unknown", "browser", "save", "application"};

    public MimeEntry(String string) {
        this(string, 0, null, null, null);
    }

    MimeEntry(String string, String string2, String string3) {
        this.typeName = string.toLowerCase();
        this.action = 0;
        this.command = null;
        this.imageFileName = string2;
        this.setExtensions(string3);
        this.starred = this.isStarred(this.typeName);
    }

    MimeEntry(String string, int n, String string2, String string3) {
        this.typeName = string.toLowerCase();
        this.action = n;
        this.command = string2;
        this.imageFileName = null;
        this.fileExtensions = null;
        this.tempFileNameTemplate = string3;
    }

    MimeEntry(String string, int n, String string2, String string3, String[] stringArray) {
        this.typeName = string.toLowerCase();
        this.action = n;
        this.command = string2;
        this.imageFileName = string3;
        this.fileExtensions = stringArray;
        this.starred = this.isStarred(string);
    }

    public synchronized String getType() {
        return this.typeName;
    }

    public synchronized void setType(String string) {
        this.typeName = string.toLowerCase();
    }

    public synchronized int getAction() {
        return this.action;
    }

    public synchronized void setAction(int n, String string) {
        this.action = n;
        this.command = string;
    }

    public synchronized void setAction(int n) {
        this.action = n;
    }

    public synchronized String getLaunchString() {
        return this.command;
    }

    public synchronized void setCommand(String string) {
        this.command = string;
    }

    public synchronized String getDescription() {
        if (this.description != null) {
            return this.description;
        }
        return this.typeName;
    }

    public synchronized void setDescription(String string) {
        this.description = string;
    }

    public String getImageFileName() {
        return this.imageFileName;
    }

    public synchronized void setImageFileName(String string) {
        File file = new File(string);
        this.imageFileName = file.getParent() == null ? defaultImagePath + File.separator + string : string;
        if (string.lastIndexOf(46) < 0) {
            this.imageFileName = String.valueOf(this.imageFileName) + ".gif";
        }
    }

    public String getTempFileTemplate() {
        return this.tempFileNameTemplate;
    }

    public synchronized String[] getExtensions() {
        return this.fileExtensions;
    }

    public synchronized String getExtensionsAsList() {
        String string = "";
        if (this.fileExtensions != null) {
            int n = 0;
            while (n < this.fileExtensions.length) {
                string = String.valueOf(string) + this.fileExtensions[n];
                if (n < this.fileExtensions.length - 1) {
                    string = String.valueOf(string) + ",";
                }
                ++n;
            }
        }
        return string;
    }

    public synchronized void setExtensions(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        int n = stringTokenizer.countTokens();
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            String string2 = (String)stringTokenizer.nextElement();
            stringArray[n2] = string2.trim();
            ++n2;
        }
        this.fileExtensions = stringArray;
    }

    private boolean isStarred(String string) {
        return string != null && string.length() > 0 && string.endsWith("/*");
    }

    public Object launch(URLConnection uRLConnection, InputStream inputStream, MimeTable mimeTable) throws ApplicationLaunchException {
        switch (this.action) {
            case 2: {
                try {
                    return inputStream;
                }
                catch (Exception exception) {
                    return "Load to file failed:\n" + exception;
                }
            }
            case 1: {
                try {
                    return uRLConnection.getContent();
                }
                catch (Exception exception) {
                    return null;
                }
            }
            case 3: {
                String string = this.command;
                int n = string.indexOf(32);
                if (n > 0) {
                    string = string.substring(0, n);
                }
                return new MimeLauncher(this, uRLConnection, inputStream, mimeTable.getTempFileTemplate(), string);
            }
            case 0: {
                return null;
            }
        }
        return null;
    }

    public boolean matches(String string) {
        if (this.starred) {
            return string.startsWith(this.typeName);
        }
        return string.equals(this.typeName);
    }

    public Object clone() {
        MimeEntry mimeEntry = new MimeEntry(this.typeName);
        mimeEntry.action = this.action;
        mimeEntry.command = this.command;
        mimeEntry.description = this.description;
        mimeEntry.imageFileName = this.imageFileName;
        mimeEntry.tempFileNameTemplate = this.tempFileNameTemplate;
        mimeEntry.fileExtensions = this.fileExtensions;
        return mimeEntry;
    }

    public synchronized String toProperty() {
        String string;
        String string2;
        String string3;
        StringBuffer stringBuffer = new StringBuffer();
        String string4 = "; ";
        boolean bl = false;
        int n = this.getAction();
        if (n != 0) {
            stringBuffer.append("action=" + actionKeywords[n]);
            bl = true;
        }
        if ((string3 = this.getLaunchString()) != null && string3.length() > 0) {
            if (bl) {
                stringBuffer.append(string4);
            }
            stringBuffer.append("application=" + string3);
            bl = true;
        }
        if (this.getImageFileName() != null) {
            if (bl) {
                stringBuffer.append(string4);
            }
            stringBuffer.append("icon=" + this.getImageFileName());
            bl = true;
        }
        if ((string2 = this.getExtensionsAsList()).length() > 0) {
            if (bl) {
                stringBuffer.append(string4);
            }
            stringBuffer.append("file_extensions=" + string2);
            bl = true;
        }
        if ((string = this.getDescription()) != null && !string.equals(this.getType())) {
            if (bl) {
                stringBuffer.append(string4);
            }
            stringBuffer.append("description=" + string);
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return "MimeEntry[contentType=" + this.typeName + ", image=" + this.imageFileName + ", action=" + this.action + ", command=" + this.command + ", extensions=" + this.getExtensionsAsList() + "]";
    }
}

