/*
 * Decompiled with CFR 0.152.
 */
package sunw.hotjava.ui;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Point;
import java.awt.ScrollPane;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import sunw.hotjava.misc.HJBProperties;
import sunw.hotjava.ui.BrowserListCanvas;
import sunw.hotjava.ui.Folder;
import sunw.hotjava.ui.HotCanvas;
import sunw.hotjava.ui.HotList;
import sunw.hotjava.ui.HotListEntry;
import sunw.hotjava.ui.HotListEvent;
import sunw.hotjava.ui.HotListFrame;
import sunw.hotjava.ui.HotListListener;
import sunw.hotjava.ui.ListItem;

class ListPanel
extends Panel {
    Label message;
    Panel listPanel;
    ScrollPane listPane;
    HotListFrame frm;
    BrowserListCanvas listCanvas;
    HotList hotlist;

    public ListPanel(HotListFrame hotListFrame) {
        this.frm = hotListFrame;
        this.setLayout(new BorderLayout());
        this.listPanel = new Panel();
        this.listPane = new ScrollPane();
        this.listPane.add(this.listPanel);
        this.add("Center", this.listPane);
        this.message = new Label("");
        this.add("South", this.message);
        HJBProperties hJBProperties = HJBProperties.getHJBProperties("hjbrowser");
        this.listPanel.setBackground(hJBProperties.getColor("hotlistframe.bgcolor", null));
        this.listPane.setBackground(hJBProperties.getColor("hotjava.background", null));
    }

    public Dimension getPreferredSize() {
        int n = this.frm.getListImage().getHeight(this);
        return new Dimension(this.getSize().width, n * 12);
    }

    public HotListFrame getHotListFrame() {
        return this.frm;
    }

    public HotCanvas getCanvas() {
        return this.listCanvas;
    }

    public void setLabelName(String string) {
        this.message.setText(string);
    }

    public void initialize() {
        this.hotlist = this.frm.getHotList();
        String string = this.frm.getListName();
        int n = this.getSize().width;
        int n2 = this.getSize().height;
        this.listCanvas = new BrowserListCanvas(this.hotlist, this.listPanel, string, n, n2, this.frm);
        ComponentListener componentListener = this.listCanvas.getListener();
        this.listPane.addComponentListener(componentListener);
        this.listCanvas.setListElementImage(this.frm.getBookImage());
        this.listCanvas.setListContainerImages(this.frm.getListImage(), this.frm.getListImage());
        this.listCanvas.createInitialFolder();
        this.listCanvas.initialize(this.hotlist.getRegularFolder());
        this.invalidate();
        this.listPanel.setLayout(new BorderLayout());
        this.listPanel.add("West", this.listCanvas);
        this.listPanel.setSize(this.listCanvas.getPreferredSize());
        this.validate();
        1 var5_5 = new 1();
        this.addMouseListener(var5_5);
        2 var6_6 = new 2();
        this.addMouseMotionListener(var6_6);
        this.hotlist.addHotListListener(new HotListEventListener());
    }

    public ScrollPane getListPane() {
        return this.listPane;
    }

    private void redispatchEvent(MouseEvent mouseEvent) {
        Point point = mouseEvent.getComponent().getLocation();
        mouseEvent.translatePoint(point.x, point.y);
        this.frm.dispatchEvent(mouseEvent);
    }

    public void processListPanelMouseEvent(MouseEvent mouseEvent) {
        switch (mouseEvent.getID()) {
            case 501: {
                ListItem listItem = this.listCanvas.getSelectedItem();
                if (listItem == null) {
                    return;
                }
                if (!(listItem instanceof Folder)) {
                    return;
                }
                Folder folder = (Folder)listItem;
                if (mouseEvent.getClickCount() == 2 && !this.frm.readOnlyList) {
                    this.frm.renameContainer(folder, this.frm);
                    return;
                }
                this.frm.displayList(folder);
                return;
            }
            case 502: {
                this.frm.setMessage("");
                this.redispatchEvent(mouseEvent);
                return;
            }
            case 506: {
                this.redispatchEvent(mouseEvent);
                return;
            }
        }
    }

    public boolean processHotListEvent(HotListEvent hotListEvent) {
        Object object = hotListEvent.getArgument();
        HotListEntry hotListEntry = (HotListEntry)object;
        switch (hotListEvent.getID()) {
            case 53: {
                this.listCanvas.addEntry(hotListEntry, true);
                break;
            }
            case 54: {
                Folder folder = (Folder)this.listCanvas.getSelectedItemFolder();
                boolean bl = folder.closed();
                this.listCanvas.delItem(hotListEntry, true);
                if (bl) break;
                HotCanvas hotCanvas = this.frm.getFolderPanel().getCanvas();
                hotCanvas.setMainContainer(null);
                hotCanvas.repaint();
                break;
            }
            case 52: {
                this.listCanvas.changeFolderState(hotListEntry);
            }
        }
        return true;
    }

    public void notify(int n, Object object) {
    }

    private class HotListEventListener
    implements HotListListener {
        public void hotlistChanged(HotListEvent hotListEvent) {
            ListPanel.this.processHotListEvent(hotListEvent);
        }

        HotListEventListener() {
            ListPanel.this = ListPanel.this;
        }
    }

    private final class 1
    extends MouseAdapter {
        public void mousePressed(MouseEvent mouseEvent) {
            ListPanel.this.processListPanelMouseEvent(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            ListPanel.this.processListPanelMouseEvent(mouseEvent);
        }

        /* synthetic */ 1() {
        }
    }

    private final class 2
    extends MouseMotionAdapter {
        public void mouseDragged(MouseEvent mouseEvent) {
            ListPanel.this.processListPanelMouseEvent(mouseEvent);
        }

        /* synthetic */ 2() {
        }
    }
}

