/*
 * Decompiled with CFR 0.152.
 */
package sunw.hotjava.tags;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Panel;
import java.awt.Point;
import java.awt.PrintJob;
import java.awt.Rectangle;
import java.awt.image.ImageObserver;
import java.io.Serializable;
import java.util.BitSet;
import java.util.StringTokenizer;
import java.util.Vector;
import sunw.hotjava.bean.HotJavaBrowserBean;
import sunw.hotjava.doc.DocBusyException;
import sunw.hotjava.doc.DocItem;
import sunw.hotjava.doc.DocPanel;
import sunw.hotjava.doc.Document;
import sunw.hotjava.doc.DocumentFormatter;
import sunw.hotjava.doc.DocumentFormatterPanel;
import sunw.hotjava.doc.DocumentPanel;
import sunw.hotjava.doc.Formatter;
import sunw.hotjava.doc.TagItem;
import sunw.hotjava.tags.EdgeInfo;
import sunw.hotjava.tags.FRAME;
import sunw.hotjava.tags.FRAMESET;
import sunw.hotjava.tags.FramePanel;
import sunw.hotjava.tags.Resizable;
import sunw.hotjava.tags.ResizeRequestEvent;
import sunw.hotjava.tags.ResizeTracker;
import sunw.html.Attributes;

public class FrameSetPanel
extends Panel
implements DocPanel,
Resizable {
    public static final int DEFAULT_BORDER = 3;
    public static final int MAX_DESCENTANTS = 70;
    static final int ROWS = 0;
    static final int COLS = 1;
    static final int LEFT = 5;
    static final int RIGHT = 2;
    static final int ABOVE = 3;
    static final int BELOW = 4;
    Document doc;
    Document[] kids = new Document[4];
    int docKids;
    TagItem item;
    String[] rows;
    String[] cols;
    int[][] percentRowsAndCols;
    int[][] relativeRowsAndCols;
    int[][] absoluteRowsAndCols;
    int[] absoluteTotals;
    int[] relativeTotals;
    int[] percentTotals;
    Component[] frameList;
    private BitSet vertResizables;
    private BitSet horizResizables;
    private boolean hasBeenResized = false;
    int border;
    private int numDescendants;
    private FrameSetPanel resizeListener;
    private Point gridLoc;
    private DocumentPanel docPanel;

    FrameSetPanel(Formatter formatter, TagItem tagItem, int n) {
        this(formatter, tagItem, null, null, n, null);
    }

    FrameSetPanel(Formatter formatter, TagItem tagItem, String[] stringArray, String[] stringArray2, int n) {
        this(formatter, tagItem, stringArray, stringArray2, n, null);
    }

    FrameSetPanel(Formatter formatter, TagItem tagItem, String[] stringArray, String[] stringArray2, int n, Container container) {
        this.setLayout(null);
        this.doc = formatter.getDocument();
        this.item = tagItem;
        this.border = n;
        this.rows = this.parseRowColSpec("rows", tagItem.getAttributes(), stringArray);
        this.cols = this.parseRowColSpec("cols", tagItem.getAttributes(), stringArray2);
        this.initRowsAndCols();
        Container container2 = formatter.getParent();
        if (container != null) {
            container.add(this);
        } else if (container2 != null) {
            container2.add(this);
            if (container2 instanceof DocumentFormatterPanel) {
                this.docPanel = ((DocumentFormatterPanel)container2).getDocumentPanel();
                this.docPanel.dispatchDocumentEvent(1041, null);
            }
        }
        this.initComponents(this.rows.length, this.cols.length, formatter);
        formatter.addFrameSetPanel(this);
    }

    public FRAMESET getFrameSetTag() {
        return (FRAMESET)this.item;
    }

    private void initResizableVectors() {
        this.vertResizables = new BitSet(this.rows.length);
        this.horizResizables = new BitSet(this.cols.length);
        int n = 1;
        while (n < this.rows.length) {
            this.vertResizables.set(n);
            ++n;
        }
        int n2 = 1;
        while (n2 < this.cols.length) {
            this.horizResizables.set(n2);
            ++n2;
        }
    }

    public void setNotResizable(Point point) {
        if (point.y != 0) {
            this.vertResizables.clear(point.y);
        } else if (this.resizeListener != null) {
            this.resizeListener.setNotResizable(this.gridLoc, 2);
        }
        if (point.y != this.rows.length - 1) {
            this.vertResizables.clear(point.y + 1);
        } else if (this.resizeListener != null) {
            this.resizeListener.setNotResizable(this.gridLoc, 3);
        }
        if (point.x != 0) {
            this.horizResizables.clear(point.x);
        } else if (this.resizeListener != null) {
            this.resizeListener.setNotResizable(this.gridLoc, 0);
        }
        if (point.x != this.cols.length - 1) {
            this.horizResizables.clear(point.x + 1);
            return;
        }
        if (this.resizeListener != null) {
            this.resizeListener.setNotResizable(this.gridLoc, 1);
        }
    }

    public void setNotResizable(Point point, int n) {
        if (n == 2 && point.y != 0) {
            this.vertResizables.clear(point.y);
            return;
        }
        if (n == 3 && point.y != this.rows.length - 1) {
            this.vertResizables.clear(point.y + 1);
            return;
        }
        if (n == 0 && point.x != 0) {
            this.horizResizables.clear(point.x);
            return;
        }
        if (n == 1 && point.x != this.cols.length - 1) {
            this.horizResizables.clear(point.x + 1);
            return;
        }
        if (this.resizeListener != null) {
            this.resizeListener.setNotResizable(this.gridLoc, n);
        }
    }

    private void initRowsAndCols() {
        int n;
        int n2;
        if (this.rows == null || this.cols == null) {
            return;
        }
        this.percentRowsAndCols = new int[2][];
        this.relativeRowsAndCols = new int[2][];
        this.absoluteRowsAndCols = new int[2][];
        this.absoluteTotals = new int[2];
        this.relativeTotals = new int[2];
        this.percentTotals = new int[2];
        String[] stringArray = null;
        int n3 = 0;
        while (n3 < 2) {
            stringArray = n3 == 0 ? this.rows : this.cols;
            this.absoluteTotals[n3] = 0;
            this.relativeTotals[n3] = 0;
            this.percentTotals[n3] = 0;
            this.percentRowsAndCols[n3] = new int[stringArray.length];
            this.relativeRowsAndCols[n3] = new int[stringArray.length];
            this.absoluteRowsAndCols[n3] = new int[stringArray.length];
            n2 = 0;
            while (n2 < stringArray.length) {
                this.percentRowsAndCols[n3][n2] = -1;
                this.relativeRowsAndCols[n3][n2] = -1;
                this.absoluteRowsAndCols[n3][n2] = -1;
                n = stringArray[n2].indexOf("*");
                if (n != -1) {
                    int n4 = this.parseDigits(stringArray[n2].substring(0, n));
                    if (n4 > 0) {
                        this.relativeRowsAndCols[n3][n2] = n4;
                        int n5 = n3;
                        this.relativeTotals[n5] = this.relativeTotals[n5] + n4;
                    } else {
                        this.relativeRowsAndCols[n3][n2] = 1;
                        int n6 = n3;
                        this.relativeTotals[n6] = this.relativeTotals[n6] + 1;
                    }
                } else if (stringArray[n2].indexOf(37) != -1) {
                    this.percentRowsAndCols[n3][n2] = this.parseDigits(stringArray[n2]);
                    int n7 = n3;
                    this.percentTotals[n7] = this.percentTotals[n7] + this.percentRowsAndCols[n3][n2];
                } else {
                    this.absoluteRowsAndCols[n3][n2] = Integer.parseInt(stringArray[n2]);
                    int n8 = n3;
                    this.absoluteTotals[n8] = this.absoluteTotals[n8] + this.absoluteRowsAndCols[n3][n2];
                }
                ++n2;
            }
            ++n3;
        }
        n2 = 0;
        while (n2 < 2) {
            if (this.percentTotals[n2] > 100) {
                n = 0;
                while (n < this.percentRowsAndCols[n2].length) {
                    if (this.percentRowsAndCols[n2][n] > 0) {
                        this.percentRowsAndCols[n2][n] = this.percentRowsAndCols[n2][n] * 100 / this.percentTotals[n2];
                    }
                    ++n;
                }
                this.percentTotals[n2] = 100;
            }
            ++n2;
        }
    }

    private String[] parseRowColSpec(String string, Attributes attributes, String[] stringArray) {
        String string2 = "*";
        if (attributes != null) {
            if (attributes.get(string) != null) {
                string2 = attributes.get(string);
            } else if (stringArray != null) {
                return stringArray;
            }
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
        int n = stringTokenizer.countTokens();
        String[] stringArray2 = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray2[n2] = stringTokenizer.nextToken().trim();
            ++n2;
        }
        return stringArray2;
    }

    private String getFrameAttribute(String string, Attributes attributes, String string2) {
        String string3 = string2;
        if (attributes != null && (string3 = attributes.get(string)) == null) {
            string3 = string2;
        }
        return string3;
    }

    public void getAppletPanels(Vector vector) {
        int n = 0;
        while (n < this.frameList.length) {
            DocumentFormatter documentFormatter;
            Component component = this.frameList[n];
            if (component instanceof FramePanel && (documentFormatter = ((FramePanel)component).getFormatter()) != null) {
                documentFormatter.getAppletPanels(vector);
            }
            ++n;
        }
    }

    public Component[] getFrameList() {
        return this.frameList;
    }

    public void reload() {
        int n = 0;
        while (n < this.frameList.length) {
            Component component = this.frameList[n];
            if (component instanceof FramePanel) {
                ((FramePanel)component).reload();
            } else if (component instanceof FrameSetPanel) {
                ((FrameSetPanel)component).reload();
            }
            ++n;
        }
    }

    public void updateDocument() {
        ImageObserver imageObserver;
        if (this.docPanel != null) {
            this.docPanel.dispatchDocumentEvent(1041, null);
        }
        if (this.doc.isExpired()) {
            this.reload();
            return;
        }
        int n = 0;
        while (n < this.frameList.length) {
            imageObserver = this.frameList[n];
            if (imageObserver instanceof FramePanel) {
                ((FramePanel)imageObserver).updateDocument();
            } else if (imageObserver instanceof FrameSetPanel) {
                ((FrameSetPanel)imageObserver).updateDocument();
            }
            ++n;
        }
        if (this.docPanel != null && (imageObserver = this.docPanel.getFormatter()) != null) {
            ((Formatter)imageObserver).dispatchDocumentEvent(1042, null);
        }
    }

    protected HotJavaBrowserBean getContainingHotJavaBrowserBean() {
        return HotJavaBrowserBean.getContainingHotJavaBrowserBean(this);
    }

    private boolean isFramesetComponent(String string, int n) {
        if ("frame".equalsIgnoreCase(string)) {
            return true;
        }
        if ("noframes".equalsIgnoreCase(string)) {
            return false;
        }
        if ("frameset".equalsIgnoreCase(string)) {
            return n >= 0;
        }
        return false;
    }

    private void initComponents(int n, int n2, Formatter formatter) {
        this.frameList = new Component[n * n2];
        int n3 = this.item.getIndex();
        int n4 = n3 + this.item.getOffset();
        int n5 = 0;
        FrameSetPanel frameSetPanel = this.findTopFrameSet(formatter);
        int n6 = n3 + 1;
        int n7 = 0;
        while (n6 < n4) {
            DocItem docItem = this.doc.getItem(n6);
            int n8 = docItem.getOffset();
            if (docItem instanceof TagItem) {
                if (!this.isFramesetComponent(((TagItem)docItem).getName(), n8)) {
                    if (n8 >= 0) {
                        n6 += n8;
                    }
                } else {
                    Serializable serializable;
                    if (n7 >= this.frameList.length) {
                        this.makeRoomForUnspecifiedItems();
                        this.initRowsAndCols();
                    }
                    if (!frameSetPanel.checkAndRegisterDescendant()) break;
                    if (docItem instanceof FRAMESET) {
                        serializable = new FrameSetPanel(formatter, (TagItem)docItem, null, null, this.border, this);
                        this.frameList[n7++] = serializable;
                    } else if (docItem instanceof FRAME) {
                        serializable = (FRAME)docItem;
                        FramePanel framePanel = new FramePanel(formatter, (TagItem)serializable, this.border, this);
                        if (this.docKids % 4 == 0 && this.docKids != 0) {
                            Document[] documentArray = new Document[this.docKids + 4];
                            System.arraycopy(this.kids, 0, documentArray, 0, this.docKids);
                            this.kids = documentArray;
                        }
                        this.kids[this.docKids++] = framePanel.getDocument();
                        this.frameList[n7++] = framePanel;
                    }
                    n6 += n8;
                    n5 = n7;
                }
            }
            ++n6;
        }
        if (n5 < this.frameList.length) {
            this.removeSpaceOfUnspecifiedItems(this.frameList.length - n5);
            this.initRowsAndCols();
        }
        this.initResizableVectors();
        this.setFrameGridInfo();
    }

    private FrameSetPanel findTopFrameSet(Formatter formatter) {
        FrameSetPanel frameSetPanel = this;
        Container container = formatter.getParent();
        while (container != null) {
            if (container instanceof FrameSetPanel) {
                frameSetPanel = (FrameSetPanel)container;
            }
            container = container.getParent();
        }
        return frameSetPanel;
    }

    private boolean checkAndRegisterDescendant() {
        FrameSetPanel frameSetPanel = this;
        synchronized (frameSetPanel) {
            ++this.numDescendants;
            boolean bl = this.numDescendants <= 70;
            Object var3_3 = null;
            return bl;
        }
    }

    public void invalidateFrames() {
        int n = 0;
        while (n < this.docKids) {
            if (this.kids[n] != null) {
                this.kids[n].invalidateFrames();
            }
            ++n;
        }
        this.removeAll();
        this.kids = new Document[4];
        this.docKids = 0;
    }

    private void makeRoomForUnspecifiedItems() {
        Object[] objectArray;
        if (this.rows.length == 1 && this.rows[0].equals("100%")) {
            this.rows[0] = "*";
            objectArray = new String[this.rows.length + 1];
            System.arraycopy(this.rows, 0, objectArray, 0, this.rows.length);
            objectArray[this.rows.length] = "*";
            this.rows = objectArray;
        } else if (this.cols.length == 1 && this.cols[0].equals("100%")) {
            this.cols[0] = "*";
            objectArray = new String[this.cols.length + 1];
            System.arraycopy(this.cols, 0, objectArray, 0, this.cols.length);
            objectArray[this.cols.length] = "*";
            this.cols = objectArray;
        } else {
            objectArray = new String[this.rows.length + 1];
            System.arraycopy(this.rows, 0, objectArray, 0, this.rows.length);
            objectArray[this.rows.length] = "*";
            this.rows = objectArray;
        }
        objectArray = new Component[this.rows.length * this.cols.length];
        System.arraycopy(this.frameList, 0, objectArray, 0, this.frameList.length);
        this.frameList = objectArray;
    }

    private void removeSpaceOfUnspecifiedItems(int n) {
        Object[] objectArray;
        int n2 = n / this.cols.length;
        int n3 = n % this.cols.length;
        if (n2 > 0) {
            objectArray = new String[this.rows.length - n2];
            System.arraycopy(this.rows, 0, objectArray, 0, objectArray.length);
            this.rows = objectArray;
        }
        if (n3 > 0) {
            objectArray = new String[this.cols.length - n3];
            System.arraycopy(this.cols, 0, objectArray, 0, objectArray.length);
            this.cols = objectArray;
        }
        objectArray = new Component[this.rows.length * this.cols.length];
        System.arraycopy(this.frameList, 0, objectArray, 0, objectArray.length);
        this.frameList = objectArray;
    }

    private void setFrameGridInfo() {
        Resizable resizable = null;
        Point point = null;
        int n = 0;
        while (n < this.rows.length) {
            int n2 = 0;
            while (n2 < this.cols.length) {
                Component component = this.getFrameAt(n, n2);
                if (component instanceof Resizable) {
                    resizable = (Resizable)((Object)component);
                    point = new Point(n2, n);
                    resizable.setResizeListener(this, point);
                }
                ++n2;
            }
            ++n;
        }
    }

    Component getFrameAt(int n, int n2) {
        int n3 = n * this.cols.length + n2;
        return this.frameList[n3];
    }

    public void activateSubItems() {
        int n = this.frameList.length;
        while (n-- > 0) {
            Component component = this.frameList[n];
            if (component == null) continue;
            ((DocPanel)((Object)component)).activateSubItems();
        }
    }

    public void start() {
        int n = this.frameList.length;
        while (n-- > 0) {
            Component component = this.frameList[n];
            if (component == null) continue;
            ((DocPanel)((Object)component)).start();
        }
    }

    public void stop() {
        int n = this.frameList.length;
        while (n-- > 0) {
            Component component = this.frameList[n];
            if (component == null) continue;
            ((DocPanel)((Object)component)).stop();
        }
    }

    public void destroy() {
        int n = this.frameList.length;
        while (n-- > 0) {
            Component component = this.frameList[n];
            if (component == null) continue;
            ((DocPanel)((Object)component)).destroy();
        }
    }

    public void setObsolete(boolean bl) {
        int n = this.frameList.length;
        while (n-- > 0) {
            Component component = this.frameList[n];
            if (component == null) continue;
            ((DocPanel)((Object)component)).setObsolete(bl);
        }
    }

    public void interruptLoading() {
        int n = this.frameList.length;
        while (n-- > 0) {
            Component component = this.frameList[n];
            if (component == null) continue;
            ((DocPanel)((Object)component)).interruptLoading();
        }
    }

    public void notify(Document document, int n, int n2, int n3) {
    }

    public void reformat() {
        int n = 0;
        while (n < this.frameList.length) {
            ((DocumentPanel)this.frameList[n]).reformat();
            ++n;
        }
    }

    public int findYFor(int n) {
        return 0;
    }

    void spread(int n, int n2, int[] nArray) {
        if (n == 0 || nArray.length == 0) {
            return;
        }
        int n3 = 0;
        int n4 = n;
        int n5 = 0;
        while (n5 < nArray.length) {
            if (this.absoluteRowsAndCols[n2][n5] > 0) {
                nArray[n5] = this.absoluteRowsAndCols[n2][n5];
                n4 -= nArray[n5];
            }
            ++n5;
        }
        n3 = n4;
        int n6 = 0;
        while (n6 < nArray.length) {
            if (this.percentRowsAndCols[n2][n6] > 0 && n3 > 0) {
                nArray[n6] = n3 * this.percentRowsAndCols[n2][n6] / 100;
                n4 -= nArray[n6];
            } else if (this.percentRowsAndCols[n2][n6] > 0 && n3 <= 0) {
                nArray[n6] = n / nArray.length;
                n4 -= nArray[n6];
            }
            ++n6;
        }
        if (n4 > 0 && this.relativeTotals[n2] > 0) {
            int n7 = 0;
            while (n7 < nArray.length) {
                if (this.relativeRowsAndCols[n2][n7] > 0) {
                    nArray[n7] = n4 * this.relativeRowsAndCols[n2][n7] / this.relativeTotals[n2];
                }
                ++n7;
            }
            return;
        }
        if (n4 != 0) {
            float f = n - n4;
            float[] fArray = new float[nArray.length];
            n4 = n;
            int n8 = 0;
            while (n8 < nArray.length) {
                fArray[n8] = (float)nArray[n8] / f * 100.0f;
                nArray[n8] = (int)((float)n * fArray[n8] / 100.0f);
                n4 -= nArray[n8];
                ++n8;
            }
            int n9 = 0;
            while (n4 != 0) {
                if (n4 < 0) {
                    int n10 = n9++;
                    nArray[n10] = nArray[n10] - 1;
                    ++n4;
                } else {
                    int n11 = n9++;
                    nArray[n11] = nArray[n11] + 1;
                    --n4;
                }
                if (n9 < nArray.length) continue;
                n9 = 0;
            }
        }
    }

    public Dimension minimumSize() {
        return this.getSize();
    }

    public Dimension preferredSize() {
        return this.getSize();
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        this.hasBeenResized = false;
        Rectangle rectangle = this.getBounds();
        super.setBounds(n, n2, n3, n4);
        this.changeBounds(n - rectangle.x, n2 - rectangle.y, n3 - rectangle.width, n4 - rectangle.height);
    }

    public void layout() {
        if (!this.hasBeenResized) {
            Dimension dimension = this.getSize();
            int[] nArray = new int[this.cols.length];
            this.spread(dimension.width, 1, nArray);
            int[] nArray2 = new int[this.rows.length];
            this.spread(dimension.height, 0, nArray2);
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            while (n < this.rows.length) {
                int n4 = 0;
                int n5 = 0;
                while (n4 < this.cols.length) {
                    Component component = this.frameList[n2];
                    if (component != null) {
                        component.setBounds(n5, n3, nArray[n4], nArray2[n]);
                    }
                    n5 += nArray[n4++];
                    ++n2;
                }
                n3 += nArray2[n++];
            }
            super.layout();
        }
    }

    public void print(PrintJob printJob, HotJavaBrowserBean hotJavaBrowserBean) throws DocBusyException {
        int n = this.frameList.length;
        int n2 = 0;
        while (n2 < n) {
            Component component = this.frameList[n2];
            if (component != null) {
                if (component instanceof FrameSetPanel) {
                    ((FrameSetPanel)component).print(printJob, hotJavaBrowserBean);
                } else if (component instanceof DocumentPanel) {
                    ((DocumentPanel)component).print(printJob, hotJavaBrowserBean);
                } else if (component instanceof FramePanel) {
                    ((FramePanel)component).print(printJob, hotJavaBrowserBean);
                }
            }
            ++n2;
        }
    }

    int parseDigits(String string) {
        int n = 0;
        int n2 = 0;
        while (n2 < string.length()) {
            char c = string.charAt(n2);
            if (Character.isDigit(c)) {
                n = n * 10 + Character.digit(c, 10);
            }
            ++n2;
        }
        return n;
    }

    void unsafeValidate() {
        this.validateTree();
    }

    public void setResizeListener(FrameSetPanel frameSetPanel, Point point) {
        this.resizeListener = frameSetPanel;
        this.gridLoc = point;
        this.setFrameGridInfo();
    }

    void handleResizeEvent(ResizeRequestEvent resizeRequestEvent) {
        int n;
        BitSet bitSet = this.horizResizables;
        int n2 = this.gridLoc != null ? this.gridLoc.x : -1;
        int n3 = this.cols.length;
        if (resizeRequestEvent.isVertical()) {
            n2 = this.gridLoc != null ? this.gridLoc.y : -1;
            bitSet = this.vertResizables;
            n3 = this.rows.length;
        }
        if ((n = resizeRequestEvent.getValue()) == 0) {
            if (this.resizeListener != null) {
                this.resizeListener.handleResizeEvent(new ResizeRequestEvent(resizeRequestEvent, n2));
            }
            return;
        }
        if (n == n3) {
            if (this.resizeListener != null) {
                this.resizeListener.handleResizeEvent(new ResizeRequestEvent(resizeRequestEvent, n2 + 1));
            }
            return;
        }
        if (bitSet.get(n)) {
            this.setupResizeTracker(resizeRequestEvent);
        }
    }

    private void setupResizeTracker(ResizeRequestEvent resizeRequestEvent) {
        Rectangle rectangle;
        Object object;
        int n = resizeRequestEvent.getValue();
        if (resizeRequestEvent.isVertical()) {
            object = this.getFrameAt(n - 1, 0);
            Rectangle rectangle2 = ((Component)object).getBounds();
            Component component = this.getFrameAt(n, 0);
            Rectangle rectangle3 = component.getBounds();
            int n2 = this.getVerLimit(n, 3);
            int n3 = this.getVerLimit(n, 4);
            Dimension dimension = this.getSize();
            rectangle = new Rectangle(rectangle2.x, rectangle3.y - n2, dimension.width, n2 + n3);
        } else {
            object = this.getFrameAt(0, n - 1);
            Rectangle rectangle4 = ((Component)object).getBounds();
            Component component = this.getFrameAt(0, n);
            Rectangle rectangle5 = component.getBounds();
            int n4 = this.getHorLimit(n, 5);
            int n5 = this.getHorLimit(n, 2);
            Dimension dimension = this.getSize();
            rectangle = new Rectangle(rectangle5.x - n4, rectangle4.y, n4 + n5, dimension.height);
        }
        object = new EdgeInfo(resizeRequestEvent.isVertical(), resizeRequestEvent.getValue());
        new ResizeTracker(resizeRequestEvent.getLocation(), rectangle, this, (Component)resizeRequestEvent.getSource(), (EdgeInfo)object);
    }

    void resizeFrames(EdgeInfo edgeInfo, Point point) {
        this.hasBeenResized = true;
        if (edgeInfo.isVertical()) {
            int n = edgeInfo.getValue();
            int n2 = point.y;
            int n3 = 0;
            while (n3 < this.cols.length) {
                Component component = this.getFrameAt(n - 1, n3);
                Rectangle rectangle = component.getBounds();
                rectangle.height = n2 - rectangle.y;
                component.setBounds(rectangle);
                Component component2 = this.getFrameAt(n, n3);
                Rectangle rectangle2 = component2.getBounds();
                rectangle2.height += rectangle2.y - n2;
                rectangle2.y = n2;
                component2.setBounds(rectangle2);
                ++n3;
            }
        } else {
            int n = edgeInfo.getValue();
            int n4 = point.x;
            int n5 = 0;
            while (n5 < this.rows.length) {
                Component component = this.getFrameAt(n5, n - 1);
                Rectangle rectangle = component.getBounds();
                rectangle.width = n4 - rectangle.x;
                component.setBounds(rectangle);
                Component component3 = this.getFrameAt(n5, n);
                Rectangle rectangle3 = component3.getBounds();
                rectangle3.width += rectangle3.x - n4;
                rectangle3.x = n4;
                component3.setBounds(rectangle3);
                ++n5;
            }
        }
        this.validateFrames();
    }

    protected void validateFrames() {
        super.layout();
        Component[] componentArray = this.getComponents();
        int n = 0;
        while (n < componentArray.length) {
            Component component = componentArray[n];
            if (component instanceof FrameSetPanel) {
                ((FrameSetPanel)component).validateFrames();
            } else {
                component.validate();
            }
            ++n;
        }
    }

    protected void changeBounds(int n, int n2, int n3, int n4) {
        Rectangle rectangle;
        int n5;
        int n6;
        Component[] componentArray;
        if (n3 != 0) {
            if (n != 0) {
                componentArray = this.getFramesCol(0);
                n6 = 0;
                while (n6 < componentArray.length) {
                    Rectangle rectangle2 = componentArray[n6].getBounds();
                    rectangle2.width += n3;
                    componentArray[n6].setBounds(rectangle2);
                    ++n6;
                }
                int n7 = 1;
                while (n7 < this.cols.length) {
                    componentArray = this.getFramesCol(n7);
                    n5 = 0;
                    while (n5 < componentArray.length) {
                        rectangle = componentArray[n5].getBounds();
                        rectangle.x += n3;
                        componentArray[n5].setBounds(rectangle);
                        ++n5;
                    }
                    ++n7;
                }
            } else if (n == 0) {
                componentArray = this.getFramesCol(this.cols.length - 1);
                n6 = 0;
                while (n6 < componentArray.length) {
                    Rectangle rectangle3 = componentArray[n6].getBounds();
                    rectangle3.width += n3;
                    componentArray[n6].setBounds(rectangle3);
                    ++n6;
                }
            }
        }
        if (n4 != 0) {
            if (n2 == 0) {
                componentArray = this.getFramesRow(this.rows.length - 1);
                n6 = 0;
                while (n6 < componentArray.length) {
                    Rectangle rectangle4 = componentArray[n6].getBounds();
                    rectangle4.height += n4;
                    componentArray[n6].setBounds(rectangle4);
                    ++n6;
                }
                return;
            }
            componentArray = this.getFramesRow(0);
            n6 = 0;
            while (n6 < componentArray.length) {
                Rectangle rectangle5 = componentArray[n6].getBounds();
                rectangle5.height -= n2;
                componentArray[n6].setBounds(rectangle5);
                ++n6;
            }
            int n8 = 1;
            while (n8 < this.rows.length) {
                componentArray = this.getFramesRow(n8);
                n5 = 0;
                while (n5 < componentArray.length) {
                    rectangle = componentArray[n5].getBounds();
                    rectangle.y -= n2;
                    componentArray[n5].setBounds(rectangle);
                    ++n5;
                }
                ++n8;
            }
        }
    }

    protected Component[] getFramesCol(int n) {
        int n2 = this.cols.length;
        int n3 = this.rows.length;
        Component[] componentArray = new Component[n3];
        if (n <= n2) {
            int n4 = 0;
            while (n4 < n3) {
                componentArray[n4] = this.frameList[n4 * n2 + n];
                ++n4;
            }
            return componentArray;
        }
        return null;
    }

    protected Component[] getFramesRow(int n) {
        int n2 = this.cols.length;
        int n3 = this.rows.length;
        Component[] componentArray = new Component[n2];
        if (n <= n3) {
            int n4 = 0;
            while (n4 < n2) {
                componentArray[n4] = this.frameList[n * n2 + n4];
                ++n4;
            }
            return componentArray;
        }
        return null;
    }

    protected int getHorLimit(int n, int n2) {
        Component[] componentArray = this.getFramesCol(n + (n2 == 5 ? -1 : 0));
        int n3 = componentArray[0].getBounds().width;
        int n4 = 0;
        while (n4 < componentArray.length) {
            if (componentArray[n4] instanceof FrameSetPanel) {
                FrameSetPanel frameSetPanel = (FrameSetPanel)componentArray[n4];
                int n5 = n2 == 5 ? frameSetPanel.cols.length : 0;
                int n6 = frameSetPanel.getHorLimit(n5, n2);
                n3 = n6 < n3 ? n6 : n3;
            }
            ++n4;
        }
        return n3;
    }

    protected int getVerLimit(int n, int n2) {
        Component[] componentArray = this.getFramesRow(n + (n2 == 3 ? -1 : 0));
        int n3 = componentArray[0].getBounds().height;
        int n4 = 0;
        while (n4 < componentArray.length) {
            if (componentArray[n4] instanceof FrameSetPanel) {
                FrameSetPanel frameSetPanel = (FrameSetPanel)componentArray[n4];
                int n5 = n2 == 3 ? frameSetPanel.rows.length : 0;
                int n6 = frameSetPanel.getVerLimit(n5, n2);
                n3 = n6 < n3 ? n6 : n3;
            }
            ++n4;
        }
        return n3;
    }
}

