/*
 * Decompiled with CFR 0.152.
 */
package sunw.hotjava.security;

import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.Identity;
import java.security.Principal;
import java.util.Hashtable;
import sunw.hotjava.security.AppletSecurityException;
import sunw.hotjava.security.CommonSecurity;
import sunw.hotjava.security.ExtPermissions;
import sunw.hotjava.security.SiteIdentity;

public abstract class BasePolicy {
    public static final boolean ACTION_ALLOWED = true;
    public static final boolean ACTION_DISALLOWED = false;
    static CommonSecurity csm;
    private static Hashtable extPermissionsTable;

    protected CommonSecurity getCSM() {
        if (csm != null) {
            return csm;
        }
        csm = CommonSecurity.getCommonSecurity();
        return csm;
    }

    static final void resetPermissions() {
        extPermissionsTable.clear();
    }

    final ExtPermissions findPermissions() {
        Principal principal = this.getCallerIdentity();
        return this.findPermissions(principal);
    }

    protected final ExtPermissions findPermissions(Object object) {
        if (object == null) {
            return null;
        }
        if (extPermissionsTable == null) {
            return null;
        }
        return (ExtPermissions)extPermissionsTable.get(object);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    ExtPermissions obtainPermissions() {
        Hashtable hashtable = extPermissionsTable;
        synchronized (hashtable) {
            Principal principal = this.getCallerIdentity();
            if (principal == null) {
                return null;
            }
            ExtPermissions extPermissions = this.findPermissions(principal);
            if (extPermissions != null) {
                return extPermissions;
            }
            extPermissions = new ExtPermissions();
            if (extPermissions == null) {
                return null;
            }
            extPermissionsTable.put(principal, extPermissions);
            return extPermissions;
        }
    }

    protected final Principal getCallerIdentity() throws AppletSecurityException {
        Class clazz = this.getCSM().currentLoadedClassSec();
        Object[] objectArray = null;
        Principal principal = null;
        objectArray = clazz.getSigners();
        if (objectArray == null) {
            String string = this.getCSM().getAppletHost();
            if (string != null) {
                principal = new SiteIdentity(string);
            }
        } else {
            principal = (Identity)objectArray[0];
        }
        return principal;
    }

    String getRealPath(String string) {
        String string2 = null;
        try {
            string2 = new File(string).getCanonicalPath();
        }
        catch (IOException iOException) {
            if (File.separatorChar == '/' && string.startsWith("~")) {
                try {
                    string = String.valueOf(new File("~").getCanonicalPath()) + string.substring(1);
                }
                catch (IOException iOException2) {}
            }
            string2 = new File(string).getAbsolutePath();
        }
        return string2;
    }

    boolean testConnect(String string, String string2, boolean bl) {
        if (!string.equals(string2)) {
            try {
                boolean bl2;
                boolean bl3 = string2 == null || "".equals(string2);
                boolean bl4 = bl2 = string == null || "".equals(string);
                if (bl3 != bl2) {
                    return false;
                }
                InetAddress inetAddress = InetAddress.getByName(string2);
                InetAddress inetAddress2 = InetAddress.getByName(string);
                return inetAddress2.equals(inetAddress);
            }
            catch (UnknownHostException unknownHostException) {
                return false;
            }
        }
        try {
            InetAddress inetAddress = InetAddress.getByName(string2);
            return true;
        }
        catch (UnknownHostException unknownHostException) {
            return bl;
        }
    }

    public abstract boolean checkAccess(Thread var1);

    public abstract boolean checkAccess(ThreadGroup var1);

    public abstract boolean checkLink(String var1);

    public abstract boolean checkPackageAccess(String var1);

    public abstract boolean checkPackageDefinition(String var1);

    public abstract boolean checkSetFactory();

    public abstract boolean checkMemberAccess(Class var1, int var2, int var3);

    public abstract boolean checkAwtEventQueueAccess();

    public abstract boolean checkSecurityAccess(String var1);

    public abstract boolean checkFrameAccess();

    public abstract boolean checkExit(int var1);

    public abstract boolean checkExec(String var1);

    public abstract boolean checkPropertiesAccess();

    public abstract boolean checkPropertyAccess(String var1);

    public abstract boolean checkRead(String var1, URL var2);

    public abstract boolean checkWrite(String var1);

    public abstract boolean checkRead(FileDescriptor var1);

    public abstract boolean checkWrite(FileDescriptor var1);

    public abstract boolean checkDelete(String var1);

    public abstract boolean checkListen(int var1);

    public abstract boolean checkAccept(String var1, int var2);

    public abstract boolean checkMulticast(InetAddress var1);

    public abstract boolean checkConnect(String var1, int var2);

    public abstract boolean checkTopLevelWindow(Object var1);

    public abstract boolean checkRun();

    public abstract boolean checkPrintJobAccess();

    public abstract boolean checkSystemClipboardAccess();

    public boolean hasPermissions(Principal principal) {
        return false;
    }

    static {
        extPermissionsTable = new Hashtable();
    }
}

