/*
 * Decompiled with CFR 0.152.
 */
package sunw.hotjava.doc;

import java.awt.Font;
import java.awt.Graphics;
import java.io.IOException;
import sunw.hotjava.doc.DocItem;
import sunw.hotjava.doc.DocLine;
import sunw.hotjava.doc.DocStyle;
import sunw.hotjava.doc.Document;
import sunw.hotjava.doc.Formatter;
import sunw.hotjava.doc.StyleSheet;
import sunw.html.Attributes;
import sunw.html.Element;
import sunw.html.HTMLOutputWriter;
import sunw.html.Tag;

public class TagItem
extends DocItem
implements Tag {
    protected StyleSheet style;
    protected Attributes atts;
    private boolean hasJavaScript = false;
    private boolean checkedJavaScript = false;
    protected String[] handlerStrings;

    public TagItem getTag(Document document) {
        return this;
    }

    public Font getFont() {
        if (this.style.fontName != null) {
            return Font.decode(this.style.fontName);
        }
        return null;
    }

    public Element getElement() {
        return this.style.elem;
    }

    public Attributes getAttributes() {
        return this.atts;
    }

    public String getAttribute(String string) {
        if (this.atts != null) {
            return this.atts.get(string);
        }
        return null;
    }

    public void setAttribute(String string, String string2) {
        if (this.atts == null) {
            this.atts = new Attributes();
        }
        this.atts.put(string, string2);
    }

    public String getType() {
        return this.style.type;
    }

    public boolean isStart() {
        return this.offset > 0;
    }

    public boolean isPreformatted() {
        return false;
    }

    public void init(Document document) {
    }

    public String getName() {
        return this.style.elem.getName();
    }

    public void modifyStyle(DocStyle docStyle) {
        this.style.apply(docStyle);
    }

    public String getLinkTarget() {
        String string = null;
        Attributes attributes = this.getAttributes();
        if (attributes != null && attributes.get("target") != null) {
            string = attributes.get("target").toLowerCase();
        }
        return string;
    }

    public void write(HTMLOutputWriter hTMLOutputWriter) throws IOException {
        hTMLOutputWriter.emptyTag(this);
    }

    public void writeStartTag(HTMLOutputWriter hTMLOutputWriter) throws IOException {
        hTMLOutputWriter.startTag(this);
    }

    public void writeEndTag(HTMLOutputWriter hTMLOutputWriter) throws IOException {
        hTMLOutputWriter.endTag(this);
    }

    public int paintEndTag(Formatter formatter, Graphics graphics, int n, int n2, DocLine docLine) {
        formatter.displayPos += 4096;
        return 0;
    }

    protected static final int parseInt(Attributes attributes, String string, int n, int n2) {
        String string2 = attributes.get(string);
        if (string2 != null) {
            try {
                return Math.max(Integer.parseInt(string2), n);
            }
            catch (NumberFormatException numberFormatException) {
            }
        }
        return n2;
    }

    public String tagString() {
        if (this.isStart()) {
            return "<" + this.elementString(false) + ">";
        }
        if (this.isEnd()) {
            return "</" + this.elementString(true) + ">";
        }
        return "[" + this.elementString(false) + "]";
    }

    protected String elementString(boolean bl) {
        return this.getName();
    }

    public String toString() {
        return String.valueOf(this.tagString()) + ", " + super.toString();
    }

    public String filterString(String string) {
        if (string == null) {
            return null;
        }
        int n = string.length();
        int n2 = 0;
        char[] cArray = new char[n];
        char[] cArray2 = new char[n];
        string.getChars(0, n, cArray2, 0);
        int n3 = 0;
        while (n3 < n) {
            if (cArray2[n3] > ' ') {
                cArray[n2++] = cArray2[n3];
            }
            ++n3;
        }
        return new String(cArray, 0, n2);
    }

    public boolean hasJavaScriptHandlers() {
        if (!this.checkedJavaScript) {
            this.checkedJavaScript = true;
            this.hasJavaScript = this.determineIfTagHasHandlers();
        }
        return this.hasJavaScript;
    }

    protected boolean determineIfTagHasHandlers() {
        Attributes attributes = this.getAttributes();
        if (attributes == null || this.handlerStrings == null) {
            return false;
        }
        int n = 0;
        while (n < this.handlerStrings.length) {
            if (attributes.get(this.handlerStrings[n]) != null) {
                return true;
            }
            ++n;
        }
        return false;
    }
}

