/*
 * Decompiled with CFR 0.152.
 */
package com.sun.nfs;

import com.sun.nfs.Buffer;
import com.sun.nfs.Fattr;
import com.sun.nfs.NfsException;
import com.sun.rpc.Rpc;
import java.io.IOException;
import java.util.Hashtable;

public abstract class Nfs {
    byte[] fh;
    Rpc rpc;
    String name;
    String[] dircache;
    String symlink;
    Buffer[] bufferList;
    long cacheTime;
    int rsize;
    int wsize;
    private Object wbLock = new Object();
    static Hashtable cacheNfs = new Hashtable();
    static final int NFREG = 1;
    static final int NFDIR = 2;
    static final int NFLNK = 5;
    private static final int ASYNC = 0;
    private static final int SYNC = 2;
    int NRA;
    int NWB;
    int NWC;
    int nwb;
    int prevReadIndex = -1;
    int prevWriteIndex = -1;
    int maxIndexRead;
    long maxLength;
    static final int RBIT = 4;
    static final int WBIT = 2;

    abstract void checkAttr() throws IOException;

    abstract boolean cacheOK(long var1) throws IOException;

    abstract void getattr() throws IOException;

    abstract long mtime() throws IOException;

    abstract long length() throws IOException;

    abstract boolean exists() throws IOException;

    abstract boolean canWrite() throws IOException;

    abstract boolean canRead() throws IOException;

    abstract boolean isFile() throws IOException;

    abstract boolean isDirectory() throws IOException;

    abstract boolean isSymlink() throws IOException;

    abstract Fattr getAttr() throws IOException;

    abstract Nfs lookup(String var1) throws IOException;

    abstract void read_otw(Buffer var1) throws IOException;

    abstract int write_otw(Buffer var1) throws IOException;

    abstract String[] readdir() throws IOException;

    abstract String readlink() throws IOException;

    abstract Nfs create(String var1, long var2) throws IOException;

    abstract Nfs mkdir(String var1, long var2) throws IOException;

    abstract boolean remove(String var1) throws IOException;

    abstract boolean rename(Nfs var1, String var2, String var3) throws IOException;

    abstract boolean rmdir(String var1) throws IOException;

    abstract void fsinfo() throws IOException;

    abstract long commit(int var1, int var2) throws IOException;

    abstract void invalidate();

    byte[] getFH() {
        return this.fh;
    }

    static void cache_put(Nfs nfs) {
        cacheNfs.put(String.valueOf(nfs.rpc.conn.server) + ":" + nfs.name, nfs);
    }

    static Nfs cache_get(String string, String string2) {
        return (Nfs)cacheNfs.get(String.valueOf(string) + ":" + string2);
    }

    static void cache_remove(Nfs nfs, String string) {
        if (nfs.name.equals(".")) {
            cacheNfs.remove(String.valueOf(nfs.rpc.conn.server) + ":" + string);
            return;
        }
        cacheNfs.remove(String.valueOf(nfs.rpc.conn.server) + ":" + nfs.name + "/" + string);
    }

    /*
     * Unable to fully structure code
     */
    synchronized int read(byte[] var1_1, int var2_2, int var3_3, long var4_4) throws IOException {
        var6_5 = null;
        var8_6 = 0;
        var9_7 = 0;
        if (!this.cacheOK(this.cacheTime) && this.bufferList != null) {
            var10_8 = 0;
            while (var10_8 < this.bufferList.length) {
                if (var10_8 != this.prevWriteIndex) {
                    this.bufferList[var10_8] = null;
                }
                ++var10_8;
            }
            this.prevReadIndex = -1;
        }
        if (var4_4 < this.length()) ** GOTO lbl60
        return -1;
        while (var4_4 < this.length()) {
            block17: {
                if (this.bufferList == null) {
                    this.bufferList = new Buffer[(int)this.length() / this.rsize + 1];
                }
                if ((var7_9 = (int)var4_4 / this.rsize) > this.maxIndexRead) {
                    this.maxIndexRead = var7_9;
                }
                if (var7_9 != this.prevReadIndex) {
                    if (this.prevReadIndex >= 0 && this.prevReadIndex != this.prevWriteIndex) {
                        var6_5 = this.bufferList[this.prevReadIndex];
                        if (var6_5.status == 1) {
                            this.bufferList[this.prevReadIndex] = null;
                            var6_5.exit();
                        }
                        if (var7_9 == this.prevReadIndex + 1 && var7_9 >= this.maxIndexRead) {
                            var8_6 = this.NRA;
                        }
                    }
                    this.prevReadIndex = var7_9;
                }
                var10_8 = var7_9;
                while (var10_8 <= var7_9 + var8_6) {
                    if (var10_8 >= this.bufferList.length) break;
                    var6_5 = this.bufferList[var10_8];
                    if (var6_5 == null) {
                        var6_5 = new Buffer(this, var10_8 * this.rsize, this.rsize);
                        var6_5.startLoad();
                        this.bufferList[var10_8] = var6_5;
                    }
                    ++var10_8;
                }
                var6_5 = this.bufferList[var7_9];
                try {
                    var6_5.waitLoaded();
                }
                catch (NfsException var11_10) {
                    if (var11_10.error == 72) {
                        this.rsize = 8192;
                        this.bufferList = new Buffer[(int)this.length() / this.rsize + 1];
                        break block17;
                    }
                    throw var11_10;
                }
                var11_11 = var6_5.buflen;
                if (var11_11 < this.rsize && !var6_5.eof) {
                    this.rsize = var11_11;
                    this.bufferList = null;
                    this.prevReadIndex = -1;
                    this.prevWriteIndex = -1;
                } else {
                    var12_12 = var6_5.copyFrom(var1_1, var2_2, var4_4, var3_3);
                    var2_2 += var12_12;
                    var4_4 += (long)var12_12;
                    var3_3 -= var12_12;
                    var9_7 += var12_12;
                }
            }
            if (var3_3 > 0) continue;
        }
        return var9_7;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void beginWrite() {
        Object object = this.wbLock;
        synchronized (object) {
            while (true) {
                if (this.nwb < this.NWB) {
                    ++this.nwb;
                    return;
                }
                try {
                    this.wbLock.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    void endWrite() {
        Object object = this.wbLock;
        synchronized (object) {
            --this.nwb;
            this.wbLock.notify();
            return;
        }
    }

    synchronized void write(byte[] byArray, int n, int n2, long l) throws IOException {
        if (this.wsize == 0) {
            this.fsinfo();
        }
        if (this.bufferList == null) {
            long l2 = Math.max(this.length(), (long)(50 * this.wsize));
            this.bufferList = new Buffer[(int)l2 / this.wsize + 1];
        }
        while (n2 > 0) {
            int n3;
            Object object;
            int n4 = (int)l / this.wsize;
            if (n4 != this.prevWriteIndex) {
                if (this.prevWriteIndex >= 0) {
                    this.bufferList[this.prevWriteIndex].startUnload(0);
                    this.checkCommit(false);
                }
                this.prevWriteIndex = n4;
            }
            if (n4 >= this.bufferList.length) {
                object = new Buffer[this.bufferList.length * 2];
                n3 = 0;
                while (n3 < this.bufferList.length) {
                    object[n3] = this.bufferList[n3];
                    ++n3;
                }
                this.bufferList = object;
            }
            if ((object = this.bufferList[n4]) == null) {
                this.bufferList[n4] = object = new Buffer(this, n4 * this.wsize, this.wsize);
            }
            n3 = object.copyTo(byArray, n, l, n2);
            n += n3;
            n2 -= n3;
            if ((l += (long)n3) <= this.maxLength) continue;
            this.maxLength = l;
        }
    }

    void checkCommit(boolean bl) throws IOException {
        Buffer buffer;
        int n = Integer.MAX_VALUE;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n4 < this.bufferList.length) {
            buffer = this.bufferList[n4];
            if (buffer != null) {
                if (bl) {
                    buffer.waitUnloaded();
                }
                if (buffer.status == 1) {
                    if (n4 != this.prevReadIndex && n4 != this.prevWriteIndex) {
                        this.bufferList[n4] = null;
                        buffer.exit();
                    }
                } else if (buffer.status == 3) {
                    ++n3;
                    if (n4 < n) {
                        n = n4;
                    }
                    if (n4 > n2) {
                        n2 = n4;
                    }
                }
            }
            ++n4;
        }
        if (bl && (buffer = this.bufferList[this.prevWriteIndex]) != null && buffer.status == 2) {
            if (n3 == 0) {
                buffer.startUnload(2);
                buffer.waitUnloaded();
            } else {
                buffer.startUnload(0);
                buffer.waitUnloaded();
                if (this.prevWriteIndex < n) {
                    n = this.prevWriteIndex;
                }
                if (this.prevWriteIndex > n2) {
                    n2 = this.prevWriteIndex;
                }
            }
        }
        if (n3 > 0 && (bl || n3 >= this.NWC)) {
            int n5 = n * this.rsize + this.bufferList[n].minOffset;
            int n6 = n2 * this.rsize + this.bufferList[n2].maxOffset - n5;
            long l = this.commit(n5, n6);
            int n7 = n;
            while (n7 <= n2) {
                Buffer buffer2 = this.bufferList[n7];
                if (buffer2 != null) {
                    if (bl) {
                        buffer2.waitUnloaded();
                    }
                    if (buffer2.status == 3) {
                        if (buffer2.writeVerifier == l) {
                            if (n7 == this.prevReadIndex || n7 == this.prevWriteIndex) {
                                buffer2.status = 1;
                            } else {
                                this.bufferList[n7] = null;
                                buffer2.exit();
                            }
                        } else if (bl) {
                            buffer2.startUnload(2);
                            buffer2.waitUnloaded();
                        } else {
                            buffer2.startUnload(0);
                        }
                    }
                }
                ++n7;
            }
        }
    }

    public synchronized void flush() throws IOException {
        if (this.prevWriteIndex >= 0) {
            this.checkCommit(true);
        }
    }

    public synchronized void close() throws IOException {
        if (this.bufferList == null) {
            return;
        }
        this.flush();
        int n = 0;
        while (n < this.bufferList.length) {
            if (this.bufferList[n] != null) {
                Buffer buffer = this.bufferList[n];
                this.bufferList[n] = null;
                buffer.exit();
            }
            ++n;
        }
        this.prevReadIndex = -1;
        this.prevWriteIndex = -1;
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    public String toString() {
        try {
            if (this.isSymlink()) {
                if (this.symlink != null) {
                    return "\"" + this.name + "\": symlink -> \"" + this.symlink + "\"";
                }
                return "\"" + this.name + "\": symlink";
            }
            if (this.isDirectory()) {
                String string = "\":" + this.name + "\" directory";
                if (this.dircache != null) {
                    return String.valueOf(string) + "(" + this.dircache.length + " entries)";
                }
                return string;
            }
            return "\"" + this.name + "\": file (" + this.length() + " bytes)";
        }
        catch (IOException iOException) {
            return iOException.getMessage();
        }
    }
}

